<?php
session_start();
require '../config.php';
require '../functions.php';

if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_caja'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_caja'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_caja'),
];

$search = isset($_POST['search']) ? $_POST['search'] : '';
$startDate = isset($_POST['startDate']) ? $_POST['startDate'] : '';
$endDate = isset($_POST['endDate']) ? $_POST['endDate'] : '';
$type = isset($_POST['type']) ? $_POST['type'] : '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 10;
$offset = ($page - 1) * $limit;

function getEfectivos($pdo, $search = '', $startDate = '', $endDate = '', $type = '', $offset = 0, $limit = 10) {
    $params = [];
    $sql = "SELECT caja.*, usuarios.nombre, usuarios.apellido 
            FROM caja 
            JOIN usuarios ON caja.usuario_id = usuarios.id_usuario 
            WHERE 1=1";

    // Filtro de búsqueda
    if (!empty($search)) {
        $sql .= " AND (caja.tipo LIKE :search OR usuarios.nombre LIKE :search OR usuarios.apellido LIKE :search OR caja.id_caja LIKE :search)";
        $params[':search'] = "%$search%";
    }

    // Filtro por fechas
    if (!empty($startDate) && !empty($endDate)) {
        $sql .= " AND DATE(caja.fecha) BETWEEN :startDate AND :endDate";
        $params[':startDate'] = $startDate;
        $params[':endDate'] = $endDate;
    }

    // Filtro por tipo
    if (!empty($type)) {
        $sql .= " AND caja.tipo = :type";
        $params[':type'] = $type;
    }

    $sql .= " ORDER BY caja.id_caja DESC
              LIMIT :offset, :limit";

    $stmt = $pdo->prepare($sql);

    // Vincular parámetros
    foreach ($params as $key => $value) {
        $stmt->bindValue($key, $value);
    }

    // Vinculación para paginación
    $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
    $stmt->bindValue(':limit', (int)$limit, PDO::PARAM_INT);

    // Ejecutar la consulta
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Obtener los registros de caja con los filtros
$efectivos = getEfectivos($pdo, $search, $startDate, $endDate, $type, $offset, $limit);

// Contar el total de registros para la paginación
$totalSql = "SELECT COUNT(*) FROM caja 
             JOIN usuarios ON caja.usuario_id = usuarios.id_usuario 
             WHERE 1=1";

$params = [];

// Filtros de búsqueda, fechas y tipo
if (!empty($search)) {
    $totalSql .= " AND (caja.tipo LIKE :search OR usuarios.nombre LIKE :search OR usuarios.apellido LIKE :search OR caja.id_caja LIKE :search)";
    $params[':search'] = "%$search%";
}

if (!empty($startDate) && !empty($endDate)) {
    $totalSql .= " AND DATE(caja.fecha) BETWEEN :startDate AND :endDate";
    $params[':startDate'] = $startDate;
    $params[':endDate'] = $endDate;
}

if (!empty($type)) {
    $totalSql .= " AND caja.tipo = :type";
    $params[':type'] = $type;
}

$totalStmt = $pdo->prepare($totalSql);

foreach ($params as $key => $value) {
    $totalStmt->bindValue($key, $value);
}

$totalStmt->execute();
$totalRows = $totalStmt->fetchColumn();
$totalPages = ceil($totalRows / $limit);

// Generar el HTML para la tabla
foreach ($efectivos as $caja) {
    $badgeClass = $caja['tipo'] == 'apertura' ? 'badge-success' : 'badge-danger';
    $badgeText = $caja['tipo'] == 'apertura' ? 'Apertura' : 'Cierre';
    ?>
    <tr>
        <td><?php echo htmlspecialchars($caja['id_caja']); ?></td>
        <td>
            <span class="badge <?php echo $badgeClass; ?>"><?php echo $badgeText; ?></span>
        </td>
        <td><?php echo htmlspecialchars(formatMonto($moneda, $caja['monto'], 2)); ?></td>
        <td><?php echo htmlspecialchars($caja['fecha']); ?></td>
        <td><?php echo htmlspecialchars($caja['nombre']) . ' ' . htmlspecialchars($caja['apellido']); ?></td>
        <td>
        <?php if ($permisos['editar']) : ?>
            <button class="btn btn-warning btn-sm edit-btn" data-id="<?php echo $caja['id_caja']; ?>" data-toggle="modal" data-target="#editModal"><i class="fas fa-edit"></i></button>
            <?php endif; ?>
            <?php if ($permisos['eliminar']) : ?>
            <button class="btn btn-danger btn-sm delete-btn" data-id="<?php echo $caja['id_caja']; ?>"><i class="fas fa-trash-alt"></i></button>
            <?php endif; ?>
            <?php if ($caja['tipo'] == 'cierre'): ?>
                        <?php if ($permisos['ver']) : ?>
                    <button class="btn btn-info btn-sm reprint-btn" data-id="<?php echo $caja['id_caja']; ?>">
                        <i class="fas fa-print"></i>
                    </button>
                    <?php endif; ?>
                <?php endif; ?>
        </td>
    </tr>
    <?php
}
?>
