<?php
require '../config.php'; // Conexión a la base de datos

if (isset($_POST['title']) && isset($_POST['start']) && isset($_POST['end'])) {
    $title = $_POST['title'];
    $start = $_POST['start'];
    $end = $_POST['end'];

    try {
        $sql = "INSERT INTO reservaciones (title, start, end) VALUES (:title, :start, :end)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':start', $start);
        $stmt->bindParam(':end', $end);
        $stmt->execute();

        echo json_encode(['status' => 'success', 'message' => 'Evento agregado correctamente']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Faltan datos requeridos']);
}
?>
