<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si la caja está aperturada
if (!isCajaAperturada($pdo)) {
    header('Location: ../caja_no_aperturada.php');
    exit;
}

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calendario de Reservaciones</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.4.0/fullcalendar.css" />

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0-alpha.6/css/bootstrap.css" />

    

<style>

body {

margin-top: 40px;

text-align: center;

font-size: 14px;

font-family: "Lucida Grande",Helvetica,Arial,Verdana,sans-serif;

}
#calendar {
        max-width: 1200px; /* Cambia este valor según lo necesites */
        margin: 0 auto;    /* Centra el calendario horizontalmente */
    }

</style>
    </script>
    <style>
        .main-content {
            padding: 2rem;
        }
        .main-content h1 {
            font-size: 2.5rem;
            font-weight: 600;
            color: #343a40;
            text-align: center;
            margin-bottom: 2rem;
            position: relative;
        }
        .main-content h1::after {
            content: "";
            position: absolute;
            left: 50%;
            bottom: -10px;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background-color: #007bff;
            border-radius: 2px;
        }
        .search-results {
            border: 1px solid #ddd;
            max-height: 200px;
            overflow-y: auto;
            position: absolute;
            width: 100%;
            background-color: white;
            z-index: 1000;
        }
        .search-results div {
            padding: 8px;
            cursor: pointer;
        }
        .search-results div:hover {
            background-color: #f1f1f1;
        }
        highlight {
            background-color: #ffcccc; /* Rojo suave */
        }
        #calendar {
            max-width: 1100px;
            margin: 0 auto;
        }
        
    </style>
</head>
<body>
    <?php include '../menu.php'; ?>

    <div class="main-content">
        <div class="container text-center">
            <h1 class="mb-4">Calendario de Reservaciones</h1>
            <!-- Botón para abrir el modal -->
            <button type="button" class="btn btn-primary btn-lg d-inline-flex align-items-center" id="verHabitacionesBtn">
                <i class="fas fa-bed me-2"></i> Ver Habitaciones Disponibles
            </button>

            <div id="calendar" class="mt-4"></div>
        </div>

    </div>
 <!-- Modal para agregar una nueva renta -->
 <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="addModalLabel">Agregar Nueva Reservacción</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form id="addForm">
                                    <div class="form-group">
                                        <label for="addClienteInput">Cliente</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="addClienteInput" placeholder="Buscar cliente..." required autocomplete="off">
                                            <button type="button" class="btn btn-primary" id="addClienteButton">
                                                <i class="fas fa-plus"></i> Nuevo
                                            </button>
                                        </div>
                                        <div id="addClienteResults" class="search-results"></div>
                                        <input type="hidden" id="addClienteId" name="id_cliente"> <!-- Campo oculto para el ID del cliente -->
                                    </div>
                                    <div class="form-group">
                                        <label for="addAutoInput">Habitación</label>
                                        <input type="text" class="form-control" id="addAutoInput" placeholder="Buscar habitación..." required autocomplete="off">
                                        <div id="addAutoResults" class="search-results"></div>
                                        <input type="hidden" id="addAutoId" name="id_auto"> <!-- Campo oculto para el ID del habitacion -->
                                    </div>
                                    <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="addFechaRenta">Fecha Check-in</label>
                                        <input type="date" class="form-control" id="addFechaRenta" name="fecha_renta" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="addFechaDevolucion">Fecha Check-out</label>
                                        <input type="date" class="form-control" id="addFechaDevolucion" name="fecha_devolucion" required>
                                    </div>
                                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="addDias">Estadía</label>
                            <input type="text" class="form-control" id="addDias" name="dias" readonly>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="addPrecioTotal">Precio Total</label>
                            <input type="number" class="form-control" id="addPrecioTotal" name="precio_total" step="0.01" required autocomplete="off">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="addEstado">Estado</label>
                        <select class="form-control" id="addEstado" name="estado" required autocomplete="off">
                            <option value="Reservado">Reservada</option>
                            <option value="Check-in">Check-in</option>
                            <option value="Check-out">Check-out</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Agregar Reserva</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalAddCliente" tabindex="-1" role="dialog" aria-labelledby="modalAddClienteLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document"> <!-- modal-lg para tamaño grande -->
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalAddClienteLabel">Agregar Nuevo Cliente</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addClienteForm">
                    <div class="row">
                        <!-- Nombre -->
                        <div class="form-group col-md-6">
                            <label for="clienteNombre" class="form-label">Nombre</label>
                            <input type="text" class="form-control" id="clienteNombre" placeholder="Nombre" required autocomplete="off">
                        </div>
                        <!-- Apellido -->
                        <div class="form-group col-md-6">
                            <label for="clienteApellido" class="form-label">Apellido</label>
                            <input type="text" class="form-control" id="clienteApellido" placeholder="Apellido" required autocomplete="off">
                        </div>
                    </div>
                    
                    <div class="row">
                        <!-- Correo Electrónico -->
                        <div class="form-group col-md-6">
                            <label for="clienteEmail" class="form-label">Correo Electrónico</label>
                            <input type="email" class="form-control" id="clienteEmail" placeholder="Correo Electrónico" autocomplete="off">
                        </div>
                        <!-- Teléfono -->
                        <div class="form-group col-md-6">
                            <label for="clienteTelefono" class="form-label">Teléfono</label>
                            <input type="text" class="form-control" id="clienteTelefono" placeholder="Teléfono" autocomplete="off">
                        </div>
                    </div>
                    
                    <div class="row">
                        <!-- Documento Personal -->
                        <div class="form-group col-md-6">
                            <label for="clienteDocumento" class="form-label">Documento Personal</label>
                            <input type="text" class="form-control" id="clienteDocumento" placeholder="Documento (DNI, Pasaporte)" autocomplete="off">
                        </div>
                    </div>

                    <!-- Botón Guardar -->
                    <div class="text-end mt-3">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save"></i> Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.4.0/fullcalendar.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
    <!--<script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/locale/es.js"></script>-->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!--<script src="calendario.js"></script>-->
    <script>
     $(document).ready(function () {
    var date = new Date();
    var d = date.getDate();
    var m = date.getMonth();
    var y = date.getFullYear();

    var calendar = $('#calendar').fullCalendar({
        editable: true,
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay',
        },
        events: "get_events.php",
        eventRender: function (event, element, view) {
            event.allDay = event.allDay === 'true';
            var roomDetails = event.title.split(' - ');
            var roomName = roomDetails[0];
            var roomNumber = roomDetails[1];

            element.find('.fc-title').html(
                '<span class="badge badge-info">' + roomNumber + '</span> ' + roomName
            );

            element.css({
                'border': '1px solid ' + event.color,
                'border-radius': '5px',
            });

            element.find('.fc-title').css({
                'font-weight': 'bold',
                'font-size': '1.1em',
                'color': '#000',
            });
        },
        selectable: true,
        selectHelper: true,
        select: function (start, end, allDay) {
    // Obtener la fecha actual en formato "YYYY-MM-DD"
    var currentDate = new Date();
    var formattedCurrentDate = currentDate.toISOString().split('T')[0];

    // Obtener la fecha seleccionada en formato "YYYY-MM-DD"
    var selectedDate = start.toISOString().split('T')[0];

    // Comparar las fechas como cadenas
    if (selectedDate < formattedCurrentDate) {
        Swal.fire({
            icon: 'error',
            title: 'Fecha no válida',
            text: 'No se puede seleccionar una fecha en el pasado.',
            confirmButtonText: 'Aceptar'
        });
        calendar.fullCalendar('unselect');
        return;
    }

    // Formatear la fecha seleccionada para el campo del modal
    var startFormatted = $.fullCalendar.formatDate(start, "Y-MM-DD");
    $('#addModal').modal('show');
    $('#addFechaRenta').val(startFormatted);

    calendar.fullCalendar('unselect');
},
editable: true,

        // Configuración de puntos para días con muchos eventos
        eventLimit: true, // Activa el límite de eventos visibles por día.
        eventLimitText: "más", // Texto que aparecerá para indicar eventos adicionales.
        eventLimitClick: "popover", // Al hacer clic, muestra los eventos adicionales.

        eventDrop: function (event, delta) {
            var start = $.fullCalendar.formatDate(event.start, "Y-MM-DD HH:mm:ss");
            var end = $.fullCalendar.formatDate(event.end, "Y-MM-DD HH:mm:ss");

            $.ajax({
                url: 'update_events.php',
                data: 'title=' + event.title + '&start=' + start + '&end=' + end + '&id=' + event.id,
                type: "POST",
                success: function (json) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Actualización exitosa',
                        text: 'El evento se ha actualizado correctamente.',
                        confirmButtonText: 'Aceptar'
                    });
                },
            });
        },
        eventClick: function (event) {
            $.ajax({
                url: 'get_event_details.php',
                data: { id: event.id },
                type: 'GET',
                success: function(response) {
                    if (response.error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: response.error,
                            confirmButtonText: 'Aceptar'
                        });
                        return;
                    }
                    $('#eventRoomName').text(response.nombre_habitacion);
                    $('#eventRoomNumber').text(response.numero_habitacion);
                    $('#eventStart').text(response.fecha_renta);
                    $('#eventEnd').text(response.fecha_devolucion);
                    const clienteCompleto = response.cliente_nombre + ' ' + response.cliente_apellido;
                    $('#eventNombre').text(clienteCompleto);
                    $('#eventTelefono').text(response.cliente_telefono);
                    $('#eventEmail').text(response.cliente_email);

                    $('#eventModal').modal('show');
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Error al obtener los detalles del evento.',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        },
        eventResize: function (event) {
            var start = $.fullCalendar.formatDate(event.start, "Y-MM-DD HH:mm:ss");
            var end = $.fullCalendar.formatDate(event.end, "Y-MM-DD HH:mm:ss");

            $.ajax({
                url: 'update_events.php',
                data: 'title=' + event.title + '&start=' + start + '&end=' + end + '&id=' + event.id,
                type: "POST",
                success: function (json) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Actualización exitosa',
                        text: 'El evento se ha actualizado correctamente.',
                        confirmButtonText: 'Aceptar'
                    });
                },
            });
        },
    });

    // Evento para abrir el modal y cargar las habitaciones disponibles
    document.getElementById('verHabitacionesBtn').addEventListener('click', function () {
        // Realizar la solicitud AJAX para obtener las habitaciones disponibles
        fetch('obtenerHabitaciones.php')
            .then(response => response.json()) // Convertir la respuesta a formato JSON
            .then(data => {
                const habitacionesList = document.getElementById('habitacionesList');
                habitacionesList.innerHTML = ''; // Limpiar la tabla antes de llenarla

                if (data.length > 0) {
                    // Agrupar habitaciones por tipo
                    const habitacionesPorTipo = data.reduce((grupo, habitacion) => {
                        (grupo[habitacion.tipo] = grupo[habitacion.tipo] || []).push(habitacion);
                        return grupo;
                    }, {});

                    // Crear filas para cada tipo de habitación
                    for (const tipo in habitacionesPorTipo) {
                        // Agregar encabezado del tipo de habitación
                        const headerRow = document.createElement('tr');
                        headerRow.classList.add('table-primary'); // Estilo de encabezado
                        headerRow.innerHTML = `<th colspan="4" class="text-center">${tipo}</th>`;
                        habitacionesList.appendChild(headerRow);

                        // Agregar las habitaciones de este tipo
                        habitacionesPorTipo[tipo].forEach(habitacion => {
                            const row = document.createElement('tr');
                            row.innerHTML = 
                                `<td>${habitacion.nombre_habitacion}</td>
                                <td>${habitacion.numero_habitacion}</td>
                                <td>${habitacion.tipo}</td>
                                <td>$${parseFloat(habitacion.precio_diario).toFixed(2)}</td>`;
                            habitacionesList.appendChild(row);
                        });
                    }
                } else {
                    habitacionesList.innerHTML = 
                        `<tr>
                            <td colspan="4" class="text-center">No hay habitaciones disponibles.</td>
                        </tr>`;
                }

                // Mostrar el modal
                new bootstrap.Modal(document.getElementById('habitacionesModal')).show();
            })
            .catch(error => {
                console.error('Error al obtener las habitaciones:', error);
            });
    });

    // Función para la búsqueda
    function handleSearch(inputId, resultsId, searchUrl, idField) {
         $(inputId).on('keyup', function() {
             var search = $(this).val();
             $.ajax({
                 url: searchUrl,
                 type: 'POST',
                 data: { search: search },
                 success: function(response) {
                     $(resultsId).html(response).show();
                 }
             });
         });
 
         $(document).on('click', resultsId + ' div', function() {
             var value = $(this).text();
             var id = $(this).data('id');
             $(inputId).val(value);
             $('#' + idField).val(id);
             $(resultsId).hide();
         });
 
         $(document).on('click', function(event) {
             if (!$(event.target).closest(inputId).length && !$(event.target).closest(resultsId).length) {
                 $(resultsId).hide();
             }
         });
     }
 
     handleSearch('#addClienteInput', '#addClienteResults', 'search_clients.php', 'addClienteId');
     handleSearch('#addAutoInput', '#addAutoResults', 'search_autos.php', 'addAutoId');
 
 
// Función para obtener el precio diario
function getPrecioDiario(idAuto, callback) {
    $.ajax({
        url: 'get_habitacion_precio.php',
        type: 'POST',
        data: { id_habitacion: idAuto },
        dataType: 'json',
        success: function(response) {
            console.log('Respuesta del servidor:', response); // Depuración
            if (response.status === 'success') {
                callback(response.precio_diario);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'No se pudo obtener el precio de la habitación. Por favor, intente de nuevo.',
                });
            }
        },
        error: function(xhr, status, error) {
            console.error('Error AJAX:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error del servidor',
                text: 'Ocurrió un problema al comunicarse con el servidor.',
            });
        }
    });
}

// Función para calcular el precio total
function calcularPrecioTotal() {
    var fechaRenta = new Date($('#addFechaRenta').val());
    var fechaDevolucion = new Date($('#addFechaDevolucion').val());

    // Ajustar ambas fechas al inicio del día para ignorar horas
    fechaRenta.setHours(0, 0, 0, 0);
    fechaDevolucion.setHours(0, 0, 0, 0);

    console.log('Fechas ajustadas (sin horas):', fechaRenta, fechaDevolucion); // Depuración

    if (!validarFechas(fechaRenta, fechaDevolucion)) {
        Swal.fire({
            icon: 'warning',
            title: 'Fechas inválidas',
            text: 'Por favor, asegúrese de ingresar fechas válidas.',
        });
        $('#addDias').val('');
        $('#addPrecioTotal').val('');
        return;
    }

    if (!$('#addAutoId').val()) {
        // Limpiar campo de fecha de devolución
        $('#addFechaDevolucion').val('');
        
        Swal.fire({
            icon: 'error',
            title: 'Operación no permitida',
            text: 'Debe seleccionar una habitación antes de calcular el precio.',
        });
        $('#addDias').val('');
        $('#addPrecioTotal').val('');
        return;
    }

    // Calcular la diferencia en días completos, asegurando que se cuente correctamente
    var diferencia = Math.ceil((fechaDevolucion - fechaRenta) / (1000 * 60 * 60 * 24));

    if (diferencia >= 0) {
        $('#addDias').val(diferencia + ' días');

        // Obtener precio diario y calcular precio total
        getPrecioDiario($('#addAutoId').val(), function(precioDiario) {
            var precioTotal = diferencia * precioDiario;
            console.log('Precio total calculado:', precioTotal); // Depuración
            $('#addPrecioTotal').val(precioTotal.toFixed(2));
        });
    } else {
        Swal.fire({
            icon: 'warning',
            title: 'Fechas inválidas',
            text: 'La fecha de devolución debe ser posterior a la fecha de renta.',
        });
        $('#addDias').val('');
        $('#addPrecioTotal').val('');
    }
}

// Validar fechas
function validarFechas(fechaRenta, fechaDevolucion) {
    return fechaRenta instanceof Date && !isNaN(fechaRenta) &&
           fechaDevolucion instanceof Date && !isNaN(fechaDevolucion);
}

// Eventos para calcular precio total
$('#addFechaRenta, #addFechaDevolucion').on('change', calcularPrecioTotal);

// Manejo del cambio de auto
$('#addAutoInput').on('change', function() {
    var idAuto = $('#addAutoId').val();
    console.log('Auto seleccionado:', idAuto); // Depuración
    if (idAuto) {
        getPrecioDiario(idAuto, function(precioDiario) {
            calcularPrecioTotal();
        });
    }
});



     // Función para obtener el nombre de cliente o auto
     function getEntityName(type, id, callback) {
         $.ajax({
             url: 'get_entity_name.php',
             type: 'POST',
             data: { type: type, id: id },
             dataType: 'json',
             success: function(response) {
                 if (response.status === 'success') {
                     callback(response.name);
                 } else {
                     showMessage('alert-danger', 'Error al obtener el nombre.');
                 }
             }
         });
     }
 
     // Manejar el envío del formulario para agregar una renta
     $('#addForm').on('submit', function(e) {
    e.preventDefault();

    $.ajax({
        url: 'add_reserva.php',
        type: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            if (response === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: 'Renta agregada exitosamente',
                    showConfirmButton: false,
                    timer: 3000
                }).then(() => {
                    $('#addModal').modal('hide');
                    $('#addForm')[0].reset();
                    $('#searchInput').trigger('keyup');

                    // Recargar el FullCalendar
                    $('#calendar').fullCalendar('refetchEvents');
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error al agregar la renta',
                    text: 'Hubo un problema al procesar la solicitud.',
                    showConfirmButton: true
                });
            }
        }
    });
});

 
     // Mostrar mensajes temporales
     function showMessage(type, text) {
         var message = $('#message');
         message.removeClass('d-none').removeClass('alert-success').removeClass('alert-danger');
         message.addClass(type).text(text);
 
         // Ocultar el mensaje después de 5 segundos
         setTimeout(function() {
             message.addClass('d-none');
         }, 5000);
     }

     $(document).ready(function () {
    $('#addClienteButton').on('click', function () {
        // Abrir el modal para agregar cliente
        $('#modalAddCliente').modal('show');
    });

    $('#addClienteForm').on('submit', function (e) {
        e.preventDefault(); // Evitar envío del formulario

        // Serializar los datos del formulario
        let formData = {
            nombre: $('#clienteNombre').val(),
            apellido: $('#clienteApellido').val(),
            documento: $('#clienteDocumento').val(),
            telefono: $('#clienteTelefono').val(),
            email: $('#clienteEmail').val()
        };

        // Enviar datos mediante AJAX
        $.ajax({
            url: 'addCliente.php', // Ruta del archivo PHP
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function (response) {
                if (response.status === 'success') {
                    // Mostrar mensaje de éxito con Swal
                    Swal.fire({
                        icon: 'success',
                        title: '¡Cliente agregado!',
                        text: response.message,
                        showConfirmButton: false,
                        timer: 2000
                    });

                    // Cerrar el modal después del mensaje
                    $('#modalAddCliente').modal('hide');

                    // Limpiar el formulario
                    $('#addClienteForm')[0].reset();

                    // Actualizar automáticamente el cliente en los campos correspondientes
                    $('#addClienteInput').val(response.data.nombre + ' ' + response.data.apellido); // Mostrar nombre y apellido
                    $('#addClienteId').val(response.data.id_cliente); // Guardar el ID del cliente
                } else {
                    // Mostrar mensaje de error con Swal
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message,
                        confirmButtonText: 'Entendido'
                    });
                }
            },
            error: function () {
                // Manejar errores de la solicitud AJAX
                Swal.fire({
                    icon: 'error',
                    title: 'Error en la solicitud',
                    text: 'No se pudo procesar la solicitud. Inténtalo nuevamente.',
                    confirmButtonText: 'Entendido'
                });
            }
        });
    });
});

});
$('#addClienteButton').on('click', function() {
    $('#modalAddCliente').modal('show'); // Abre un modal con ID `modalAddCliente`
});
    </script>
    
 
<!-- Modal para mostrar los detalles del evento -->
<div class="modal fade" id="eventModal" tabindex="-1" role="dialog" aria-labelledby="eventModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content rounded-lg shadow-lg">
            <div class="modal-header bg-gradient-to-r from-blue-500 to-blue-700 text-white">
                <h5 class="modal-title" id="eventModalLabel"><i class="fas fa-info-circle"></i> Detalles de la Renta</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body p-4">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <div class="card shadow-sm">
                            <div class="card-header bg-light">
                                <h6 class="text-primary"><i class="fas fa-bed"></i> Información de la Habitación</h6>
                            </div>
                            <div class="card-body">
                                <p><strong>Habitación:</strong> <span id="eventRoomName"></span></p>
                                <p><strong>Número de Habitación:</strong> <span id="eventRoomNumber"></span></p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="card shadow-sm">
                            <div class="card-header bg-light">
                                <h6 class="text-primary"><i class="fas fa-calendar-alt"></i> Fechas de Estadía</h6>
                            </div>
                            <div class="card-body">
                                <p><strong>Fecha de Check-in:</strong> <span id="eventStart"></span></p>
                                <p><strong>Fecha de Check-out:</strong> <span id="eventEnd"></span></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12 mb-3">
                        <div class="card shadow-sm">
                            <div class="card-header bg-light">
                                <h6 class="text-primary"><i class="fas fa-user"></i> Información del Cliente</h6>
                            </div>
                            <div class="card-body">
                                <p><strong>Nombre:</strong> <span id="eventNombre"></span></p>
                                <p><strong>Teléfono:</strong> <span id="eventTelefono"></span></p>
                                <p><strong>Email:</strong> <span id="eventEmail"></span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fas fa-times"></i> Cerrar</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal para mostrar las habitaciones -->
<div class="modal fade" id="habitacionesModal" tabindex="-1" aria-labelledby="habitacionesModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="habitacionesModalLabel">Habitaciones Disponibles</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead class="thead-dark">
                            <tr>
                                <th>Nombre</th>
                                <th>Número</th>
                                <th>Tipo</th>
                                <th>Precio Diario</th>
                            </tr>
                        </thead>
                        <tbody id="habitacionesList">
                            <!-- Aquí se insertarán las filas dinámicamente -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>



</body>
</html>
