<?php
include '../config.php';

if (isset($_POST['id_reservacion'], $_POST['id_servicio'], $_POST['cantidad'], $_POST['precio'])) {
    $id_reservacion = $_POST['id_reservacion'];
    $id_servicio = $_POST['id_servicio'];
    $cantidad = $_POST['cantidad'];
    $precio = $_POST['precio']; // Recibir el precio desde la solicitud

    // Calcular el total
    $total = $cantidad * $precio;

    // Verificar si el servicio ya existe en la reservación
    $sqlCheck = "SELECT cantidad, total FROM servicios_reservacion 
                 WHERE id_reservacion = :id_reservacion AND id_servicio = :id_servicio";
    $stmtCheck = $pdo->prepare($sqlCheck);
    $stmtCheck->bindParam(':id_reservacion', $id_reservacion, PDO::PARAM_INT);
    $stmtCheck->bindParam(':id_servicio', $id_servicio, PDO::PARAM_INT);
    $stmtCheck->execute();

    if ($stmtCheck->rowCount() > 0) {
        // Si el servicio ya existe, actualizar cantidad y total
        $existingService = $stmtCheck->fetch(PDO::FETCH_ASSOC);
        $newCantidad = $existingService['cantidad'] + $cantidad; // Sumar la cantidad
        $newTotal = $newCantidad * $precio; // Recalcular el total

        $sqlUpdate = "UPDATE servicios_reservacion 
                      SET cantidad = :cantidad, total = :total 
                      WHERE id_reservacion = :id_reservacion AND id_servicio = :id_servicio";
        $stmtUpdate = $pdo->prepare($sqlUpdate);
        $stmtUpdate->bindParam(':cantidad', $newCantidad, PDO::PARAM_INT);
        $stmtUpdate->bindParam(':total', $newTotal, PDO::PARAM_STR);
        $stmtUpdate->bindParam(':id_reservacion', $id_reservacion, PDO::PARAM_INT);
        $stmtUpdate->bindParam(':id_servicio', $id_servicio, PDO::PARAM_INT);

        if ($stmtUpdate->execute()) {
            echo json_encode(['status' => 'success', 'message' => 'Cantidad actualizada correctamente']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Error al actualizar el servicio']);
        }
    } else {
        // Si el servicio no existe, insertarlo
        $sqlInsert = "INSERT INTO servicios_reservacion (id_reservacion, id_servicio, cantidad, total)
                      VALUES (:id_reservacion, :id_servicio, :cantidad, :total)";
        $stmtInsert = $pdo->prepare($sqlInsert);
        $stmtInsert->bindParam(':id_reservacion', $id_reservacion, PDO::PARAM_INT);
        $stmtInsert->bindParam(':id_servicio', $id_servicio, PDO::PARAM_INT);
        $stmtInsert->bindParam(':cantidad', $cantidad, PDO::PARAM_INT);
        $stmtInsert->bindParam(':total', $total, PDO::PARAM_STR);

        if ($stmtInsert->execute()) {
            echo json_encode(['status' => 'success', 'message' => 'Servicio agregado correctamente']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Error al agregar el servicio']);
        }
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Datos incompletos']);
}
?>
