$(document).ready(function () {
   function cargarHistorial() {
        console.log('Cargando Detalle');
        $.ajax({
            url: 'cuenta.php',
            type: 'GET',
            dataType: 'json',
            data: {
                action: 'get_rentals',
                id_cuenta: id_cuenta
            },
            success: function (data) {
                console.log('Datos recibidos:', data);
                let html = '<table class="table table-bordered table-striped">';
                html += '<thead class="thead-dark"><tr><th>ID Reserva</th><th>Habitacion</th><th>Fecha de Check-in</th><th>Fecha de Check-out</th><th>Estadía</th><th>Precio Total</th></tr></thead><tbody>';
                
                if (data.error) {
                    html += '<tr><td colspan="7">' + data.error + '</td></tr>';
                } else {
                    data.rentas.forEach(function (renta) {
                        html += '<tr>';
                        html += '<td>' + renta.id_renta + '</td>';
                        html += '<td>' + renta.nombre_habitacion + ' ' + renta.numero_habitacion + ' ' + renta.tipo + '</td>';
                        html += '<td>' + renta.fecha_renta + '</td>';
                        html += '<td>' + renta.fecha_devolucion + '</td>';
                        html += '<td>' + renta.dias + '</td>'; // Mostrar los días calculados
                        html += '<td>' + renta.precio_total + '</td>';
                        html += '</tr>';
                    });

                    // Agregar fila con total
                    html += '<tfoot><tr><td colspan="5" class="text-right"><strong>Total:</strong></td><td><strong>' + data.total_precio + '</strong></td><td></td></tr></tfoot>';
                }
                
                html += '</tbody></table>';
                $('#archivos-lista').html(html);
            },
            error: function (xhr, status, error) {
                console.error('Error al cargar los datos:', error);
                $('#archivos-lista').html('<p>Error al cargar los datos.</p>');
            }
        });
    }

    // Llamar a la función para cargar el historial al cargar la página
    cargarHistorial();

    // Cargar el historial al cargar la página
    cargarHistorial('', '');

   // Buscar servicios en tiempo real
$('#servicio').on('keyup', function () {
    const query = $(this).val();

    if (query.length > 0) {
        $.ajax({
            url: 'buscar_servicios.php', // Asegúrate de tener este archivo en el servidor
            method: 'GET',
            data: { q: query },
            success: function (response) {
                const resultados = JSON.parse(response);
                let html = '';

                // Si no hay resultados, mostrar un mensaje
                if (resultados.length === 0) {
                    html = '<li class="list-group-item text-muted">No se encontraron servicios</li>';
                } else {
                    // Agregar resultados
                    resultados.forEach(servicio => {
                        html += `
                            <li class="list-group-item list-group-item-action" data-id="${servicio.id_servicio}" data-precio="${servicio.precio}">
                                ${servicio.nombre} - $${servicio.precio}
                            </li>
                        `;
                    });
                }

                $('#resultadoBusqueda').html(html).show();
            }
        });
    } else {
        $('#resultadoBusqueda').hide();
    }
});

// Seleccionar servicio de la lista de resultados
$('#resultadoBusqueda').on('click', 'li', function () {
    const nombre = $(this).text();
    const id_servicio = $(this).data('id');
    const precio_servicio = $(this).data('precio');

    // Poner el nombre del servicio en el input
    $('#servicio').val(nombre);

    // Guardar id_servicio y precio_servicio en campos ocultos
    $('#id_servicio').val(id_servicio);
    $('#precio_servicio').val(precio_servicio);

    // Ocultar los resultados de la búsqueda
    $('#resultadoBusqueda').hide();
});

// Agregar servicio
$('#agregar').on('click', function() {
    const id_reservacion = id_cuenta;  // Reemplaza con el ID de la reservación actual
    const id_servicio = $('#id_servicio').val(); // Obtener el id del servicio desde el campo oculto
    const cantidad = $('#cantidad').val();
    const precio = $('#precio_servicio').val(); // Obtener el precio desde el campo oculto

    if (!id_servicio || cantidad <= 0 || !precio) {
        alert('Selecciona un servicio y una cantidad válida.');
        return;
    }

    $.ajax({
        url: 'agregar_servicio.php',
        method: 'POST',
        data: { id_reservacion, id_servicio, cantidad, precio },  // Enviar también el precio
        success: function(response) {
            const resultado = JSON.parse(response);
            if (resultado.status === 'success') {
                location.reload(); // Recargar la página
                // Agregar a la tabla
                const nombre = $('#servicio').val(); // El nombre del servicio
                const total = (precio * cantidad).toFixed(2);

                $('#tablaServicios tbody').append(`
                    <tr>
                        <td>${nombre}</td>
                        <td>${cantidad}</td>
                        <td>$${total}</td>
                        <td>
                    <button class="btn btn-danger btn-sm" onclick="eliminarServicio(${id_servicio})">
                        <i class="fas fa-trash-alt"></i> Quitar
                    </button>
                </td>
                    </tr>
                `);

                $('#servicio').val('');
                $('#cantidad').val(1);
                $('#id_servicio').val('');
                $('#precio_servicio').val('');
            } else {
                alert(resultado.message);
            }
        }
    });
});

// Manejar el envío del formulario de cobro
$('#paymentForm').on('submit', function(event) {
    event.preventDefault();
    const idCliente = $('#id_cliente').val();
    const idRenta = $('#id_renta').val();
    const amount = $('#amount').val();
    const metodoPago = $('#metodo_pago').val();

    // Referencia al botón de envío
    const $boton = $('#submitButton');

    // Cambiar el contenido del botón para mostrar el spinner y el texto "Enviando..."
    $boton.html('<i class="fas fa-spinner fa-spin"></i> Enviando...').prop('disabled', true);

    // Enviar el formulario de cobro al servidor
    $.ajax({
        url: 'process_payment.php',
        type: 'POST',
        data: {
            id_cliente: idCliente,
            id_renta: idRenta,
            monto: amount,
            metodo_pago: metodoPago
        },
        success: function(response) {
            // Abrir una nueva ventana para el ticket
            var mywindow = window.open('', 'Ticket de Pago', 'height=800,width=800');
            mywindow.document.write('<html><head><title>Ticket de Pago</title>');
            mywindow.document.write('</head><body>');
            mywindow.document.write(response); // Asumiendo que `response` contiene el HTML del ticket
            mywindow.document.write('</body></html>');
            mywindow.document.close(); // necessary for IE >= 10
            mywindow.focus(); // necessary for IE >= 10
            mywindow.print();
            mywindow.close();

            // Mostrar mensaje de éxito
            Swal.fire({
                title: 'Pago Exitoso',
                text: 'El pago se realizó correctamente.',
                icon: 'success',
                confirmButtonColor: '#28a745'
            })

            // Ocultar el modal y limpiar el formulario
            $('#detailsModal').modal('hide');
            $('#paymentForm')[0].reset();
            $('#searchInput').trigger('keyup');
        },
        error: function() {
            // Mostrar mensaje de error
            Swal.fire({
                title: 'Error',
                text: 'Error al realizar el pago: ' + response.message,
                icon: 'error',
                confirmButtonColor: '#d33'
            });
        },
        complete: function() {
            // Restaurar el contenido del botón y habilitarlo nuevamente
            $boton.html('Realizar Pago').prop('disabled', false);
        }
    });
});

    
});

function eliminarServicio(id) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: 'Este servicio será eliminado de la reservación.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: 'eliminarServicio.php', // Ruta al archivo PHP
                type: 'POST',
                data: { id: id }, // Solo enviamos el ID del servicio
                success: function(response) {
                    try {
                        const result = JSON.parse(response); // Analizar la respuesta JSON
                        if (result.status === 'success') {
                            Swal.fire({
                                title: '¡Eliminado!',
                                text: result.message,
                                icon: 'success',
                                confirmButtonText: 'Aceptar'
                            }).then(() => {
                                location.reload(); // Recargar la página
                            });
                        } else {
                            Swal.fire({
                                title: 'Error',
                                text: result.message,
                                icon: 'error',
                                confirmButtonText: 'Aceptar'
                            });
                        }
                    } catch (e) {
                        Swal.fire({
                            title: 'Error',
                            text: 'Hubo un problema procesando la respuesta del servidor.',
                            icon: 'error',
                            confirmButtonText: 'Aceptar'
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        title: 'Error',
                        text: 'No se pudo conectar con el servidor.',
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        }
    });
}



