<?php
session_start();
require '../config.php';

if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $tipo = $_POST['tipo'];
    $monto = $_POST['monto'];
    $motivo = $_POST['motivo']; // Nuevo campo
    $usuario_id = $_SESSION['usuario_id'];

    try {
        // Obtener la última caja aperturada
       /* $stmtCaja = $pdo->prepare("SELECT id_caja FROM caja WHERE tipo = 'apertura' AND usuario_id = :usuario_id ORDER BY fecha DESC LIMIT 1");
        $stmtCaja = $pdo->prepare("SELECT id_caja FROM caja WHERE tipo = 'apertura' ORDER BY fecha DESC LIMIT 1");
        $stmtCaja->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
        $stmtCaja->execute();
        $caja = $stmtCaja->fetch(PDO::FETCH_ASSOC);*/

        $stmtCaja = $pdo->prepare("SELECT id_caja FROM caja WHERE tipo = 'apertura' ORDER BY fecha DESC LIMIT 1");
        $stmtCaja->execute();
        $caja = $stmtCaja->fetch(PDO::FETCH_ASSOC);

        if (!$caja) {
            echo 'No se encontró una caja aperturada.';
            exit;
        }

        $id_caja = $caja['id_caja'];

        // Insertar en la tabla efectivo
        $stmt = $pdo->prepare("INSERT INTO efectivo (tipo, monto, motivo, fecha, usuario_id, caja_id) VALUES (:tipo, :monto, :motivo, NOW(), :usuario_id, :caja_id)");
        if ($stmt->execute(['tipo' => $tipo, 'monto' => $monto, 'motivo' => $motivo, 'usuario_id' => $usuario_id, 'caja_id' => $id_caja])) {
            echo 'success';
        } else {
            echo 'error';
        }
    } catch (PDOException $e) {
        echo 'error';
    }
}
?>
