<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si la caja está aperturada
if (!isCajaAperturada($pdo)) {
    header('Location: ../caja_no_aperturada.php');
    exit;
}

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

// Verifica si el usuario tiene permiso para acceder a la página
if (!usuarioTienePermiso($pdo, $_SESSION['usuario_id'], 'ver_empresa')) {
    header('Location: ../sin_permiso.php');
    exit;
}

// Obtener la información actual de la empresa
$sql = "SELECT * FROM empresa LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$empresa = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Empresa</title>
    <link rel="shortcut icon" href="../img/favi.ico">
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <style>
        .main-content {
            padding: 2rem;
        }

        .btn-primary {
            border-radius: 50px;
            font-size: 0.875rem;
        }

        .input-group {
            width: 100%;
            max-width: 500px;
        }

        .form-control {
            border-radius: 50px 0 0 50px;
            box-shadow: none;
        }

        .input-group-append .btn-secondary {
            border-radius: 0 50px 50px 0;
        }

        .btn-info {
            border-radius: 50px;
            font-size: 0.875rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        #message {
            position: fixed;
            top: 10px;
            right: 10px;
            width: 300px;
            z-index: 1050;
        }
        .modal-content {
            padding: 20px;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .img-thumbnail {
            max-height: 150px;
            max-width: 150px;
            margin-top: 10px;
            display: block;
        }
    </style>
</head>
<body>
    <?php include '../menu.php'; ?>

    <div class="container mt-4">
        <div class="container">
        <div class="d-flex align-items-center justify-content-center p-3 my-3 text-white bg-info rounded shadow-sm">
    <div class="lh-1 text-center">
        <h2 class="mb-4 text-center">
            <i class="fas fa-building"></i> <!-- Icono de FontAwesome -->
            Administrar Empresa
        </h2>
    </div>
</div>

            <form id="empresaForm" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="nombre">Nombre</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" value="<?= htmlspecialchars($empresa['nombre']) ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="direccion">Dirección</label>
                            <input type="text" class="form-control" id="direccion" name="direccion" value="<?= htmlspecialchars($empresa['direccion']) ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="telefono">Teléfono</label>
                            <input type="text" class="form-control" id="telefono" name="telefono" value="<?= htmlspecialchars($empresa['telefono']) ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="email">Email</label>
                            <input type="email" class="form-control" id="email" name="email" value="<?= htmlspecialchars($empresa['email']) ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="estado">Estado</label>
                            <input type="text" class="form-control" id="estado" name="estado" value="<?= htmlspecialchars($empresa['estado']) ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="ciudad">Ciudad</label>
                            <input type="text" class="form-control" id="ciudad" name="ciudad" value="<?= htmlspecialchars($empresa['ciudad']) ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="moneda">Moneda</label>
                            <input type="text" class="form-control" id="moneda" name="moneda" value="<?= htmlspecialchars($empresa['moneda']) ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="logo">Logo</label>
                            <input type="file" class="form-control-file" id="logo" name="logo">
                            <img id="logoPreview" src="<?= $empresa['logo'] ? '../img/' . htmlspecialchars($empresa['logo']) : '#' ?>" alt="Logo de la Empresa" class="img-thumbnail mt-2 <?= $empresa['logo'] ? '' : 'd-none' ?>">
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-info">Actualizar Información</button>
            </form>
        </div>
        <!-- Contenedor para mensajes -->
        <div id="message" class="alert d-none"></div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
    $(document).ready(function() {
        // Vista previa del logo seleccionado
        $('#logo').on('change', function() {
            var file = this.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#logoPreview').attr('src', e.target.result).removeClass('d-none');
                }
                reader.readAsDataURL(file);
            }
        });

        // Manejar el formulario de la empresa
        $('#empresaForm').on('submit', function(e) {
            e.preventDefault();
            var formData = new FormData(this);

            $.ajax({
                url: 'update_empresa.php',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response === 'success') {
                        showMessage('alert-success', 'Información de la empresa actualizada exitosamente.');
                    } else {
                        showMessage('alert-danger', 'Error al actualizar la información de la empresa.');
                    }
                }
            });
        });

        // Mostrar mensajes temporales
        function showMessage(type, text) {
            var message = $('#message');
            message.removeClass('d-none').removeClass('alert-success').removeClass('alert-danger');
            message.addClass(type).text(text);

            // Ocultar el mensaje después de 5 segundos
            setTimeout(function() {
                message.addClass('d-none');
            }, 5000);
        }
    });
    </script>

</body>
</html>
