<?php
session_start();
require '../config.php';

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    echo 'unauthorized';
    exit;
}

// Obtiene los datos del formulario
$nombre = $_POST['nombre'];
$direccion = $_POST['direccion'];
$telefono = $_POST['telefono'];
$email = $_POST['email'];
$estado = $_POST['estado'];
$ciudad = $_POST['ciudad'];
$moneda = $_POST['moneda'];

// Manejar la subida del logo
$logoPath = null;
if (!empty($_FILES['logo']['tmp_name'])) {
    // Define el directorio de destino
    $uploadDir = '../img/';
    
    // Obtiene el nombre original del archivo y lo sanitiza
    $logoName = basename($_FILES['logo']['name']);
    $logoPath = $uploadDir . $logoName;
    
    // Mueve el archivo subido al directorio
    if (move_uploaded_file($_FILES['logo']['tmp_name'], $logoPath)) {
        // El archivo se ha subido con éxito
    } else {
        echo 'error_uploading';
        exit;
    }
}

// Actualiza la información en la base de datos
$sql = "UPDATE empresa SET nombre = :nombre, direccion = :direccion, telefono = :telefono, email = :email, estado = :estado, ciudad = :ciudad, moneda = :moneda";
if ($logoPath) {
    $sql .= ", logo = :logo";
}
$stmt = $pdo->prepare($sql);
$stmt->bindValue(':nombre', $nombre);
$stmt->bindValue(':direccion', $direccion);
$stmt->bindValue(':telefono', $telefono);
$stmt->bindValue(':email', $email);
$stmt->bindValue(':estado', $estado);
$stmt->bindValue(':ciudad', $ciudad);
$stmt->bindValue(':moneda', $moneda);
if ($logoPath) {
    $stmt->bindValue(':logo', $logoPath);
}

if ($stmt->execute()) {
    echo 'success';
} else {
    echo 'error';
}
?>
