<?php
session_start();
require '../config.php'; 
require '../functions.php'; 

if (!isset($_SESSION['usuario_id'])) {
    echo json_encode(['error' => 'Usuario no autenticado']);
    exit;
}

if (!isset($_GET['id_cliente']) || !filter_var($_GET['id_cliente'], FILTER_VALIDATE_INT)) {
    echo json_encode(['error' => 'ID de cliente no válido']);
    exit;
}

$id_cliente = (int)$_GET['id_cliente'];

$fecha_inicio = isset($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : '';
$fecha_final = isset($_GET['fecha_final']) ? $_GET['fecha_final'] : '';

$sql = "
    SELECT DISTINCT r.id_renta, r.fecha_renta, r.fecha_devolucion, r.precio_total,
           a.nombre_habitacion, a.numero_habitacion, a.tipo,
           u.nombre_usuario
    FROM rentas r
    INNER JOIN habitaciones a ON r.id_auto = a.id_habitacion
    INNER JOIN usuarios u ON r.id_usuario = u.id_usuario
    WHERE r.id_cliente = :id_cliente
";

if ($fecha_inicio && $fecha_final) {
    $sql .= " AND r.fecha_renta BETWEEN :fecha_inicio AND :fecha_final";
}

$sql .= " ORDER BY r.fecha_renta DESC"; // Ordenar por fecha de renta en orden descendente

try {
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id_cliente', $id_cliente, PDO::PARAM_INT);
    
    if ($fecha_inicio && $fecha_final) {
        $stmt->bindParam(':fecha_inicio', $fecha_inicio);
        $stmt->bindParam(':fecha_final', $fecha_final);
    }
    
    $stmt->execute();
    $rentas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Calcular el total de precios
    $total_precio = array_sum(array_column($rentas, 'precio_total'));

    // Formatear el total y el precio total
    $total_precio_formateado = formatMonto($moneda, $total_precio);

    // Calcular los días entre fecha_renta y fecha_devolucion, formatear fechas y precios
    foreach ($rentas as &$renta) {
        $fecha_renta_obj = new DateTime($renta['fecha_renta']);
        $fecha_devolucion_obj = new DateTime($renta['fecha_devolucion']);
        
        $renta['dias'] = $fecha_renta_obj->diff($fecha_devolucion_obj)->days; // Calcular días
        
        $renta['fecha_renta'] = $fecha_renta_obj->format('d \d\e M \d\e Y');
        $renta['fecha_devolucion'] = $fecha_devolucion_obj->format('d \d\e M \d\e Y');
        $renta['precio_total'] = formatMonto($moneda, $renta['precio_total']);
    }

    echo json_encode([
        'rentas' => $rentas,
        'total_precio' => $total_precio_formateado
    ]);
    exit;
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
