<?php
require 'config.php';

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location:index.php');
    exit;
}
?>
<!-- menu.php -->
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .sidebar {
            width: 250px;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            background-color: #1a1a1a;
            color: #fff;
            padding: 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto;
            scrollbar-width: thin;
            scrollbar-color: #6c757d #343a40;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
        }

        .sidebar::-webkit-scrollbar {
            width: 8px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: #343a40;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background-color: #6c757d;
            border-radius: 10px;
            border: 2px solid #343a40;
        }

        .sidebar img {
            max-width: 100px;
            margin-bottom: 20px;
        }

        .sidebar h3 {
            color: #fff;
            margin-bottom: 20px;
            text-align: center;
        }

        .sidebar .nav-link {
            color: #adb5bd;
            margin-bottom: 10px;
            padding: 10px 15px;
            width: 100%;
            border-radius: 5px;
            transition: background-color 0.3s, color 0.3s;
        }

        .sidebar .nav-link:hover {
            color: #fff;
            background-color: #495057;
            text-decoration: none;
        }

        .sidebar .nav-link i {
            margin-right: 10px;
        }

        .main-content {
            margin-left: 260px;
            padding: 20px;
            flex-grow: 1;
        }

        .navbar {
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .navbar-brand {
            font-weight: bold;
        }

        .navbar-nav .nav-link {
            padding: 0.5rem 1rem;
        }

        .dropdown-menu {
            background-color: #343a40;
        }

        .dropdown-item {
            color: #fff;
        }

        .dropdown-item:hover {
            background-color: #495057;
            color: #fff;
        }

        @media (max-width: 768px) {
            .sidebar {
                width: 100%;
                height: auto;
                position: relative;
            }

            .main-content {
                margin-left: 0;
            }
        }
    </style>
</head>
<body>
    <!-- Barra de navegación con Bootstrap -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#">
            <i class="fas fa-chart-line"></i> (Bienvenido, <?php echo htmlspecialchars($_SESSION['usuario']); ?>)
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <!-- Contenedor centrado para los elementos del menú -->
            <ul class="navbar-nav mx-auto">
                <li class="nav-item">
                    <a class="nav-link text-white" href="../dashboard/dashboard.php"><i class="fas fa-tachometer-alt"></i> Administración</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" href="../ventas/panel_vendedor.php"><i class="fas fa-cash-register"></i> Punto de Venta</a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" id="sorteosDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-trophy"></i> Sorteos
                    </a>
                    <div class="dropdown-menu bg-dark" aria-labelledby="sorteosDropdown">
                        <a class="nav-link dropdown-item text-white" href="../sorteos/admin_sorteos.php"><i class="fas fa-trophy"></i> Nuevo Sorteo</a>
                        <a class="nav-link dropdown-item text-white" href="../sorteos/historial_sorteos.php"><i class="fas fa-medal"></i> Historial Sorteo</a>
                    </div>
                </li>
                <!--<li class="nav-item">
                    <a class="nav-link text-white" href="../caja/crud_caja.php"><i class="fas fa-piggy-bank"></i> Caja</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" href="../efectivo/crud_efectivo.php"><i class="fas fa-money-bill-alt"></i> Efectivo</a>
                </li>-->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" id="configuracionDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-chart-bar"></i> Reportes
                    </a>
                    <div class="dropdown-menu" aria-labelledby="configuracionDropdown">
                        <a class="dropdown-item" href="../sorteos/rep_sorteos.php"><i class="fas fa-ticket-alt"></i> Sorteos</a>
                    </div>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" id="configuracionDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-cogs"></i> Configuración
                    </a>
                    <div class="dropdown-menu" aria-labelledby="configuracionDropdown">
                        <a class="dropdown-item" href="../usuarios/crud_users.php"><i class="fas fa-users"></i> Usuarios</a>
                        <a class="dropdown-item" href="../permisos/asignar_permisos.php"><i class="fas fa-lock"></i> Permisos</a>
                        <a class="dropdown-item" href="../empresa/crud_empresa.php"><i class="fas fa-building"></i> Empresa</a>
                        <a class="dropdown-item" href="../datos/crud_datos.php"><i class="fas fa-database"></i> Datos</a>
                    </div>
                </li>
            </ul>

            <!-- Cerrar sesión alineado a la derecha -->
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link text-white" href="../logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar sesión</a>
                </li>
            </ul>
        </div>
    </nav>
</body>
</html>