<?php
session_start();
require '../config.php';
require '../functions.php';

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    echo json_encode([]);
    exit;
}

$search = isset($_POST['search']) ? $_POST['search'] : '';
$fechaInicio = isset($_POST['fecha_inicio']) ? $_POST['fecha_inicio'] : '';
$fechaFin = isset($_POST['fecha_fin']) ? $_POST['fecha_fin'] : '';

// Prepara la consulta SQL con los filtros
$sql = "
    SELECT p.id_pago, c.nombre AS nombre_cliente, c.apellido AS apellido_cliente, 
           u.nombre_usuario AS nombre_usuario, u.apellido AS apellido_usuario, 
           p.monto, p.fecha_pago, p.metodo_pago, p.estado
    FROM pagos p
    JOIN clientes c ON p.id_cliente = c.id_cliente
    JOIN usuarios u ON p.id_usuario = u.id_usuario
    WHERE 1";

if ($search) {
    $sql .= " AND (c.nombre LIKE :search OR c.apellido LIKE :search OR u.nombre LIKE :search OR u.apellido LIKE :search)";
}
if ($fechaInicio) {
    $sql .= " AND p.fecha_pago >= :fecha_inicio";
}
if ($fechaFin) {
    $sql .= " AND p.fecha_pago <= :fecha_fin";
}
// Agregar la cláusula ORDER BY para ordenar por ID de mayor a menor
$sql .= " ORDER BY p.id_pago DESC";
$stmt = $pdo->prepare($sql);

// Asigna los parámetros si existen
if ($search) {
    $stmt->bindValue(':search', '%' . $search . '%');
}
if ($fechaInicio) {
    $stmt->bindValue(':fecha_inicio', $fechaInicio);
}
if ($fechaFin) {
    $stmt->bindValue(':fecha_fin', $fechaFin);
}

$stmt->execute();
$pagos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Genera el HTML de la tabla
if (empty($pagos)) {
    echo '<tr><td colspan="8" class="text-center">No se encontró ningún pago.</td></tr>';
} else {
    foreach ($pagos as $pago) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($pago['id_pago']) . '</td>';
        echo '<td>' . htmlspecialchars($pago['nombre_cliente']) . ' ' . htmlspecialchars($pago['apellido_cliente']) . '</td>';
        echo '<td>' . htmlspecialchars(formatMonto($moneda, $pago['monto'])) . '</td>';
        echo '<td>' . htmlspecialchars($pago['fecha_pago']) . '</td>';
        echo '<td>' . htmlspecialchars($pago['metodo_pago']) . '</td>';
        echo '<td>' . htmlspecialchars($pago['nombre_usuario']) . '</td>';
        echo '<td>' . htmlspecialchars($pago['estado']) . '</td>';
        echo '<td>
                <div class="btn-group" role="group" aria-label="Botones de acción">
                    <button class="btn btn-warning btn-sm edit-btn" data-id="' . $pago['id_pago'] . '" data-toggle="modal" data-target="#editModal"><i class="fas fa-edit"></i></button>
                    <button class="btn btn-danger btn-sm delete-btn" data-id="' . $pago['id_pago'] . '"><i class="fas fa-trash-alt"></i></button>
                    <button class="btn btn-success btn-sm reprint-btn" data-id="' . $pago['id_pago'] . '"><i class="fas fa-print"></i></button>
                </div>
              </td>';
        echo '</tr>';
    }
}
?>
