<?php
require('fpdf/fpdf.php');
require '../config.php';
require '../functions.php';

// Verificar si el usuario está autenticado
session_start();
if (!isset($_SESSION['usuario_id'])) {
    exit;
}

// Obtener filtros de fecha
$fechaInicio = isset($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : '1900-01-01';
$fechaFin = isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : '2100-12-31';
$search = isset($_GET['searchR']) ? trim($_GET['searchR']) : '';

// Obtener datos de la empresa
$sql = "SELECT * FROM empresa WHERE id_empresa = 1";
$stmt = $pdo->query($sql);
$empresa = $stmt->fetch(PDO::FETCH_ASSOC);

// Obtener registros de rentas en el rango de fechas y búsqueda
$sql = "
    SELECT rentas.id_renta, clientes.nombre AS nombre_cliente, clientes.apellido AS apellido_cliente, 
           habitaciones.nombre_habitacion AS marca_auto, habitaciones.numero_habitacion AS modelo_auto, habitaciones.tipo AS modelo_anio, 
           usuarios.nombre_usuario, rentas.fecha_renta, rentas.fecha_devolucion, rentas.precio_total, 
           rentas.estado, rentas.pago, DATEDIFF(rentas.fecha_devolucion, rentas.fecha_renta) AS dias_renta
    FROM rentas
    JOIN clientes ON rentas.id_cliente = clientes.id_cliente
    JOIN habitaciones ON rentas.id_auto = habitaciones.id_habitacion
    JOIN usuarios ON rentas.id_usuario = usuarios.id_usuario
    WHERE 1";

if ($search) {
    $sql .= " AND CONCAT(clientes.nombre, ' ', clientes.apellido, ' ', habitaciones.nombre_habitacion, ' ', habitaciones.numero_habitacion, ' ', usuarios.nombre_usuario) LIKE :search";
}
if ($fechaInicio) {
    $sql .= " AND rentas.fecha_renta >= :fecha_inicio";
}
if ($fechaFin) {
    $sql .= " AND rentas.fecha_renta <= :fecha_fin";
}

$sql .= " ORDER BY rentas.id_renta";

$stmt = $pdo->prepare($sql);
if ($search) {
    $stmt->bindValue(':search', "%$search%");
}
if ($fechaInicio) {
    $stmt->bindValue(':fecha_inicio', $fechaInicio);
}
if ($fechaFin) {
    $stmt->bindValue(':fecha_fin', $fechaFin);
}
$stmt->execute();
$rentas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Crear instancia de FPDF
$pdf = new FPDF('L', 'mm', 'A4');  // L para orientación horizontal
$pdf->AddPage();

// Encabezado
$pdf->SetFont('Arial', 'B', 10);
$pdf->SetXY(10, 10);
$pdf->Image('../img/' . htmlspecialchars($empresa['logo']), 10, 10, 30);

$pdf->SetFont('Arial', 'B', 12);
$pdf->SetX(50);
$pdf->Cell(0, 10, utf8_decode($empresa['nombre']), 0, 1, 'C');
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 10, utf8_decode($empresa['estado'] . ', ' . $empresa['ciudad'] . ', ' . $empresa['direccion']), 0, 1, 'C');
$pdf->Cell(0, 10, utf8_decode('Teléfono: ' . $empresa['telefono'] . ' | Email: ' . $empresa['email']), 0, 1, 'C');
$pdf->Ln(10);

// Línea gris antes del título
$pdf->SetDrawColor(169, 169, 169);
$pdf->Line(20, 50, 270, 50);
$pdf->Ln(10);

// Título del informe
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, utf8_decode('Reporte de Estadias'), 0, 1, 'C');
$pdf->Ln(5);

// Encabezado de la tabla
$pdf->SetFont('Arial', 'B', 10);
$pdf->SetFillColor(169, 169, 169);
$pdf->Cell(10, 10, utf8_decode('ID'), 1, 0, 'C', true);
$pdf->Cell(65, 10, utf8_decode('Cliente'), 1, 0, 'C', true);
$pdf->Cell(40, 10, utf8_decode('Auto'), 1, 0, 'C', true);
$pdf->Cell(30, 10, utf8_decode('Fecha/check-in'), 1, 0, 'C', true);
$pdf->Cell(30, 10, utf8_decode('Fecha//check-out'), 1, 0, 'C', true);
$pdf->Cell(15, 10, utf8_decode('Estadía'), 1, 0, 'C', true);
$pdf->Cell(30, 10, utf8_decode('Precio Total'), 1, 0, 'C', true);
$pdf->Cell(20, 10, utf8_decode('Estado'), 1, 0, 'C', true);
$pdf->Cell(20, 10, utf8_decode('Pago'), 1, 0, 'C', true);
$pdf->Cell(20, 10, utf8_decode('Usuario'), 1, 1, 'C', true);

$pdf->SetFont('Arial', '', 9);

// Datos de la tabla
foreach ($rentas as $renta) {
    $badgeClass = $renta['pago'] === 'Pendiente' ? 'badge-danger' : 'badge-success';
    
    $pdf->Cell(10, 10, utf8_decode($renta['id_renta']), 1);
    $pdf->Cell(65, 10, utf8_decode($renta['nombre_cliente'] . ' ' . $renta['apellido_cliente']), 1);
    $pdf->Cell(40, 10, utf8_decode($renta['marca_auto'] . ' ' . $renta['modelo_anio']), 1);
    $pdf->Cell(30, 10, utf8_decode(formatearFecha($renta['fecha_renta'])), 1);
    $pdf->Cell(30, 10, utf8_decode(formatearFecha($renta['fecha_devolucion'])), 1);
    $pdf->Cell(15, 10, utf8_decode($renta['dias_renta']), 1);
    $pdf->Cell(30, 10, utf8_decode(formatMonto($moneda, $renta['precio_total'])), 1);
    $pdf->Cell(20, 10, utf8_decode($renta['estado']), 1);
    $pdf->Cell(20, 10, utf8_decode($renta['pago']), 1);
    $pdf->Cell(20, 10, utf8_decode($renta['nombre_usuario']), 1);
    $pdf->Ln();
}
// Output del PDF
$pdf->Output();
?>
