<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si la caja está aperturada
if (!isCajaAperturada($pdo)) {
    header('Location: ../caja_no_aperturada.php');
    exit;
}

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

// Verifica si el usuario tiene permiso para acceder a la página
if (!usuarioTienePermiso($pdo, $_SESSION['usuario_id'], 'ver_sorteos')) {
    header('Location: ../sin_permiso.php');
    exit;
}
// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_sorteos'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_sorteos'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_sorteos'),
];


// Obtener la hora de finalización del turno actual
date_default_timezone_set('America/El_Salvador');
$hora_actual = date('H:i:s');
$sql = "SELECT id_turno, nombre, hora_inicio, hora_fin FROM turnos ORDER BY hora_fin ASC";
$stmt = $pdo->query($sql);
$turnos = $stmt->fetchAll(PDO::FETCH_ASSOC);

$turno_activo_id = null;
$hora_fin_turno = null;

foreach ($turnos as $turno) {
    if ($hora_actual <= $turno['hora_fin']) {
        $turno_activo_id = $turno['id_turno'];
        $hora_fin_turno = $turno['hora_fin'];
        break;
    }
}

if ($turno_activo_id === null && !empty($turnos)) {
    $turno_activo_id = $turnos[0]['id_turno'];
    $hora_fin_turno = $turnos[0]['hora_fin'];
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sorteo</title>
    <link rel="shortcut icon" href="../img/favi.ico">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
    .badge {
        padding: 0.5em 1em;
        border-radius: 0.25em;
        font-size: 1.2em;
    }
    .badge-success {
        background-color: #28a745; /* Verde */
        color: white;
    }
    .badge-danger {
        background-color: #dc3545; /* Rojo */
        color: white;
    }
</style>
   
</head>
<body>
    <?php include '../menu.php'; ?>


    <div class="container mt-4">
    <div class="container mt-4">
    <div class="card shadow-lg">
        <div class="card-header bg-primary text-white text-center">
            <h4><i class="fas fa-trophy"></i> Verificar Número Ganador</h4>
        </div>
        <div class="card-body">
             <form id="formGanador">
            <div class="row">
                <!-- Selección de Turno -->
                <div class="col-md-6 mb-3">
                    <label for="turno" class="form-label">Sorteo:</label>
                   <!-- <select id="turno" name="turno" class="form-control">
                        <option value="">Seleccione un turno</option>
                        <?php
                        $stmt = $pdo->query("SELECT id_turno, nombre FROM turnos");
                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                            echo "<option value='{$row['id_turno']}'>{$row['nombre']}</option>";
                        }
                        ?>
                    </select>-->
                    <select id="id_turno" name="id_turno" class="form-control" required>
                                <?php
                                date_default_timezone_set('America/El_Salvador'); // Ajusta la zona horaria según tu ubicación
                                $hora_actual = date('H:i:s');

                                // Obtener todos los turnos ordenados por hora_fin
                                $sql = "SELECT id_turno, nombre, hora_inicio, hora_fin FROM turnos ORDER BY hora_fin ASC";
                                $stmt = $pdo->query($sql);

                                $turno_activo_id = null;
                                $turnos = $stmt->fetchAll(PDO::FETCH_ASSOC); // Obtener todos los turnos en un array

                                // Determinar qué turno debe estar seleccionado por defecto
                                foreach ($turnos as $turno) {
                                    if ($hora_actual <= $turno['hora_fin']) {
                                        $turno_activo_id = $turno['id_turno'];
                                        break; // Una vez que encontramos un turno activo, dejamos de buscar
                                    }
                                }

                                // Si no hay turnos activos, seleccionar el primero de la lista
                                if ($turno_activo_id === null && !empty($turnos)) {
                                    $turno_activo_id = $turnos[0]['id_turno'];
                                }

                                // Generar las opciones del select
                                foreach ($turnos as $turno) {
                                    $selected = ($turno['id_turno'] == $turno_activo_id) ? 'selected' : '';
                                    echo "<option value='{$turno['id_turno']}' $selected>{$turno['nombre']}</option>";
                                }
                                ?>
                            </select>
                </div>

                <!-- Ingreso del Número Ganador -->
                <div class="col-md-6 mb-3">
                    <label for="numero_ganador" class="form-label">Número Ganador:</label>
                    <input type="number" id="numero_ganador" name="numero_ganador" class="form-control" placeholder="Ej: 25">
                </div>
            </div>

            <!-- Botón de Búsqueda -->
            <div class="text-center mt-3">
                <button type="submit" class="btn btn-danger btn-lg">
                    <i class="fas fa-search"></i> Buscar
                </button>
            </div>

              <!-- Contador de tiempo restante -->
            <div class="text-center mt-3">
                <p>Tiempo restante para el Cierre del sorteo: 
                    <span id="contador-tiempo" class="badge"></span>
                </p>
            </div>
        </form>
        </div>
    </div>

    <div class="mt-4">
        <div class="card shadow">
            <div class="card-body">
                <h5 class="card-title text-center">Resultados del Sorteo</h5>
                <div class="table-responsive">
                <table class="table table-bordered text-center">
                    <thead class="table-dark">
                        <tr>
                            <th>Vendedor</th>
                            <th>Cliente</th>
                            <th>Número</th>
                            <th>Valor Apostado</th>
                            <th>Ganancia</th>
                            <th>Monto a Pagar</th>
                        </tr>
                    </thead>
                    <tbody id="resultados">
                        <tr><td colspan="6">No hay resultados aún</td></tr>
                    </tbody>
                </table>
                </div>
            </div>
        </div>
    </div>

    <div class="text-center mt-3">
    <button id="guardarSorteo" class="btn btn-success btn-lg">
        <i class="fas fa-save"></i> Guardar Sorteo
    </button>
</div>

</div>

    </div>

    



    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <!-- Incluye SweetAlert2 desde un CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {

           // Función para actualizar el contador de tiempo restante
        function actualizarContador() {
            let horaFinTurno = "<?php echo $hora_fin_turno; ?>"; // Hora de finalización del turno
            let ahora = new Date(); // Hora actual
            let finTurno = new Date(ahora.toDateString() + " " + horaFinTurno); // Convertir a objeto Date

            // Obtener el elemento del contador
            let contador = document.getElementById("contador-tiempo");

            // Verificar si el turno ha finalizado
            if (ahora > finTurno) {
                contador.innerText = "El turno ha finalizado";
                contador.classList.remove("badge-success"); // Quitar clase verde
                contador.classList.add("badge-danger"); // Agregar clase roja
                return;
            }

            // Calcular la diferencia de tiempo
            let diferencia = finTurno - ahora;
            let horas = Math.floor(diferencia / (1000 * 60 * 60));
            let minutos = Math.floor((diferencia % (1000 * 60 * 60)) / (1000 * 60));
            let segundos = Math.floor((diferencia % (1000 * 60)) / 1000);

            // Formatear el tiempo restante
            let tiempoRestante = 
                `${horas.toString().padStart(2, '0')}:${minutos.toString().padStart(2, '0')}:${segundos.toString().padStart(2, '0')}`;

            // Actualizar el texto y el estilo
            contador.innerText = tiempoRestante;
            contador.classList.remove("badge-danger"); // Quitar clase roja
            contador.classList.add("badge-success"); // Agregar clase verde
        }

        // Actualizar el contador cada segundo
        setInterval(actualizarContador, 1000);
        actualizarContador(); // Llamar inmediatamente para evitar el retraso inicial

        $("#formGanador").submit(function(e) {
            e.preventDefault();
        let numeroGanador = $("#numero_ganador").val();
        let turno = $("#id_turno").val();
        if (numeroGanador === "" || turno === "") {
            Swal.fire({
                icon: "warning",
                title: "⚠️ Campos vacíos",
                text: "Por favor, complete todos los campos.",
            });
            return;
        }

        $.ajax({
            url: "buscar_ganador.php",
            type: "POST",
            data: { numero_ganador: numeroGanador, turno: turno },
            dataType: "json",
            success: function (response) {
                    if (response.status === "success") {
                        Swal.fire({
                            icon: "success",
                            title: "✅ Ganador encontrado",
                            text: "Se han encontrado ventas con el número ganador.",
                        });

                        let filas = "";
                        response.resultados.forEach((venta) => {
                            filas += `<tr>
                                <td>${venta.vendedor ? venta.vendedor : "Desconocido"}</td>
                                <td>${venta.cliente}</td>
                                <td> ${venta.numero}</td>
                                <td>$${venta.valor_apostado}</td>
                                <td>$${venta.ganancia}</td>
                                <td>$${venta.monto_pagar}</td>
                            </tr>`;
                        });

                        // Agregar la fila de totales
                        filas += `<tr style="font-weight: bold; background-color: #f8f9fa;">
                            <td colspan="3" class="text-end">Totales:</td>
                            <td>$${response.total_valor}</td>
                            <td>$${response.total_ganancia}</td>
                            <td>$${response.total_monto_pagar}</td>
                        </tr>`;

                        $("#resultados").html(filas);
                    } else {
                        Swal.fire({
                            icon: "error",
                            title: "❌ Error",
                            text: response.message,
                        });
                        $("#resultados").html(`<tr><td colspan="6">${response.message}</td></tr>`);
                    }
                },

            error: function () {
                Swal.fire({
                    icon: "error",
                    title: "⚠️ Error en la búsqueda",
                    text: "Hubo un problema con la solicitud.",
                });
            },
        });
        });
        });

$("#guardarSorteo").click(function() {
        let turno = $("#id_turno").val();
        let numeroGanador = $("#numero_ganador").val();
        let resultados = [];

        $("#resultados tr").each(function() {
            let fila = $(this).find("td");
            if (fila.length > 1) {
                let venta = {
                    vendedor: fila.eq(0).text(),
                    cliente: fila.eq(1).text(),
                    numero: fila.eq(2).text(),
                    valor_apostado: fila.eq(3).text().replace("$", ""),
                    ganancia: fila.eq(4).text().replace("$", ""),
                    monto_pagar: fila.eq(5).text().replace("$", "")
                };
                resultados.push(venta);
            }
        });

        if (resultados.length === 0) {
            Swal.fire("⚠️ No hay datos para guardar", "Debe realizar una búsqueda primero.", "warning");
            return;
        }

        $.ajax({
            url: "guardarSorteo.php",
            type: "POST",
            data: { turno: turno, numero_ganador: numeroGanador, resultados: JSON.stringify(resultados) },
            dataType: "json",
            success: function(response) {
                if (response.status === "success") {
                    Swal.fire("✅ Sorteo Guardado", "El sorteo ha sido guardado correctamente.", "success");
                } else {
                    Swal.fire("❌ Error", response.message, "error");
                }
            },
            error: function() {
                Swal.fire("⚠️ Error en el servidor", "No se pudo guardar el sorteo.", "error");
            }
        });
    });
    </script>
</body>
</html>
