<?php
require '../config.php'; // Archivo de conexión a la base de datos
require '../functions.php';

header('Content-Type: application/json');

if (!isset($_POST['numero_ganador'], $_POST['turno']) || empty($_POST['numero_ganador']) || empty($_POST['turno'])) {
    echo json_encode(["status" => "error", "message" => "Faltan datos"]);
    exit;
}

$numero_ganador = $_POST['numero_ganador'];
$id_turno = $_POST['turno'];

// Obtener la hora actual
$hora_actual = date("H:i:s");

// Verificar si el turno ya venció
$sql_turno = "SELECT hora_fin FROM turnos WHERE id_turno = :id_turno";
$stmt_turno = $pdo->prepare($sql_turno);
$stmt_turno->bindParam(':id_turno', $id_turno, PDO::PARAM_INT);
$stmt_turno->execute();
$turno = $stmt_turno->fetch(PDO::FETCH_ASSOC);

/*if ($turno && $hora_actual > $turno['hora_fin']) {
    echo json_encode(["status" => "error", "message" => "El turno seleccionado ya ha vencido."]);
    exit;
}*/

// Buscar ventas con el número ganador en el turno seleccionado
$sql = "SELECT v.id_vendedor, u.nombre AS vendedor, v.cliente, v.numero, v.valor, v.ganancia 
        FROM ventas v 
        JOIN usuarios u ON v.id_vendedor = u.id_usuario
        WHERE v.numero = :numero_ganador AND v.id_turno = :id_turno";


$stmt = $pdo->prepare($sql);
$stmt->bindParam(':numero_ganador', $numero_ganador, PDO::PARAM_INT);
$stmt->bindParam(':id_turno', $id_turno, PDO::PARAM_INT);
$stmt->execute();
$ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$ventas) {
    echo json_encode(["status" => "error", "message" => "No se encontraron ventas con este número en el turno seleccionado"]);
    exit;
}

$total_valor = 0;
$total_ganancia = 0;
$total_monto_pagar = 0;

$resultados = [];
foreach ($ventas as $venta) {
    $monto_pagar = $venta['ganancia']; // Se toma directo de la BD

    // Sumar los totales
    $total_valor += $venta['valor'];
    $total_ganancia += $venta['ganancia'];
    $total_monto_pagar += $monto_pagar;

    $resultados[] = [
        "vendedor" => $venta['vendedor'],
        "cliente" => $venta['cliente'],
        "numero" => $venta['numero'],
        "valor_apostado" => number_format($venta['valor'], 2),
        "ganancia" => number_format($venta['ganancia'], 2),
        "monto_pagar" => number_format($monto_pagar, 2)
    ];
}

// Incluir los totales en la respuesta JSON
echo json_encode([
    "status" => "success",
    "resultados" => $resultados,
    "total_valor" => number_format($total_valor, 2),
    "total_ganancia" => number_format($total_ganancia, 2),
    "total_monto_pagar" => number_format($total_monto_pagar, 2)
]);

?>
