<?php
session_start();
require '../config.php';
require '../functions.php';

// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_usuarios'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_usuarios'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_usuarios'),
];

$search = isset($_POST['search']) ? $_POST['search'] : '';

function getUsuarios($pdo, $search = '') {
    $sql = "SELECT * FROM usuarios WHERE nombre_usuario LIKE :search";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['search' => "%$search%"]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$usuarios = getUsuarios($pdo, $search);

if (empty($usuarios)) {
    echo '<tr><td colspan="7" class="text-center">No se encontró ningún usuario.</td></tr>';
} else {
    foreach ($usuarios as $usuario) {
        echo '<tr>';
        // Verificar el valor de $usuario['rifa'] y mostrar el emoji correspondiente
        echo '<td>';
        if ($usuario['rifa'] == 80) {
            echo '🔵'; // Si es 80, mostrar el círculo azul
        } elseif ($usuario['rifa'] == 70) {
            echo '🔴'; // Si es 70, mostrar el círculo rojo
        } else {
            echo '-'; // Si no es 80 ni 70, mostrar un guion u otro valor por defecto
        }
        echo '</td>';
        echo '<td>' . htmlspecialchars($usuario['nombre_usuario']) . '</td>';
        echo '<td>' . htmlspecialchars($usuario['nombre']) . '</td>';
        echo '<td>' . htmlspecialchars($usuario['apellido']) . '</td>';
        echo '<td>' . htmlspecialchars($usuario['rol']) . '</td>';
        echo '<td>' . htmlspecialchars($usuario['rifa']) . '</td>';
        echo '<td>' . htmlspecialchars($usuario['comision']) . '</td>';
        echo '<td>';
        
        // Generar botones basados en permisos
        if ($permisos['editar']) {
        echo '<button class="btn btn-warning btn-sm edit-btn" data-id="' . $usuario['id_usuario'] . '" data-toggle="modal" data-target="#editModal"><i class="fas fa-edit"></i></button>';
    }
        if ($permisos['eliminar']) {
        echo '<button class="btn btn-danger btn-sm delete-btn" data-id="' . $usuario['id_usuario'] . '"><i class="fas fa-trash-alt"></i></button>';
    }
        echo '</td>';
        echo '</tr>';
    }
}
?>
