<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si se han enviado los parámetros de búsqueda
if (isset($_POST['nombre']) && isset($_POST['estudios'])) {
    // Obtener los parámetros de búsqueda
    $nombre = $_POST['nombre'];
    $estudios = $_POST['estudios'];

    // Realizar la consulta SQL para filtrar los archivos
    $query = "SELECT id, nombre, tipo_archivo, estudios_id FROM archivos WHERE cliente_id = :cliente_id";
    $params = array(':cliente_id' => $_SESSION['id_cliente']);

    // Agregar condiciones de búsqueda si los parámetros no están vacíos
    if (!empty($nombre)) {
        $query .= " AND nombre LIKE :nombre";
        $params[':nombre'] = "%$nombre%";
    }
    if (!empty($estudios)) {
        $query .= " AND estudios_id = :estudios";
        $params[':estudios'] = $estudios;
    }

    // Preparar la consulta
    $stmt = $pdo->prepare($query);

    // Ejecutar la consulta con parámetros
    $stmt->execute($params);

    // Obtener resultados
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Mostrar los resultados como filas de tabla HTML
    foreach ($resultados as $fila) {
        // Consulta para obtener el nombre del estudio basado en el ID
        $query_estudio = "SELECT descripcion FROM cat_documentos WHERE id_doc = :estudios_id";
        $stmt_estudio = $pdo->prepare($query_estudio);
        $stmt_estudio->bindParam(':estudios_id', $fila['estudios_id'], PDO::PARAM_INT);
        $stmt_estudio->execute();
        $nombre_estudio = $stmt_estudio->fetchColumn();
        ?>
        <tr>
            <td><?php echo htmlspecialchars($fila['nombre'], ENT_QUOTES, 'UTF-8'); ?></td>
            <td><?php echo htmlspecialchars($nombre_estudio, ENT_QUOTES, 'UTF-8'); ?></td>
            <td>
                <a href="descargar_archivo.php?id=<?php echo htmlspecialchars($fila['id'], ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-primary btn-sm">Descargar</a>
                <button onclick="eliminarArchivo(<?php echo htmlspecialchars($fila['id'], ENT_QUOTES, 'UTF-8'); ?>)" class="btn btn-danger btn-sm">Eliminar</button>
            </td>
        </tr>
        <?php
    }

} else {
    // Si no se proporcionaron los parámetros de búsqueda, devolver un mensaje de error
    echo "Error: Parámetros de búsqueda no proporcionados.";
}
?>
