<style>
.archivo-lista {
    margin-top: 20px;
}

.archivo-lista h4 {
    font-size: 18px;
    color: #333;
}

.list-group {
    margin-top: 10px;
}

.list-group-item {
    background-color: #f9f9f9;
    border: 1px solid #ddd;
    border-radius: 5px;
    padding: 10px 15px;
    margin-bottom: 5px;
}

.list-group-item a {
    color: #333;
    text-decoration: none;
}

.list-group-item a:hover {
    color: #007bff;
}
</style>

<?php
session_start();
require '../config.php';
require '../functions.php';

$id_cliente = $_SESSION['id_cliente'];

// Consulta para obtener la lista de archivos
$query = "SELECT id, nombre, tipo_archivo, estudios_id FROM archivos WHERE cliente_id = :cliente_id";
$stmt = $pdo->prepare($query);
$stmt->bindParam(':cliente_id', $id_cliente, PDO::PARAM_INT);
$stmt->execute();
$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="archivo-lista">
    <h4>Lista de archivos</h4>
    <table id="tablaArchivos" class="table table-bordered table-striped">
        <thead class="thead-dark">
            <tr>
                <th>Nombre del Archivo</th>
                <th>Categoría de Archivos</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($resultado as $fila) {
                // Consulta para obtener el nombre del estudio basado en el ID
                $query_estudio = "SELECT descripcion FROM cat_documentos WHERE id_doc = :estudios_id";
                $stmt_estudio = $pdo->prepare($query_estudio);
                $stmt_estudio->bindParam(':estudios_id', $fila['estudios_id'], PDO::PARAM_INT);
                $stmt_estudio->execute();
                $nombre_estudio = $stmt_estudio->fetchColumn();
                ?>
                <tr>
                    <td><?php echo htmlspecialchars($fila['nombre']); ?></td>
                    <td><?php echo htmlspecialchars($nombre_estudio); ?></td>
                    <td>
                        <a href="download_file.php?id=<?php echo $fila['id']; ?>" class="btn btn-primary btn-sm">Descargar</a>
                        <button onclick="eliminarArchivo(<?php echo $fila['id']; ?>)" class="btn btn-danger btn-sm">Eliminar</button>
                    </td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</div>
<!-- Ventana modal -->
<div class="modal fade" id="archivoModal" tabindex="-1" role="dialog" aria-labelledby="archivoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="archivoModalLabel">Detalle de Archivo</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="detalleArchivo">
                <!-- Aquí se mostrará el contenido del archivo -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript para la función mostrarArchivo -->
<script>
function mostrarArchivo(id) {
    var detalleArchivo = $('#detalleArchivo');
    detalleArchivo.empty(); // Limpiamos cualquier contenido previo

    // Hacer una solicitud AJAX para obtener el contenido del archivo de la base de datos
    $.ajax({
        url: '../ajax/mostrar_archivo.php',
        type: 'POST',
        data: { id: id },
        dataType: 'text', // Suponiendo que el contenido del archivo es texto
        success: function(data) {
            // Mostrar el contenido del archivo en la ventana modal
            detalleArchivo.text(data);
        },
        error: function() {
            detalleArchivo.text('Error al cargar el archivo.');
        }
    });
}
</script>
