<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si se ha enviado un archivo
if (isset($_FILES['archivo']) && isset($_POST['id_estudios'])) {
    // Obtener información sobre el archivo
    $nombre_archivo = $_FILES['archivo']['name'];
    $tipo_archivo = $_FILES['archivo']['type'];
    $tamanio_archivo = $_FILES['archivo']['size'];
    $archivo_temporal = $_FILES['archivo']['tmp_name'];

    // Verificar si el tamaño del archivo es menor o igual a 1 MB (1 MB = 1048576 bytes)
    if ($tamanio_archivo > 1048576) {
        echo "Error: El archivo excede el tamaño máximo permitido de 1 MB.";
        exit; // Terminar el script si el archivo es demasiado grande
    }

    // Verificar si el tipo de archivo está permitido
    $tipos_permitidos = array('image/jpeg', 'image/png', 'application/pdf'); // Tipos de archivo permitidos
    if (!in_array($tipo_archivo, $tipos_permitidos)) {
        echo "Error: Tipo de archivo no permitido.";
        exit; // Terminar el script si el tipo de archivo no es permitido
    }

    // Leer el contenido del archivo
    $archivo_contenido = file_get_contents($archivo_temporal);

    // Verificar si se pudo leer el archivo
    if ($archivo_contenido === false) {
        echo "Error: No se pudo leer el archivo.";
        exit; // Terminar el script si no se puede leer el archivo
    }

    // Recibir el campo de "Estudios" del formulario
    $id_estudios = $_POST['id_estudios'];

    try {
        // Insertar el archivo en la base de datos
        $query = "INSERT INTO archivos (nombre, tipo_archivo, archivo, cliente_id, estudios_id) VALUES (:nombre, :tipo_archivo, :archivo, :cliente_id, :estudios_id)";
        $stmt = $pdo->prepare($query);

        // Enlazar los parámetros
        $stmt->bindParam(':nombre', $nombre_archivo);
        $stmt->bindParam(':tipo_archivo', $tipo_archivo);
        $stmt->bindParam(':archivo', $archivo_contenido, PDO::PARAM_LOB);
        $stmt->bindParam(':cliente_id', $_SESSION['id_cliente'], PDO::PARAM_INT);
        $stmt->bindParam(':estudios_id', $id_estudios, PDO::PARAM_INT);

        // Ejecutar la consulta
        if ($stmt->execute()) {
            echo "El archivo se ha subido correctamente.";
        } else {
            echo "Error al subir el archivo: " . $stmt->errorInfo()[2];
        }

    } catch (PDOException $e) {
        echo "Error al insertar el archivo: " . $e->getMessage();
    }
} else {
    echo "Error: No se ha enviado ningún archivo o no se ha especificado el ID de estudios.";
}
?>
