

CREATE TABLE `autos` (
  `id_auto` int(11) NOT NULL AUTO_INCREMENT,
  `marca` varchar(50) NOT NULL,
  `modelo` varchar(50) NOT NULL,
  `anio` int(11) NOT NULL,
  `color` varchar(30) DEFAULT NULL,
  `placa` varchar(15) NOT NULL,
  `tipo` varchar(50) NOT NULL,
  `precio_diario` decimal(10,2) NOT NULL,
  `detalles` text NOT NULL,
  `disponible` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id_auto`),
  UNIQUE KEY `placa` (`placa`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO autos VALUES("5","Toyota","Corolla","2020","Blanco","ABC001","Sedán","50.00","NULL","NULL");
INSERT INTO autos VALUES("6","Toyota","Camry","2021","Negro","ABC002","Sedán","55.00","NULL","1");
INSERT INTO autos VALUES("7","Honda","Civic","2022","Rojo","XYZ001","Hatchback","45.00","NULL","1");
INSERT INTO autos VALUES("8","Honda","Accord","2020","Azul","XYZ002","Sedán","50.00","NULL","1");
INSERT INTO autos VALUES("9","Ford","Mustang","2021","Verde","LMN001","Deportivo","80.00","NULL","1");
INSERT INTO autos VALUES("10","Ford","Focus","2022","Gris","LMN002","Hatchback","65.00","NULL","1");
INSERT INTO autos VALUES("11","Chevrolet","Cruze","2020","Blanco","DEF001","Sedán","55.00","NULL","1");
INSERT INTO autos VALUES("12","Chevrolet","Malibu","2021","Negro","DEF002","Sedán","60.00","NULL","1");
INSERT INTO autos VALUES("13","BMW","320i","2022","Rojo","GHI001","Sedán","70.00","NULL","1");
INSERT INTO autos VALUES("14","BMW","X5","2021","Plateado","GHI002","SUV","90.00","NULL","1");
INSERT INTO autos VALUES("15","Audi","A4","2020","Azul","JKL001","Sedán","65.00","NULL","1");
INSERT INTO autos VALUES("16","Audi","Q5","2022","Blanco","JKL002","SUV","85.00","NULL","1");
INSERT INTO autos VALUES("17","Mercedes","C-Class","2021","Negro","MNO001","Sedán","75.00","NULL","1");
INSERT INTO autos VALUES("18","Mercedes","E-Class","2022","Gris","MNO002","Sedán","80.00","NULL","1");
INSERT INTO autos VALUES("19","Nissan","Altima","2020","Rojo","PQR001","Sedán","50.00","NULL","NULL");
INSERT INTO autos VALUES("20","Nissan","Rogue","2021","Verde","PQR002","SUV","70.00","NULL","1");
INSERT INTO autos VALUES("21","Hyundai","Elantra","2022","Azul","STU001","Sedán","55.00","NULL","1");
INSERT INTO autos VALUES("22","Hyundai","Santa Fe","2021","Blanco","STU002","SUV","65.00","NULL","NULL");
INSERT INTO autos VALUES("23","Kia","Optima","2020","Negro","VWX001","Sedán","60.00","NULL","1");
INSERT INTO autos VALUES("24","Kia","Sportage","2021","Gris","VWX002","SUV","70.00","NULL","1");
INSERT INTO autos VALUES("25","Toyota","RAV4","2022","Rojo","ABC003","SUV","75.00","NULL","1");
INSERT INTO autos VALUES("26","Honda","Pilot","2021","Blanco","XYZ003","SUV","80.00","NULL","1");
INSERT INTO autos VALUES("27","Ford","Escape","2022","Negro","LMN003","SUV","85.00","NULL","1");
INSERT INTO autos VALUES("28","Chevrolet","Equinox","2021","Azul","DEF003","SUV","70.00","NULL","1");
INSERT INTO autos VALUES("29","BMW","X3","2020","Plateado","GHI003","SUV","90.00","NULL","1");
INSERT INTO autos VALUES("30","Audi","A6","2022","Rojo","JKL003","Sedán","75.00","NULL","1");
INSERT INTO autos VALUES("31","Mercedes","GLC","2021","Gris","MNO003","SUV","80.00","NULL","1");
INSERT INTO autos VALUES("32","Nissan","370Z","2022","Negro","PQR003","Deportivo","95.00","NULL","NULL");
INSERT INTO autos VALUES("33","Hyundai","Kona","2021","Verde","STU003","SUV","60.00","NULL","1");
INSERT INTO autos VALUES("34","Kia","Seltos","2022","Blanco","VWX003","SUV","65.00","NULL","1");
INSERT INTO autos VALUES("35","Toyota","Highlander","2021","Azul","ABC004","SUV","85.00","NULL","1");
INSERT INTO autos VALUES("36","Honda","CR-V","2022","Rojo","XYZ004","SUV","75.00","NULL","1");
INSERT INTO autos VALUES("37","Ford","F-150","2021","Gris","LMN004","Camioneta","95.00","NULL","1");
INSERT INTO autos VALUES("38","Chevrolet","Silverado","2022","Negro","DEF004","Camioneta","100.00","NULL","NULL");
INSERT INTO autos VALUES("39","BMW","M3","2021","Rojo","GHI004","Deportivo","120.00","NULL","1");
INSERT INTO autos VALUES("40","Audi","S4","2022","Blanco","JKL004","Deportivo","110.00","NULL","NULL");
INSERT INTO autos VALUES("41","Mercedes","S-Class","2021","Plateado","MNO004","Sedán","130.00","NULL","1");
INSERT INTO autos VALUES("42","Nissan","Juke","2022","Azul","PQR004","SUV","55.00","NULL","1");
INSERT INTO autos VALUES("43","Hyundai","Tucson","2021","Gris","STU004","SUV","60.00","NULL","1");
INSERT INTO autos VALUES("44","Kia","Forte","2022","Negro","VWX004","Sedán","50.00","NULL","NULL");
INSERT INTO autos VALUES("45","Toyota","Land Cruiser","2021","Blanco","ABC005","SUV","95.00","NULL","NULL");
INSERT INTO autos VALUES("46","Honda","Accord Hybrid","2022","Verde","XYZ005","Sedán","65.00","NULL","1");
INSERT INTO autos VALUES("47","Ford","Explorer","2021","Rojo","LMN005","SUV","85.00","NULL","1");
INSERT INTO autos VALUES("48","Chevrolet","Traverse","2022","Negro","DEF005","SUV","80.00","NULL","1");
INSERT INTO autos VALUES("49","BMW","X6","2021","Blanco","GHI005","SUV","100.00","NULL","NULL");
INSERT INTO autos VALUES("50","Audi","Q7","2022","Rojo","JKL005","SUV","95.00","NULL","1");
INSERT INTO autos VALUES("51","Mercedes","GLA","2021","Gris","MNO005","SUV","70.00","NULL","1");
INSERT INTO autos VALUES("52","Nissan","Armada","2022","Blanco","PQR005","SUV","90.00","NULL","1");
INSERT INTO autos VALUES("53","Hyundai","Palisaide","2021","Negro","STU005","SUV","85.00","NULL","1");
INSERT INTO autos VALUES("54","Kia","Carnival","2022","Azul","VWX005","Minivan","75.00","NULL","1");
INSERT INTO autos VALUES("55","Toyota","Tacoma","2021","Rojo","ABC100","Camioneta","70.00","NULL","1");
INSERT INTO autos VALUES("56","Test","Xyz","2016","Negro","456545-94","Sedan","25.00","Rasguños en los costados y sin llanta de repuesto","1");



CREATE TABLE `caja` (
  `id_caja` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` enum('apertura','cierre') NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `fecha` datetime DEFAULT current_timestamp(),
  `usuario_id` int(11) NOT NULL,
  PRIMARY KEY (`id_caja`),
  KEY `usuario_id` (`usuario_id`),
  CONSTRAINT `caja_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id_usuario`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO caja VALUES("1","apertura","50.00","2024-08-06 19:36:52","1");
INSERT INTO caja VALUES("2","cierre","50.00","2024-08-06 19:41:07","1");
INSERT INTO caja VALUES("3","apertura","100.00","2024-08-06 19:41:35","1");
INSERT INTO caja VALUES("4","cierre","50.00","2024-08-06 19:51:34","1");
INSERT INTO caja VALUES("5","apertura","85.00","2024-08-06 19:56:55","1");
INSERT INTO caja VALUES("6","cierre","50.00","2024-08-06 20:00:17","1");
INSERT INTO caja VALUES("7","apertura","50.00","2024-08-06 20:39:58","1");
INSERT INTO caja VALUES("8","cierre","50.00","2024-08-07 20:24:40","1");
INSERT INTO caja VALUES("9","apertura","100.00","2024-08-07 20:25:19","1");
INSERT INTO caja VALUES("10","cierre","85.00","2024-08-07 20:33:46","1");
INSERT INTO caja VALUES("11","apertura","85.00","2024-08-07 20:34:06","1");
INSERT INTO caja VALUES("12","cierre","85.00","2024-08-07 20:38:23","1");
INSERT INTO caja VALUES("13","apertura","100.00","2024-08-07 20:38:57","1");
INSERT INTO caja VALUES("14","cierre","100.00","2024-08-07 22:15:02","3");
INSERT INTO caja VALUES("15","apertura","100.00","2024-08-07 22:15:39","3");
INSERT INTO caja VALUES("16","apertura","85.00","2024-08-08 11:30:55","1");
INSERT INTO caja VALUES("17","apertura","10.00","2024-08-08 11:31:12","1");
INSERT INTO caja VALUES("18","cierre","85.00","2024-08-08 21:59:07","1");
INSERT INTO caja VALUES("19","apertura","100.00","2024-08-08 22:02:53","1");
INSERT INTO caja VALUES("20","cierre","100.00","2024-08-10 10:00:08","1");
INSERT INTO caja VALUES("21","apertura","150.00","2024-08-10 10:08:34","1");
INSERT INTO caja VALUES("22","cierre","300.00","2024-08-10 21:25:13","1");
INSERT INTO caja VALUES("23","apertura","175.00","2024-08-10 21:25:50","3");



CREATE TABLE `clientes` (
  `id_cliente` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) NOT NULL,
  `direccion` varchar(255) DEFAULT NULL,
  `telefono` varchar(15) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `fecha_registro` date DEFAULT curdate(),
  `documento` varchar(50) NOT NULL,
  `licencia` varchar(50) NOT NULL,
  `vencimiento` date NOT NULL,
  PRIMARY KEY (`id_cliente`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO clientes VALUES("1","Karla Hizel","Patrica Yamilet","San Miguel","63524145","karla@gmail.com","2024-08-02","456545-8","4551004","2024-08-12");
INSERT INTO clientes VALUES("2","Maritza Carolina","Zepeda Portillo","San Miguel","26458578","carolina@gmail.com","2024-08-02","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("3","Milgaro","Hernandez","San Miguel","26457845","milagro@gmail.com","2024-08-03","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("66","Carlos","González","Calle 1, San Salvador","+503 72234567","carlos.gonzalez@example.com","2024-07-23","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("67","María","Hernández","Avenida 2, Santa Ana","+503 72234568","maria.hernandez@example.com","2024-07-13","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("68","José","Martínez","Calle 3, San Miguel","+503 72234569","jose.martinez@example.com","2024-07-03","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("69","Ana","Lopez","Calle 4, La Libertad","+503 72234570","ana.lopez@example.com","2024-06-23","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("70","Luis","Morales","Avenida 5, Sonsonate","+503 72234571","luis.morales@example.com","2024-06-13","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("71","Sofía","Ramírez","Calle 6, San Salvador","+503 72234572","sofia.ramirez@example.com","2024-06-03","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("72","David","Reyes","Calle 7, Santa Ana","+503 72234573","david.reyes@example.com","2024-05-24","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("73","Isabel","Gutiérrez","Avenida 8, San Miguel","+503 72234574","isabel.gutierrez@example.com","2024-05-14","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("74","Fernando","Vásquez","Calle 9, La Libertad","+503 72234575","fernando.vasquez@example.com","2024-05-04","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("75","Lucía","Pérez","Calle 10, Sonsonate","+503 72234576","lucia.perez@example.com","2024-04-24","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("76","Miguel","Flores","Calle 11, San Salvador","+503 72234577","miguel.flores@example.com","2024-04-14","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("77","Elena","Hernández","Avenida 12, Santa Ana","+503 72234578","elena.hernandez@example.com","2024-04-04","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("78","Javier","García","Calle 13, San Miguel","+503 72234579","javier.garcia@example.com","2024-03-25","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("79","Paola","Mendoza","Calle 14, La Libertad","+503 72234580","paola.mendoza@example.com","2024-03-15","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("80","Ricardo","Castro","Avenida 15, Sonsonate","+503 72234581","ricardo.castro@example.com","2024-03-05","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("81","Valeria","Sánchez","Calle 16, San Salvador","+503 72234582","valeria.sanchez@example.com","2024-02-24","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("82","Alejandro","Salazar","Calle 17, Santa Ana","+503 72234583","alejandro.salazar@example.com","2024-02-14","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("83","Claudia","Vargas","Avenida 18, San Miguel","+503 72234584","claudia.vargas@example.com","2024-02-04","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("84","Manuel","Benítez","Calle 19, La Libertad","+503 72234585","manuel.benitez@example.com","2024-01-25","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("85","Fernanda","Morán","Calle 20, Sonsonate","+503 72234586","fernanda.moran@example.com","2024-01-15","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("86","Gabriela","Fuentes","Calle 21, San Salvador","+503 72234587","gabriela.fuentes@example.com","2024-01-05","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("87","Ricardo","López","Avenida 22, Santa Ana","+503 72234588","ricardo.lopez@example.com","2023-12-26","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("88","Patricia","Aguilar","Calle 23, San Miguel","+503 72234589","patricia.aguilar@example.com","2023-12-16","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("89","Jorge","Gómez","Calle 24, La Libertad","+503 72234590","jorge.gomez@example.com","2023-12-06","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("90","Natalia","Pineda","Avenida 25, Sonsonate","+503 72234591","natalia.pineda@example.com","2023-11-26","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("91","Oscar","Maldonado","Calle 26, San Salvador","+503 72234592","oscar.maldonado@example.com","2023-11-16","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("92","Daniela","Arias","Calle 27, Santa Ana","+503 72234593","daniela.arias@example.com","2023-11-06","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("93","Eduardo","Cordero","Avenida 28, San Miguel","+503 72234594","eduardo.cordero@example.com","2023-10-27","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("94","Lorena","Martínez","Calle 29, La Libertad","+503 72234595","lorena.martinez@example.com","2023-10-17","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("95","Felipe","Navarro","Calle 30, Sonsonate","+503 72234596","felipe.navarro@example.com","2023-10-07","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("96","Alejandra","Mendoza","Calle 31, San Salvador","+503 72234597","alejandra.mendoza@example.com","2023-09-27","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("97","Héctor","Zúñiga","Avenida 32, Santa Ana","+503 72234598","hector.zuniga@example.com","2023-09-17","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("98","Julián","Quintanilla","Calle 99, Sonsonate","+503 72234600","julian.quintanilla@example.com","2021-11-16","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("99","Valentina","Torres","Calle 100, San Salvador","+503 72234601","valentina.torres@example.com","2021-11-06","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("100","Delmar Ramon","Lopez Araujo","col las palmeras, San Miguel, San Miguel","26564585","delmarlopez@gmail.com","2024-08-08","NULL","NULL","0000-00-00");
INSERT INTO clientes VALUES("101","Ana Michell","Hernandez Argueta","Avenida San Pablo 8, San Salvador","+50378965236","anamichel@gmail.com","2024-08-09","03567895-6","12345-86545","2025-08-28");



CREATE TABLE `efectivo` (
  `id_efectivo` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` enum('ingreso','egreso') NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `motivo` text NOT NULL,
  `fecha` datetime DEFAULT current_timestamp(),
  `usuario_id` int(11) DEFAULT NULL,
  `caja_id` int(11) NOT NULL,
  PRIMARY KEY (`id_efectivo`),
  KEY `usuario_id` (`usuario_id`),
  CONSTRAINT `efectivo_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id_usuario`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO efectivo VALUES("1","egreso","52.25","Pago de Impuestos","2024-08-10 21:28:45","3","23");
INSERT INTO efectivo VALUES("2","egreso","22.75","Pago de reparación de Pc principal","2024-08-11 09:16:45","3","23");
INSERT INTO efectivo VALUES("3","egreso","50.00","Tes de Validacion","2024-08-13 21:31:36","1","21");



CREATE TABLE `empleados` (
  `id_empleado` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) NOT NULL,
  `puesto` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `telefono` varchar(15) DEFAULT NULL,
  `fecha_contratacion` date DEFAULT curdate(),
  PRIMARY KEY (`id_empleado`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




CREATE TABLE `empresa` (
  `id_empresa` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `estado` varchar(100) NOT NULL,
  `ciudad` varchar(100) NOT NULL,
  `direccion` varchar(255) NOT NULL,
  `telefono` varchar(20) NOT NULL,
  `email` varchar(100) NOT NULL,
  `moneda` varchar(10) NOT NULL,
  `logo` blob DEFAULT NULL,
  PRIMARY KEY (`id_empresa`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO empresa VALUES("1","Mi Empresa","San Miguel","San Miguel","123 Calle Falsa","123456789","info@miempresa.com","$","../img/softunicorn.png");



CREATE TABLE `modulos` (
  `id_modulo` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_modulo` varchar(255) NOT NULL,
  PRIMARY KEY (`id_modulo`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO modulos VALUES("1","Inicio");
INSERT INTO modulos VALUES("2","Clientes");
INSERT INTO modulos VALUES("3","Autos");
INSERT INTO modulos VALUES("4","Rentas");
INSERT INTO modulos VALUES("5","Pagos");
INSERT INTO modulos VALUES("6","Caja");
INSERT INTO modulos VALUES("7","Efectivo");
INSERT INTO modulos VALUES("8","Permisos");
INSERT INTO modulos VALUES("9","Usuarios");
INSERT INTO modulos VALUES("10","Empresa");



CREATE TABLE `pagos` (
  `id_pago` int(11) NOT NULL AUTO_INCREMENT,
  `id_cliente` int(11) NOT NULL,
  `id_renta` int(11) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `monto` int(11) NOT NULL,
  `fecha_pago` datetime NOT NULL,
  `metodo_pago` enum('Efectivo','Tarjeta de Crédito','Transferencia Bancaria','Otro') NOT NULL,
  `estado` enum('Pendiente','Completo') DEFAULT 'Pendiente',
  `descripcion` text DEFAULT NULL,
  `caja_id` int(11) NOT NULL,
  PRIMARY KEY (`id_pago`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO pagos VALUES("1","1","1","1","180","2024-08-10 21:17:28","Efectivo","Completo","NULL","21");
INSERT INTO pagos VALUES("2","71","2","1","240","2024-08-10 21:18:39","Efectivo","Completo","NULL","21");
INSERT INTO pagos VALUES("3","100","3","3","150","2024-08-10 21:27:37","Efectivo","Completo","NULL","23");
INSERT INTO pagos VALUES("4","3","4","1","130","2024-08-11 09:10:08","Efectivo","Completo","NULL","21");
INSERT INTO pagos VALUES("5","94","5","3","90","2024-08-11 09:14:21","Efectivo","Completo","NULL","23");
INSERT INTO pagos VALUES("6","82","6","3","160","2024-08-11 09:40:59","Efectivo","Completo","NULL","23");
INSERT INTO pagos VALUES("7","2","7","3","150","2024-08-11 10:05:51","Efectivo","Completo","NULL","23");
INSERT INTO pagos VALUES("8","98","8","3","100","2024-08-11 10:14:01","Efectivo","Completo","NULL","23");
INSERT INTO pagos VALUES("9","101","9","3","150","2024-08-11 10:29:10","Efectivo","Completo","NULL","23");
INSERT INTO pagos VALUES("10","79","10","1","130","2024-08-12 15:54:31","Efectivo","Completo","NULL","21");
INSERT INTO pagos VALUES("11","100","11","1","100","2024-08-13 21:32:58","Efectivo","Completo","NULL","21");



CREATE TABLE `permisos` (
  `id_permiso` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_permiso` varchar(255) NOT NULL,
  `id_modulo` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_permiso`),
  KEY `id_modulo` (`id_modulo`),
  CONSTRAINT `permisos_ibfk_1` FOREIGN KEY (`id_modulo`) REFERENCES `modulos` (`id_modulo`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO permisos VALUES("1","ver_clientes","2");
INSERT INTO permisos VALUES("2","editar_clientes","2");
INSERT INTO permisos VALUES("3","borrar_clientes","2");
INSERT INTO permisos VALUES("4","ver_autos","3");
INSERT INTO permisos VALUES("5","editar_autos","3");
INSERT INTO permisos VALUES("6","borrar_autos","3");
INSERT INTO permisos VALUES("7","ver_rentas","4");
INSERT INTO permisos VALUES("8","editar_rentas","4");
INSERT INTO permisos VALUES("9","borrar_rentas","4");
INSERT INTO permisos VALUES("10","ver_pagos","5");
INSERT INTO permisos VALUES("11","editar_pagos","5");
INSERT INTO permisos VALUES("12","borrar_pagos","5");
INSERT INTO permisos VALUES("13","ver_caja","6");
INSERT INTO permisos VALUES("14","editar_caja","6");
INSERT INTO permisos VALUES("15","borrar_caja","6");
INSERT INTO permisos VALUES("16","ver_efectivo","7");
INSERT INTO permisos VALUES("17","editar_efectivo","7");
INSERT INTO permisos VALUES("18","borrar_efectivo","7");
INSERT INTO permisos VALUES("19","ver_permisos","8");
INSERT INTO permisos VALUES("20","editar_permisos","8");
INSERT INTO permisos VALUES("21","borrar_permisos","8");
INSERT INTO permisos VALUES("22","ver_usuarios","9");
INSERT INTO permisos VALUES("23","editar_usuarios","9");
INSERT INTO permisos VALUES("24","borrar_usuarios","9");
INSERT INTO permisos VALUES("25","ver_empresa","10");
INSERT INTO permisos VALUES("26","editar_empresa","10");
INSERT INTO permisos VALUES("27","borrar_empresa","10");



CREATE TABLE `rentas` (
  `id_renta` int(11) NOT NULL AUTO_INCREMENT,
  `id_cliente` int(11) DEFAULT NULL,
  `id_auto` int(11) DEFAULT NULL,
  `id_usuario` int(11) DEFAULT NULL,
  `fecha_renta` date NOT NULL,
  `fecha_devolucion` date NOT NULL,
  `precio_total` decimal(10,2) NOT NULL,
  `fecha_registro` datetime NOT NULL,
  `estado` varchar(50) DEFAULT 'En Proceso',
  `pago` enum('Pendiente','Completo') NOT NULL,
  PRIMARY KEY (`id_renta`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO rentas VALUES("1","1","23","1","2024-08-11","2024-08-14","180.00","2024-08-10 21:17:16","Entregado","Completo");
INSERT INTO rentas VALUES("2","71","39","1","2024-08-11","2024-08-13","130.00","2024-08-10 21:18:16","Devuelto","Completo");
INSERT INTO rentas VALUES("3","100","44","3","2024-08-11","2024-08-14","150.00","2024-08-10 21:27:25","Entregado","Completo");
INSERT INTO rentas VALUES("4","3","34","1","2024-08-11","2024-08-13","90.00","2024-08-11 09:09:50","Devuelto","Completo");
INSERT INTO rentas VALUES("5","94","7","3","2024-08-11","2024-08-13","100.00","2024-08-11 09:14:10","Devuelto","Completo");
INSERT INTO rentas VALUES("6","82","11","3","2024-08-11","2024-08-14","165.00","2024-08-11 09:40:26","Entregado","Completo");
INSERT INTO rentas VALUES("7","2","5","3","2024-08-11","2024-08-14","150.00","2024-08-11 10:02:17","Entregado","Completo");
INSERT INTO rentas VALUES("8","98","44","3","2024-08-11","2024-08-13","100.00","2024-08-11 10:13:41","Devuelto","Completo");
INSERT INTO rentas VALUES("9","101","19","3","2024-08-11","2024-08-14","150.00","2024-08-11 10:19:08","Entregado","Completo");
INSERT INTO rentas VALUES("10","79","22","1","2024-08-12","2024-08-14","130.00","2024-08-12 15:54:21","Entregado","Completo");
INSERT INTO rentas VALUES("11","100","44","1","2024-08-13","2024-08-15","100.00","2024-08-13 21:32:35","Entregado","Completo");



CREATE TABLE `roles` (
  `id_rol` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_rol` varchar(50) NOT NULL,
  PRIMARY KEY (`id_rol`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO roles VALUES("1","Cajero");
INSERT INTO roles VALUES("2","Administrador");
INSERT INTO roles VALUES("3","Usuario");
INSERT INTO roles VALUES("5","Empleado");



CREATE TABLE `roles_permisos` (
  `id_rol` int(11) NOT NULL,
  `id_permiso` int(11) NOT NULL,
  PRIMARY KEY (`id_rol`,`id_permiso`),
  KEY `id_permiso` (`id_permiso`),
  CONSTRAINT `roles_permisos_ibfk_1` FOREIGN KEY (`id_rol`) REFERENCES `roles` (`id_rol`) ON DELETE CASCADE,
  CONSTRAINT `roles_permisos_ibfk_2` FOREIGN KEY (`id_permiso`) REFERENCES `permisos` (`id_permiso`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO roles_permisos VALUES("1","1");
INSERT INTO roles_permisos VALUES("1","2");
INSERT INTO roles_permisos VALUES("1","16");
INSERT INTO roles_permisos VALUES("1","17");
INSERT INTO roles_permisos VALUES("2","1");
INSERT INTO roles_permisos VALUES("2","2");
INSERT INTO roles_permisos VALUES("2","3");
INSERT INTO roles_permisos VALUES("2","4");
INSERT INTO roles_permisos VALUES("2","5");
INSERT INTO roles_permisos VALUES("2","6");
INSERT INTO roles_permisos VALUES("2","7");
INSERT INTO roles_permisos VALUES("2","8");
INSERT INTO roles_permisos VALUES("2","9");
INSERT INTO roles_permisos VALUES("2","10");
INSERT INTO roles_permisos VALUES("2","11");
INSERT INTO roles_permisos VALUES("2","12");
INSERT INTO roles_permisos VALUES("2","13");
INSERT INTO roles_permisos VALUES("2","14");
INSERT INTO roles_permisos VALUES("2","15");
INSERT INTO roles_permisos VALUES("2","16");
INSERT INTO roles_permisos VALUES("2","17");
INSERT INTO roles_permisos VALUES("2","18");
INSERT INTO roles_permisos VALUES("2","19");
INSERT INTO roles_permisos VALUES("2","20");
INSERT INTO roles_permisos VALUES("2","21");
INSERT INTO roles_permisos VALUES("2","22");
INSERT INTO roles_permisos VALUES("2","23");
INSERT INTO roles_permisos VALUES("2","24");
INSERT INTO roles_permisos VALUES("2","25");
INSERT INTO roles_permisos VALUES("2","26");
INSERT INTO roles_permisos VALUES("2","27");
INSERT INTO roles_permisos VALUES("3","1");
INSERT INTO roles_permisos VALUES("3","4");
INSERT INTO roles_permisos VALUES("3","7");
INSERT INTO roles_permisos VALUES("3","10");
INSERT INTO roles_permisos VALUES("3","13");
INSERT INTO roles_permisos VALUES("3","16");
INSERT INTO roles_permisos VALUES("3","19");



CREATE TABLE `sucursales` (
  `id_sucursal` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `direccion` varchar(255) NOT NULL,
  `telefono` varchar(15) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  PRIMARY KEY (`id_sucursal`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




CREATE TABLE `usuarios` (
  `id_usuario` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_usuario` varchar(50) NOT NULL,
  `contra` varchar(255) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `rol` enum('Administrador','Empleado','Cliente') DEFAULT 'Cliente',
  PRIMARY KEY (`id_usuario`),
  UNIQUE KEY `nombre_usuario` (`nombre_usuario`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO usuarios VALUES("1","admin","$2y$10$OG0FBM/h8QG2rz97BriI0OKvI17A9bifo4d9Wf7TCjBdMshiJD4RS","Administrador","Por Defecto","admin@ejemplo.com","Administrador");
INSERT INTO usuarios VALUES("3","juan","$2y$10$aTgxutRStFD8LV8L9M0Rs.Cvsf6Hn8yBpdrgCHcfUlcmQ.ePGIYWO","Juan Test","Perez Test","juan@gmail.com","NULL");
INSERT INTO usuarios VALUES("4","ana","$2y$10$VZDC5PbTmENjVIbUwr4pTOMCYsqO3q.K5fQqGaYhdMsMUZeUBo6T6","Ana guadalupe","Solado de Lopez","analopez@gmail.com","Cliente");
INSERT INTO usuarios VALUES("5","pamela","$2y$10$0/..azsv28wsj6SqCWsEAuW12z2f1659FNRxpg1SDddCs7s.kj/o2","Pamela Michell","Parada Chupa","pamelamichell@gmail.com","Cliente");



CREATE TABLE `usuarios_roles` (
  `id_usuario` int(11) NOT NULL,
  `id_rol` int(11) NOT NULL,
  PRIMARY KEY (`id_usuario`,`id_rol`),
  KEY `id_rol` (`id_rol`),
  CONSTRAINT `usuarios_roles_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`) ON DELETE CASCADE,
  CONSTRAINT `usuarios_roles_ibfk_2` FOREIGN KEY (`id_rol`) REFERENCES `roles` (`id_rol`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO usuarios_roles VALUES("1","2");
INSERT INTO usuarios_roles VALUES("3","3");
INSERT INTO usuarios_roles VALUES("4","1");

