<?php
session_start();

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    // Redirige al usuario a la página de inicio de sesión
    header('Location: ../403.php');
    exit;
}

// Si el usuario está autenticado, muestra el archivo solicitado
$path = $_SERVER['REQUEST_URI'];
$file = __DIR__ . parse_url($path, PHP_URL_PATH);

// Verifica si el archivo solicitado existe
if (file_exists($file)) {
    include $file;
} else {
    // Archivo no encontrado
    header('HTTP/1.0 404 Not Found');
    echo 'Archivo no encontrado.';
}
?>
