<?php
session_start();
require '../config.php';
require '../functions.php';

if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

$usuario_id = $_SESSION['usuario_id'];

if (isset($_GET['id_caja'])) {
    $id_caja = intval($_GET['id_caja']);

    try {
        // Obtener la última apertura antes del cierre actual
        $sqlApertura = "SELECT id_caja, monto, usuario_id
                        FROM caja
                        WHERE tipo = 'apertura' AND id_caja = :id_caja
                        ORDER BY id_caja DESC
                        LIMIT 1";
        $stmtApertura = $pdo->prepare($sqlApertura);
        $stmtApertura->bindParam(':id_caja', $id_caja, PDO::PARAM_INT);
        $stmtApertura->execute();
        $apertura = $stmtApertura->fetch(PDO::FETCH_ASSOC);

        if (!$apertura) {
            echo 'No se encontró la última apertura de caja.';
            exit;
        }

        $id_caja_apertura = $apertura['id_caja'];
        $monto_apertura = $apertura['monto'];
        $usuario_id_apertura = $apertura['usuario_id'];

        // Obtener ingresos y egresos de efectivo asociados con la apertura de caja
        $sqlEfectivo = "SELECT 
                            SUM(CASE WHEN tipo = 'ingreso' THEN monto ELSE 0 END) AS ingresos_efectivo,
                            SUM(CASE WHEN tipo = 'egreso' THEN monto ELSE 0 END) AS egresos_efectivo
                        FROM efectivo 
                        WHERE caja_id = :id_caja_apertura";
        $stmtEfectivo = $pdo->prepare($sqlEfectivo);
        $stmtEfectivo->bindParam(':id_caja_apertura', $id_caja_apertura, PDO::PARAM_INT);
        $stmtEfectivo->execute();
        $efectivo = $stmtEfectivo->fetch(PDO::FETCH_ASSOC);

        if (!$efectivo) {
            echo 'No se encontraron datos de efectivo.';
            exit;
        }

        $ingresos_efectivo = $efectivo['ingresos_efectivo'] ?? 0;
        $egresos_efectivo = $efectivo['egresos_efectivo'] ?? 0;

        // Obtener el total de pagos asociados con la apertura de caja
        $sqlPagos = "SELECT 
                        SUM(monto) AS total_pagos
                    FROM pagos
                    WHERE caja_id = :id_caja_apertura";
        $stmtPagos = $pdo->prepare($sqlPagos);
        $stmtPagos->bindParam(':id_caja_apertura', $id_caja_apertura, PDO::PARAM_INT);
        $stmtPagos->execute();
        $pagos = $stmtPagos->fetch(PDO::FETCH_ASSOC);

        $total_pagos = $pagos['total_pagos'] ?? 0;

        // Calcular totales
        $total_ingresos = $monto_apertura + $ingresos_efectivo + $total_pagos;
        $total_egresos = $egresos_efectivo;
        $diferencia = $total_ingresos - $total_egresos;

        // Obtener información del usuario y de la empresa para el reporte
        $sqlUsuario = "SELECT nombre, apellido FROM usuarios WHERE id_usuario = :usuario_id";
        $stmtUsuario = $pdo->prepare($sqlUsuario);
        $stmtUsuario->bindParam(':usuario_id', $usuario_id_apertura, PDO::PARAM_INT);
        $stmtUsuario->execute();
        $usuario = $stmtUsuario->fetch(PDO::FETCH_ASSOC);

        $usuario_nombre = $usuario['nombre'] ?? '';
        $usuario_apellido = $usuario['apellido'] ?? '';

        $sqlEmpresa = "SELECT nombre, direccion, estado, ciudad, telefono, email FROM empresa LIMIT 1";
        $stmtEmpresa = $pdo->prepare($sqlEmpresa);
        $stmtEmpresa->execute();
        $empresa = $stmtEmpresa->fetch(PDO::FETCH_ASSOC);

        // Generar el HTML del ticket de corte de caja
        ?>
<!DOCTYPE html>
<html>
<head>
    <title>Ticket de Corte de Caja</title>
    <style>
        @page {
            margin: 0;
        }
        body {
            font-family: 'Courier New', monospace;
            margin: 0;
            padding: 0;
        }
        .ticket-container {
            width: 300px; /* Ajusta el ancho según tus necesidades */
            margin: 0 auto;
            padding: 10px;
            border: 1px solid #ddd;
            font-size: 12px;
            text-align: center;
        }
        .header {
            margin-bottom: 10px;
        }
        .header h1 {
            font-size: 14px;
            margin: 0;
        }
        .header p {
            margin: 2px 0;
        }
        .ticket-info {
            text-align: left;
            margin-top: 10px;
        }
        .ticket-info p {
            margin: 5px 0;
            display: flex;
            justify-content: space-between;
        }
        .line {
            border-top: 1px dashed #000;
            margin: 10px 0;
        }
        .footer {
            margin-top: 10px;
            font-size: 10px;
        }
    </style>
</head>
<body>
    <div class="ticket-container">
        <!--<div class="header">
            <h1><?php echo htmlspecialchars($empresa['nombre']); ?></h1>
            <p><?php echo htmlspecialchars($empresa['direccion']); ?></p>
            <p><?php echo htmlspecialchars($empresa['estado']) . ', ' . htmlspecialchars($empresa['ciudad']); ?></p>
            <p>Tel: <?php echo htmlspecialchars($empresa['telefono']); ?></p>
            <p>Email: <?php echo htmlspecialchars($empresa['email']); ?></p>
        </div>-->
        <div class="ticket-info">
            <!-- <div class="line"></div>-->
            <p><span>ID:</span> <span><?php echo htmlspecialchars($id_caja_apertura); ?></span></p>
            <p><span>Monto Apertura:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $monto_apertura)); ?></span></p>
            <p><span>Ingresos de Efectivo:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $ingresos_efectivo, 2)); ?></span></p>
            <p><span>Egresos de Efectivo:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $egresos_efectivo, 2)); ?></span></p>
            <p><span>Total Pagos:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $total_pagos, 2)); ?></span></p>
            <p><span>Total Ingresos:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $total_ingresos, 2)); ?></span></p>
            <p><span>Total Egresos:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $total_egresos, 2)); ?></span></p>
            <p><span>Diferencia:</span> <span><?php echo htmlspecialchars(formatMonto($moneda, $diferencia, 2)); ?></span></p>
            <p><span>Usuario:</span> <span><?php echo htmlspecialchars($usuario_nombre . ' ' . $usuario_apellido); ?></span></p>
        </div>
        <div class="footer">
            <p>Información Temporar </p>
        </div>
    </div>
</body>
</html>
        <?php
    } catch (Exception $e) {
        echo 'Error: ' . htmlspecialchars($e->getMessage());
    }
} else {
    echo 'ID de caja no especificado.';
}
?>
