<?php
include '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $apellido = $_POST['apellido'];
    $documento = $_POST['documento'];
    $telefono = $_POST['telefono'];
    $email = $_POST['email'];

    try {
        $sql = "INSERT INTO clientes (nombre, apellido, direccion, telefono, email, documento, fecha_registro) 
                VALUES (:nombre, :apellido, NULL, :telefono, :email, :documento, CURDATE())";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':apellido', $apellido);
        $stmt->bindParam(':telefono', $telefono);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':documento', $documento);
        $stmt->execute();

        // Obtener el ID del cliente recién agregado
        $id_cliente = $pdo->lastInsertId();

        // Responder con los datos del cliente agregado
        echo json_encode([
            'status' => 'success',
            'message' => 'Cliente agregado correctamente.',
            'data' => [
                'id_cliente' => $id_cliente,
                'nombre' => $nombre,
                'apellido' => $apellido
            ]
        ]);
    } catch (Exception $e) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Error al guardar el cliente: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Método de solicitud no válido.'
    ]);
}
