<?php
require '../config.php';

header('Content-Type: application/json');

// Verificar que se reciba el ID del evento
if (isset($_GET['id'])) {
    $id_renta = $_GET['id'];

    try {
        // Consulta para obtener los detalles del evento junto con los datos del cliente
        $sql = "SELECT 
                    r.id_renta, 
                    r.id_auto, 
                    r.fecha_renta, 
                    r.fecha_devolucion, 
                    h.id_habitacion, 
                    h.nombre_habitacion, 
                    h.numero_habitacion, 
                    c.nombre AS cliente_nombre, 
                    c.apellido AS cliente_apellido, 
                    c.telefono AS cliente_telefono, 
                    c.email AS cliente_email 
                FROM rentas r
                JOIN habitaciones h ON r.id_auto = h.id_habitacion
                JOIN clientes c ON r.id_cliente = c.id_cliente
                WHERE r.id_renta = :id";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id_renta, PDO::PARAM_INT);
        $stmt->execute();

        $event = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($event) {
            echo json_encode($event);
        } else {
            echo json_encode(['error' => 'Event not found']);
        }

    } catch (PDOException $e) {
        echo json_encode(['error' => $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'Invalid event ID']);
}
