<?php
header('Content-Type: application/json');
require_once '../config.php'; // Conexión a la base de datos

// Verificar que los datos estén completos
if (empty($_POST['nombre']) || empty($_POST['apellido']) || empty($_POST['documento']) || empty($_POST['id_cliente']) || empty($_POST['id_renta'])) {
    echo json_encode(['status' => 'error', 'message' => 'Datos incompletos.']);
    exit;
}

try {
    // Insertar en la base de datos
    $sql = "INSERT INTO huespedes (id_cliente, id_renta, nombre, apellido, documento) 
            VALUES (:id_cliente, :id_renta, :nombre, :apellido, :documento)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':id_cliente' => $_POST['id_cliente'],
        ':id_renta' => $_POST['id_renta'],
        ':nombre' => $_POST['nombre'],
        ':apellido' => $_POST['apellido'],
        ':documento' => $_POST['documento']
        
    ]);

    // Respuesta exitosa
    echo json_encode(['status' => 'success']);
} catch (Exception $e) {
    // Respuesta de error
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
