<?php
session_start();
require '../config.php'; // Asegúrate de que este archivo configure la conexión PDO
require '../functions.php'; // Incluye funciones adicionales si las necesitas

// Verificar si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../clientes/crud_clientes.php');
    exit;
}

// Verificar si se ha recibido el id_cuenta por GET
if (!isset($_GET['id_cuenta']) || !filter_var($_GET['id_cuenta'], FILTER_VALIDATE_INT)) {
    echo "<script>
            alert('No se ha especificado un cuenta válido.');
            window.location.href = '../rentas/crud_rentas.php';
          </script>";
    exit;
}

$id_cuenta = (int)$_GET['id_cuenta']; // Asegurarse de que el ID sea un entero

// Consultar los detalles del Cuenta
try {
    $stmt = $pdo->prepare("SELECT * FROM rentas WHERE id_renta = :id_cuenta");
    $stmt->bindParam(':id_cuenta', $id_cuenta, PDO::PARAM_INT);
    $stmt->execute();
    $cuenta = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verificar si se encontró el cliente
    if (!$cuenta) {
        echo "<script>
                alert('No se encontró una Cuenta con el ID especificado.');
                window.location.href = '../rentas/crud_cuenta.php';
              </script>";
        exit;
    }
} catch (PDOException $e) {
    echo "<script>
            alert('Error: " . $e->getMessage() . "');
            window.location.href = '../rentas/crud_cuenta.php';
          </script>";
    exit;
}

if ($cuenta) {
    // Obtener las fechas con hora de renta y devolución
    $fechaRegistro = new DateTime($cuenta['fecha_renta']);
    $fechaDevolucion = new DateTime($cuenta['fecha_devolucion']);
    $fechaActual = new DateTime(); // Fecha y hora actuales

    // Calcular la diferencia total en segundos desde la fecha de renta hasta la fecha de devolución
    $totalTiempoEnSegundos = $fechaDevolucion->getTimestamp() - $fechaRegistro->getTimestamp();

    // Verificar si la fecha actual es anterior a la fecha de renta
    if ($fechaActual < $fechaRegistro) {
        // El tiempo aún no ha comenzado
        $tiempoRestanteEnSegundos = null; // Indicar que el tiempo aún no ha comenzado
    } else {
        // El tiempo ya comenzó, calcular el tiempo restante
        $tiempoRestanteEnSegundos = $fechaDevolucion->getTimestamp() - $fechaActual->getTimestamp();
    }

    // Evitar valores negativos
    if ($tiempoRestanteEnSegundos !== null && $tiempoRestanteEnSegundos < 0) {
        $tiempoRestanteEnSegundos = 0;
    }
} else {
    $totalTiempoEnSegundos = 1; // Evitar división por cero
    $tiempoRestanteEnSegundos = 0;
}



// Consultar el historial de rentas
try {
    $stmt = $pdo->prepare("
        SELECT r.*, 
               a.nombre_habitacion, 
               a.numero_habitacion, 
               a.tipo, 
               DATEDIFF(r.fecha_devolucion, r.fecha_renta) AS dias, 
               (DATEDIFF(r.fecha_devolucion, r.fecha_renta) * a.precio_diario) AS precio_total
        FROM rentas r
        JOIN habitaciones a ON r.id_auto = a.id_habitacion
        WHERE r.id_renta = :id_cuenta
    ");
    $stmt->bindParam(':id_cuenta', $id_cuenta, PDO::PARAM_INT);
    $stmt->execute();
    $rentas = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "<p>Error al cargar el historial: " . htmlspecialchars($e->getMessage()) . "</p>";
    $rentas = [];
}

// Obtener los servicios asociados a la reservación
try {
    $stmt_servicios = $pdo->prepare("
        SELECT sr.id, s.id_servicio, s.nombre, sr.cantidad, sr.total
        FROM servicios_reservacion sr
        JOIN servicios s ON sr.id_servicio = s.id_servicio
        WHERE sr.id_reservacion = :id_reservacion
    ");
    $stmt_servicios->bindParam(':id_reservacion', $id_cuenta, PDO::PARAM_INT);
    $stmt_servicios->execute();
    $servicios = $stmt_servicios->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "<script>
            alert('Error al cargar los servicios: " . $e->getMessage() . "');
          </script>";
    $servicios = [];
}


?>



<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cuenta - Sistema Hotel</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.5/dist/fullcalendar.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <style>
        .main-content {
            padding: 2rem;
        }
       
        #calendar {
            max-width: 1100px;
            margin: 0 auto;
        }
        .card {
            margin-bottom: 20px;
        }
        .input-group .form-control {
            border-right: 0;
        }
        .input-group .input-group-append .btn {
            border-left: 0;
        }
        .form-inline .form-control {
            width: auto;
        }
        .selected {
    background-color: #d3f9d8; /* Color de fondo verde claro */
    color: #155724; /* Color de texto verde oscuro */
}
/* Estilo para los totales */
#reservationDetails p {
    margin-bottom: 1rem;
}

#reservationDetails .font-weight-bold {
    font-size: 1.2rem;
}

#reservationDetails .text-right {
    font-size: 1.1rem;
}

#reservationDetails .text-success {
    font-size: 1.2rem;
    color: #28a745; /* Verde para total general */
}

.modal-body {
    padding: 30px;
}

#amount {
    font-size: 1.1rem;
    font-weight: bold;
}

#submitButton {
    font-size: 1.2rem;
    padding: 10px 30px;
}

#contador {
    font-size: 2rem;
    color: #007bff;
    text-align: center;
    padding: 10px;
    border: 2px solid #28a745;
    border-radius: 10px;
    background-color: #f8f9fa;
    width: fit-content;
    margin: 20px auto;
}

    </style>
</head>
<body>
    <?php include '../menu.php'; ?>

    <div class="main-content">
        <div class="d-flex align-items-center justify-content-center p-3 my-3 text-white bg-dark rounded shadow-sm">
            <div class="lh-1 text-center">
                <h2 class="mb-4 text-center">
                    <i class="fas fa-file-alt"></i> <!-- Icono de FontAwesome -->
                    Detalle de Cuenta
                </h2>
            </div>
        </div>

        <div class="row">
            <!-- Detalles del Cliente -->
            <div class="col-lg-4 mb-4">
    <div class="card shadow">
        <div class="card-body text-center">
            <!-- Ícono grande de usuario -->
            <i class="fa fa-user-circle fa-5x text-primary mb-3"></i>

            <?php
                // Consulta para obtener el cliente
                $id_cliente = $cuenta['id_cliente']; 
                $sql = "SELECT nombre, apellido, telefono, email, documento FROM clientes WHERE id_cliente = :id_cliente";
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':id_cliente', $id_cliente, PDO::PARAM_INT);
                $stmt->execute();
                $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

                if ($cliente) {
                    echo '<h5 class="card-title mt-3">' . htmlspecialchars($cliente['nombre'] . ' ' . $cliente['apellido']) . '</h5>';
                    echo '<div class="text-start mt-4">';
                    echo '<p><i class="fa fa-id-card text-secondary me-2"></i> <strong>Documento:</strong> ' . htmlspecialchars($cliente['documento']) . '</p>';
                    echo '<p><i class="fa fa-phone text-secondary me-2"></i> <strong>Teléfono:</strong> ' . htmlspecialchars($cliente['telefono']) . '</p>';
                    echo '<p><i class="fa fa-envelope text-secondary me-2"></i> <strong>Email:</strong> ' . htmlspecialchars($cliente['email']) . '</p>';
                    echo '</div>';
                } else {
                    echo '<h5 class="card-title mt-3 text-danger">Cliente no encontrado</h5>';
                }
            ?>

            <a href="../rentas/crud_rentas.php" class="btn btn-primary mt-4">
                <i class="fa fa-reply"></i> Regresar
            </a>

            <div id="contador" style="font-size: 1.5rem; font-weight: bold; color: #28a745;">
                Cargando contador...
            </div>
            <div class="progress" style="height: 30px; margin: 20px auto; width: 80%; border-radius: 15px; background-color: #e9ecef;">
                <div id="barraProgreso" class="progress-bar" role="progressbar" 
                    style="width: 0%; background-color: #007bff; text-align: center; color: white; font-weight: bold;">
                    0%
                </div>
            </div>

            <!-- Tabla de huéspedes -->
            <h5 class="card-title mt-3">Huéspedes</h5>
            <?php
                $stmt = $pdo->prepare("SELECT id_huesped, nombre, apellido, documento FROM huespedes WHERE id_renta = $id_cuenta");
                $stmt->execute();
                $huespedes = $stmt->fetchAll(PDO::FETCH_ASSOC);
            ?>

            <!-- Contenedor con scroll -->
            <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
            <table id="tablaHuespedes" class="table table-striped"> 
                <thead class="table-dark">
                    <tr>
                        <th>Nombre</th>
                        <th>Apellido</th>
                        <th>Documento</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($huespedes)): ?>
                        <?php foreach ($huespedes as $huesped): ?>
                            <tr>
                                <td><input type="text" class="form-control form-control-sm" value="<?= htmlspecialchars($huesped['nombre']) ?>" disabled></td>
                                <td><input type="text" class="form-control form-control-sm" value="<?= htmlspecialchars($huesped['apellido']) ?>" disabled></td>
                                <td><input type="text" class="form-control form-control-sm" value="<?= htmlspecialchars($huesped['documento']) ?>" disabled></td>
                                <td>
                                    <button class="btn btn-danger btn-sm eliminarFila" data-id="<?= $huesped['id_huesped'] ?>">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center text-muted">No hay huéspedes ingresados.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

            </div>

            <!-- Botón para agregar nueva fila -->
            <button class="btn btn-success mt-3" id="agregarHuesped">
                <i class="fa fa-user-plus"></i> Agregar Huésped
            </button>
        </div>
    </div>
</div>


            <!-- Lista de Archivos -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        Facturacion
                    </div>
                    <div class="card-body">

                    <table class="table table-bordered table-striped">
                    <thead class="thead-dark">
                        <tr>
                            <th>ID Reserva</th>
                            <th>Habitación</th>
                            <th>Fecha de Check-in</th>
                            <th>Fecha de Check-out</th>
                            <th>Estadía</th>
                            <th>Precio Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($rentas) > 0): ?>
                            <?php foreach ($rentas as $renta): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($renta['id_renta']); ?></td>
                                    <td>
                                        <?php echo htmlspecialchars($renta['nombre_habitacion'] . ' ' . $renta['numero_habitacion'] . ' ' . $renta['tipo']); ?>
                                    </td>
                                    <td><?php echo htmlspecialchars(formatearFecha($renta['fecha_renta'])); ?></td>
                                    <td><?php echo htmlspecialchars(formatearFecha($renta['fecha_devolucion'])); ?></td>
                                    <td><?php echo htmlspecialchars($renta['dias']); ?> días</td>
                                    <td><?php echo formatMonto($moneda, $renta['precio_total']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center">No hay datos resevacion para esta cuenta.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                        <div class="container mt-5">
                        <div class="row g-3 align-items-end">
                            <!-- Campo de texto para servicios -->
                            <div class="col-md-6">
                                <label for="servicio" class="form-label">Servicios:</label>
                                <input type="text" id="servicio" class="form-control" placeholder="Buscar servicios..." autocomplete="off">
                                <ul id="resultadoBusqueda" class="list-group mt-1" style="display: none;"></ul> <!-- Lista de resultados -->
                                <!-- Contenedor invisible para almacenar el id del servicio y precio -->
                                <input type="hidden" id="id_servicio" />
                                <input type="hidden" id="precio_servicio" />
                            </div>

                            <!-- Campo de texto para cantidad -->
                            <div class="col-md-3">
                                <label for="cantidad" class="form-label">Cantidad:</label>
                                <input type="number" id="cantidad" class="form-control" value="1" min="1">
                            </div>

                            <!-- Botón para agregar -->
                            <div class="col-md-3">
                                <button id="agregar" class="btn btn-secondary w-100">
                                    <i class="fas fa-plus"></i> Agregar
                                </button>
                            </div>
                        </div>
                                <!-- Tabla de servicios -->
                                <div class="table-responsive mt-4">
                                <table id="tablaServicios" class="table table-bordered table-striped text-center">
    <thead class="table-dark">
        <tr>
            <th>Servicio</th>
            <th>Cantidad</th>
            <th>Total</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $totalServicios = 0; 
        if (count($servicios) > 0): 
        ?>
            <?php foreach ($servicios as $servicio): ?>
                <tr>
                    <td><?php echo htmlspecialchars($servicio['nombre']); ?></td>
                    <td><?php echo htmlspecialchars($servicio['cantidad']); ?></td>
                    <td><?php echo formatMonto($moneda, $servicio['total']); ?></td>
                    <td>
                        <button 
                            class="btn btn-danger btn-sm"
                            onclick="eliminarServicio(<?php echo $servicio['id']; ?>)">
                            <i class="fas fa-trash-alt"></i> Quitar
                        </button>
                    </td>
                </tr>
                <?php 
                $totalServicios += $servicio['total']; 
                ?>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="4" class="text-center">No se han reservado servicios.</td>
            </tr>
        <?php endif; ?>
    </tbody>
    <?php
    $totalRentas = 0; 

    if (count($rentas) > 0) {
        foreach ($rentas as $renta) {
            $totalRentas += $renta['precio_total']; 
        }
    }

    $totalGeneral = $totalRentas + $totalServicios; 
    ?>

    <tfoot>
        <tr>
            <th colspan="2" style="text-align: right;">Total de Servicios:</th>
            <th><?php echo formatMonto($moneda, $totalServicios); ?></th>
        </tr>
        <tr>
            <th colspan="2" style="text-align: right;">Total de Habitación:</th>
            <th><?php echo formatMonto($moneda, $totalRentas); ?></th>
        </tr>
        <tr class="table-success">
            <th colspan="2" style="text-align: right;">Total General:</th>
            <th id="totalGeneral"><?php echo formatMonto($moneda, $totalGeneral); ?></th>
        </tr>
        <tr>
    <th colspan="2" style="text-align: right;">Descuento:</th>
    <th>
        <div class="input-group">
            <input type="number" id="descuento" class="form-control" placeholder="Ingrese descuento" min="0">
            <select id="tipoDescuento" class="form-control">
                <option value="moneda">Moneda</option>
                <option value="porcentaje">Porcentaje</option>
            </select>
            <button id="aplicarDescuentoBtn" class="btn btn-primary">Aplicar</button>
        </div>
    </th>
</tr>

        <tr class="table-warning">
            <th colspan="2" style="text-align: right;">Total con Descuento:</th>
            <th id="totalConDescuento"><?php echo formatMonto($moneda, $totalGeneral); ?></th>
        </tr>
    </tfoot>
</table>


                                    <div class="mt-4 text-center">
                                        <button id="btnCobrar" class="btn btn-success btn-lg">
                                            <i class="fas fa-cash-register"></i> Realizar Cobro
                                        </button>
                                    </div>

                                </div>
                            </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- Modal para detalles de la reservación -->
        <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog" aria-labelledby="detailsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <!-- Modal Header -->
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title" id="detailsModalLabel">Detalles de la Reservación</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <div id="reservationDetails" class="mb-4"></div>
                        <form id="paymentForm">
                            <input type="hidden" id="id_cliente" value="<?php echo htmlspecialchars($renta['id_cliente']); ?>">
                            <input type="hidden" id="id_renta" value="<?php echo htmlspecialchars($renta['id_renta']); ?>">
                            <input type="hidden" id="descuentoAplicado" value="">

                            
                            <!-- Fila para alinear los campos horizontalmente -->
                            <div class="row">
                                <!-- Columna para el campo "Monto a Pagar" -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="amount" class="font-weight-bold">Monto a Pagar:</label>
                                        <input type="number" step="0.01" class="form-control" id="amount" placeholder="Ingresa el monto" required>
                                    </div>
                                </div>
                                
                                <!-- Columna para el campo "Método de Pago" -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="metodo_pago" class="font-weight-bold">Método de Pago:</label>
                                        <select class="form-control" id="metodo_pago" required>
                                            <option value="Efectivo">Efectivo</option>
                                            <option value="Tarjeta de Crédito">Tarjeta de Crédito</option>
                                            <option value="Transferencia Bancaria">Transferencia Bancaria</option>
                                            <option value="Otro">Otro</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group text-right">
                                <button id="submitButton" type="submit" class="btn btn-success btn-lg">
                                    <i class="fas fa-check-circle"></i> Realizar Pago
                                </button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>

    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.5/dist/fullcalendar.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script type="text/javascript">
        // Establecer la variable id_cuenta en JavaScript
        var id_cuenta = <?php echo json_encode($id_cuenta); ?>;
    </script>
    <script type="text/javascript" src="cuenta.js"></script>

    <script>
   document.getElementById('btnCobrar').addEventListener('click', function () {
    // Obtener los totales de PHP
    const totalServicios = <?php echo json_encode($totalServicios); ?>;
    const totalRentas = <?php 
        $totalRentas = 0;
        foreach ($rentas as $renta) {
            $totalRentas += $renta['precio_total'];
        }
        echo json_encode($totalRentas);
    ?>;

    // Obtener el descuento y su tipo
    const descuento = parseFloat(document.getElementById('descuento').value) || 0;
    const tipoDescuento = document.getElementById('tipoDescuento').value;

    // Calcular el total general antes del descuento
    let totalGeneral = parseFloat(totalServicios) + parseFloat(totalRentas);

    // Aplicar el descuento
    if (tipoDescuento === 'moneda') {
        totalGeneral -= descuento;
    } else if (tipoDescuento === 'porcentaje') {
        totalGeneral -= totalGeneral * (descuento / 100);
    }

    // Asegurar que el total general no sea negativo
    totalGeneral = Math.max(totalGeneral, 0);

    // Mostrar mensaje con SweetAlert2
    Swal.fire({
        title: '¿Desea proceder con el cobro?',
        icon: 'info',
        showCancelButton: true,
        confirmButtonText: 'Cobrar',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            // Actualizar el campo hidden con el descuento aplicado
            document.getElementById('descuentoAplicado').value = tipoDescuento === 'moneda' ? descuento : (totalGeneral * (descuento / 100)).toFixed(2);

            // Cargar datos en la modal
            document.getElementById('reservationDetails').innerHTML = `
                <div class="d-flex justify-content-between align-items-center">
                    <p><strong>Total Servicios:</strong></p>
                    <p class="text-right">$${totalServicios.toFixed(2)}</p>
                </div>
                <div class="d-flex justify-content-between align-items-center">
                    <p><strong>Total Rentas:</strong></p>
                    <p class="text-right">$${totalRentas.toFixed(2)}</p>
                </div>
                <div class="d-flex justify-content-between align-items-center">
                    <p><strong>Descuento Aplicado:</strong></p>
                    <p class="text-right text-danger">- $${(tipoDescuento === 'moneda' ? descuento : (totalGeneral * (descuento / 100)).toFixed(2))}</p>
                </div>
                <div class="d-flex justify-content-between align-items-center font-weight-bold">
                    <p><strong>Total General:</strong></p>
                    <p class="text-right text-success">$${totalGeneral.toFixed(2)}</p>
                </div>
            `;
            document.getElementById('amount').value = totalGeneral.toFixed(2);

            // Mostrar la modal de Bootstrap
            $('#detailsModal').modal('show');
        }
    });
});



//Calcula el timpo
    let tiempoRestante = <?php echo $tiempoRestanteEnSegundos !== null ? $tiempoRestanteEnSegundos : 'null'; ?>;
    const tiempoTotal = <?php echo $totalTiempoEnSegundos; ?>;

    // Elementos del DOM
    const contador = document.getElementById('contador');
    const barraProgreso = document.getElementById('barraProgreso');

    // Función para actualizar el contador y la barra de progreso
    function actualizarContador() {
        if (tiempoRestante === null) {
            // El tiempo aún no ha comenzado (fecha_renta aún no ha pasado)
            contador.textContent = "Pendiente de inicio";
            barraProgreso.style.width = "0%";
            barraProgreso.textContent = "0%";
            barraProgreso.style.backgroundColor = "#ffc107"; // Color amarillo indicando que está pendiente
            return;
        }

        if (tiempoRestante <= 0) {
            // El tiempo ha pasado
            contador.textContent = "Tiempo cumplido";
            barraProgreso.style.width = "100%";
            barraProgreso.textContent = "100%";
            barraProgreso.style.backgroundColor = "#dc3545"; // Rojo indicando tiempo cumplido
            return;
        }

        // Calcular días, horas, minutos y segundos
        const dias = Math.floor(tiempoRestante / (3600 * 24));
        const horas = Math.floor((tiempoRestante % (3600 * 24)) / 3600);
        const minutos = Math.floor((tiempoRestante % 3600) / 60);
        const segundos = tiempoRestante % 60;

        // Actualizar el contenido del contador
        contador.textContent = `${dias} días, ${horas} horas, ${minutos} minutos, ${segundos} segundos`;

        // Calcular y actualizar el progreso
        const progreso = ((tiempoTotal - tiempoRestante) / tiempoTotal) * 100;
        barraProgreso.style.width = `${progreso.toFixed(2)}%`;
        barraProgreso.textContent = `${progreso.toFixed(0)}%`;

        // Reducir el tiempo restante
        tiempoRestante--;
    }

    // Inicializar el contador y la barra
    actualizarContador(); // Mostrar inmediatamente
    setInterval(actualizarContador, 1000); // Actualizar cada segundo

    document.getElementById('aplicarDescuentoBtn').addEventListener('click', function () {
    const descuento = parseFloat(document.getElementById('descuento').value);
    const tipoDescuento = document.getElementById('tipoDescuento').value;
    const totalGeneralElem = document.getElementById('totalGeneral');
    const totalConDescuentoElem = document.getElementById('totalConDescuento');

    // Obtener el valor total general actual
    const totalGeneral = parseFloat(totalGeneralElem.textContent.replace(/[^\d.-]/g, ''));

    if (isNaN(descuento) || descuento <= 0) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Por favor, ingrese un descuento válido.',
        });
        return;
    }

    let totalConDescuento = totalGeneral;

    // Aplicar descuento según el tipo
    if (tipoDescuento === 'moneda') {
        if (descuento > totalGeneral) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'El descuento en moneda no puede ser mayor al total general.',
            });
            return;
        }
        totalConDescuento -= descuento;
    } else if (tipoDescuento === 'porcentaje') {
        if (descuento > 100) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'El descuento porcentual no puede ser mayor al 100%.',
            });
            return;
        }
        totalConDescuento -= (totalGeneral * (descuento / 100));
    }

    // Actualizar el valor en la tabla
    totalConDescuentoElem.textContent = formatMonto(totalConDescuento);

    // Mostrar mensaje de éxito
    Swal.fire({
        icon: 'success',
        title: 'Descuento aplicado',
        text: `El descuento se aplicó correctamente. Nuevo total: ${formatMonto(totalConDescuento)}`,
    });
});

// Función para formatear montos
function formatMonto(valor) {
    return new Intl.NumberFormat('es-MX', {
        style: 'currency',
        currency: 'MXN',
    }).format(valor);
}
// Botón para agregar un nuevo huésped
// Evento para agregar una nueva fila
document.getElementById('agregarHuesped').addEventListener('click', function () {
    const tabla = document.getElementById('tablaHuespedes').querySelector('tbody');

    // Crear una nueva fila
    const fila = document.createElement('tr');
    fila.innerHTML = `
        <td><input type="text" class="form-control form-control-sm" placeholder="Nombre"></td>
        <td><input type="text" class="form-control form-control-sm" placeholder="Apellido"></td>
        <td><input type="text" class="form-control form-control-sm" placeholder="Documento"></td>
        <td>
            <button class="btn btn-success btn-sm guardarFila">
                <i class="fa fa-save"></i>
            </button>
            <button class="btn btn-danger btn-sm eliminarFila">
                <i class="fa fa-trash"></i>
            </button>
        </td>
    `;

    // Agregar la fila a la tabla
    tabla.appendChild(fila);
});

// Evento para manejar el botón de guardar y eliminar en filas dinámicas
document.addEventListener('click', function (e) {
    // Botón Eliminar
    if (e.target.classList.contains('eliminarFila') || e.target.closest('.eliminarFila')) {
        const fila = e.target.closest('tr');
        fila.remove();
    }

    // Botón Guardar
   // Botón Guardar
if (e.target.classList.contains('guardarFila') || e.target.closest('.guardarFila')) {
    const fila = e.target.closest('tr');
    const nombre = fila.querySelector('td:nth-child(1) input').value.trim();
    const apellido = fila.querySelector('td:nth-child(2) input').value.trim();
    const documento = fila.querySelector('td:nth-child(3) input').value.trim();
    const idCliente = $('#id_cliente').val(); // Obtener el ID del cliente
    const idRenta = $('#id_renta').val(); // Obtener el ID de la renta

    // Validar que los campos no estén vacíos
    if (!nombre || !apellido || !documento) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Todos los campos son obligatorios.',
        });
        return;
    }

    // Enviar datos al servidor usando AJAX
    $.ajax({
        url: 'agregar_huesped.php',
        type: 'POST',
        data: { 
            nombre, 
            apellido, 
            documento, 
            id_cliente: idCliente, 
            id_renta: idRenta 
        },
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: '¡Huésped guardado!',
                    text: 'El huésped se guardó correctamente.',
                }).then(() => {
                    // Bloquear edición de los campos después de guardar
                    fila.querySelectorAll('input').forEach(input => input.disabled = true);
                    fila.querySelector('.guardarFila').disabled = true;
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: response.message || 'Ocurrió un error desconocido.',
                });
            }
        },
        error: function () {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Ocurrió un error al guardar el huésped. Intenta nuevamente.',
            });
        }
    });
}

});

document.addEventListener('click', function (e) {
    // Verificar si se hizo clic en un botón de eliminar
    if (e.target.classList.contains('eliminarFila') || e.target.closest('.eliminarFila')) {
        const botonEliminar = e.target.classList.contains('eliminarFila') ? e.target : e.target.closest('.eliminarFila');
        const fila = botonEliminar.closest('tr');
        const idHuesped = botonEliminar.dataset.id;

        if (idHuesped) {
            // Mostrar confirmación con SweetAlert
            Swal.fire({
                title: '¿Estás seguro?',
                text: "¡Esta acción no se puede deshacer!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, eliminar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Enviar solicitud AJAX al servidor
                    $.ajax({
                        url: 'eliminar_huesped.php',
                        type: 'POST',
                        data: { id_huesped: idHuesped },
                        success: function (response) {
                            try {
                                const jsonResponse = JSON.parse(response);
                                if (jsonResponse.status === 'success') {
                                    fila.remove();
                                    Swal.fire(
                                        'Eliminado',
                                        'El huésped ha sido eliminado correctamente.',
                                        'success'
                                    );
                                } else {
                                    Swal.fire(
                                        'Error',
                                        jsonResponse.message,
                                        'error'
                                    );
                                }
                            } catch (e) {
                                Swal.fire(
                                    'Error',
                                    'Respuesta del servidor no válida.',
                                    'error'
                                );
                            }
                        },
                        error: function () {
                            Swal.fire(
                                'Error',
                                'Ocurrió un error al eliminar el huésped.',
                                'error'
                            );
                        }
                    });
                }
            });
        } else {
            // Si la fila no tiene ID (es una fila recién creada que no se ha guardado)
            fila.remove();
        }
    }
});


    
</script>

</body>
</html>
