<?php
// Incluir el archivo de configuración para la conexión a la base de datos
require_once '../config.php';

try {
    // Verificar si se recibió el ID
    if (!isset($_POST['id'])) {
        echo json_encode(['status' => 'error', 'message' => 'ID del servicio no proporcionado.']);
        exit;
    }

    // Obtener el ID del servicio
    $id = intval($_POST['id']);

    // Preparar la consulta SQL para eliminar el registro por ID
    $sql = "DELETE FROM servicios_reservacion WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    // Ejecutar la consulta
    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Servicio eliminado correctamente.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No se pudo eliminar el servicio.']);
    }
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Excepción: ' . $e->getMessage()]);
}
