<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si la caja está aperturada
if (!isCajaAperturada($pdo)) {
    header('Location: ../caja_no_aperturada.php');
    exit;
}

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

// Verifica si el usuario tiene permiso para acceder a la página
if (!usuarioTienePermiso($pdo, $_SESSION['usuario_id'], 'ver_datos')) {
    header('Location: ../sin_permiso.php');
    exit;
}

// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_datos'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_datos'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_datos'),
];

// Asegúrate de que el usuario tenga permisos para eliminar datos
if (!$permisos['eliminar']) {
    echo json_encode(['status' => 'error', 'message' => 'No tienes permiso para eliminar datos.']);
    exit;
}

// Lista de tablas a limpiar
$tables = ['archivos', 'autos', 'caja', 'clientes', 'efectivo', 'pagos', 'rentas']; // Modifica según tus tablas

foreach ($tables as $table) {
    $query = "TRUNCATE TABLE " . $table;
    $result = $pdo->exec($query);
    if ($result === false) {
        echo json_encode(['status' => 'error', 'message' => 'Error al limpiar la tabla ' . $table]);
        exit;
    }
}

echo json_encode(['status' => 'success', 'message' => 'Tablas limpiadas con éxito']);
?>
