$(document).ready(function() {
    function loadTable(page = 1) {
        $.ajax({
            url: 'crud_efectivo.php',
            type: 'POST',
            data: { page: page }, // Enviar el número de página actual
            success: function(response) {
                $('#efectivoTableBody').html($(response).find('#efectivoTableBody').html());
            }
        });
    }

    // Filtrar por fechas, tipo y búsqueda general
$('#filterBtn').on('click', function() {
    var startDate = $('#startDate').val();
    var endDate = $('#endDate').val();
    var search = $('#searchInput').val();  // Obtener el valor de búsqueda
    var type = $('#type').val();  // Obtener el valor del tipo seleccionado

    $.ajax({
        url: 'search_efectivo.php',
        type: 'POST',
        data: { 
            startDate: startDate,
            endDate: endDate,
            search: search,  // Incluir el valor de búsqueda
            type: type  // Incluir el tipo
        },
        success: function(response) {
            $('#efectivoTableBody').html(response);
        }
    });
});

    $('#addForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: 'add_efectivo.php',
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response === 'success') {
                    showMessage('alert-success', 'Registro agregado exitosamente.');
                    $('#addModal').modal('hide');
                    $('#addForm')[0].reset();
                    loadTable(); // Actualizar la tabla
                } else {
                    showMessage('alert-danger', 'Error al agregar el registro.');
                }
            }
        });
    });


    $(document).on('click', '.edit-btn', function() {
        var id = $(this).data('id');
        $.ajax({
            url: 'get_efectivo.php',
            type: 'POST',
            data: { id_efectivo: id },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    var data = response.data;
                    $('#editId').val(data.id_efectivo);
                    $('#editTipo').val(data.tipo);
                    $('#editMonto').val(data.monto);
                    $('#editMotivo').val(data.motivo); // Cambié 'monto' a 'motivo'
                    $('#editModal').modal('show');
                } else {
                    showMessage('alert-danger', 'Error al obtener datos.');
                }
            }
        });
    });

    $('#editForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: 'edit_efectivo.php',
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response === 'success') {
                    showMessage('alert-success', 'Registro actualizado exitosamente.');
                    $('#editModal').modal('hide');
                    loadTable(); // Actualizar la tabla
                } else {
                    showMessage('alert-danger', 'Error al actualizar el registro.');
                }
            }
        });
    });

    $(document).on('click', '.delete-btn', function() {
        var id = $(this).data('id');
        var confirmation = confirm('¿Estás seguro de que deseas eliminar este registro?');

        if (confirmation) {
            $.ajax({
                url: 'delete_efectivo.php',
                type: 'POST',
                data: { id_efectivo: id },
                success: function(response) {
                    if (response === 'success') {
                        showMessage('alert-success', 'Registro eliminado exitosamente.');
                        loadTable(); // Actualizar la tabla
                    } else {
                        showMessage('alert-danger', 'Error al eliminar el registro.');
                    }
                }
            });
        }
    });

    $(document).on('click', '.page-link', function(e) {
        e.preventDefault();
        var page = $(this).data('page');
        loadTable(page); // Actualizar la tabla con la página seleccionada
    });

    function showMessage(type, text) {
        var message = $('#message');
        message.removeClass('d-none').removeClass('alert-success').removeClass('alert-danger');
        message.addClass(type).text(text);

        setTimeout(function() {
            message.addClass('d-none');
        }, 5000);
    }
});
