$(document).ready(function() {
    function cargarHistorial(fecha_inicio, fecha_final) {
        console.log('Cargando historial con fechas:', fecha_inicio, fecha_final);
        $.ajax({
            url: 'historial.php',
            type: 'GET',
            dataType: 'json',
            data: {
                action: 'get_rentals',
                id_cliente: id_cliente,
                fecha_inicio: fecha_inicio,
                fecha_final: fecha_final
            },
            success: function(data) {
                console.log('Datos recibidos:', data);
                let html = '<table class="table table-bordered table-striped">';
                html += '<thead class="thead-dark"><tr><th>ID Renta</th><th>Habitación</th><th>Fecha/heck-in</th><th>Fecha/check-out</th><th>Estadía</th><th>Precio Total</th><th>Usuario</th></tr></thead><tbody>';
                
                if (data.error) {
                    html += '<tr><td colspan="7">' + data.error + '</td></tr>';
                } else {
                    data.rentas.forEach(function(renta) {
                        html += '<tr>';
                        html += '<td>' + renta.id_renta + '</td>';
                        html += '<td>' + renta.nombre_habitacion + ' ' + renta.numero_habitacion + ' ' + renta.tipo + '</td>';
                        html += '<td>' + renta.fecha_renta + '</td>';
                        html += '<td>' + renta.fecha_devolucion + '</td>';
                        html += '<td>' + renta.dias + '</td>'; // Mostrar los días calculados
                        html += '<td>' + renta.precio_total + '</td>';
                        html += '<td>' + renta.nombre_usuario + '</td>';
                        html += '</tr>';
                    });

                    // Agregar fila con total
                    html += '<tfoot><tr><td colspan="5" class="text-right"><strong>Total:</strong></td><td><strong>' + data.total_precio + '</strong></td><td></td></tr></tfoot>';
                }
                
                html += '</tbody></table>';
                $('#archivos-lista').html(html);
            },
            error: function(xhr, status, error) {
                console.error('Error al cargar los datos:', error);
                $('#archivos-lista').html('<p>Error al cargar los datos.</p>');
            }
        });
    }

    // Cargar el historial al cargar la página
    cargarHistorial('', '');

    // Filtrar el historial de rentas
    $('#filtrar').click(function() {
        const fecha_inicio = $('#fecha_inicio').val();
        const fecha_final = $('#fecha_final').val();
        cargarHistorial(fecha_inicio, fecha_final);
    });
});
