<?php
session_start();
require '../config.php';
require '../functions.php';

// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_rentas'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_rentas'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_rentas'),
];

if (!isset($_POST['fecha_devolucion']) || empty($_POST['fecha_devolucion'])) {
    echo '<tr><td colspan="11">Seleccione una fecha de devolución.</td></tr>';
    exit;
}

$fechaDevolucion = $_POST['fecha_devolucion'];

$sql = "
SELECT rentas.id_renta, clientes.nombre AS nombre_cliente, clientes.apellido AS apellido_cliente, clientes.telefono AS telefono_cliente,
       CONCAT(autos.marca, ' ', autos.modelo, ' ', autos.anio) AS auto, usuarios.nombre_usuario, 
       rentas.fecha_renta, rentas.fecha_devolucion, rentas.precio_total, rentas.estado, rentas.pago,
       DATEDIFF(rentas.fecha_devolucion, rentas.fecha_renta) AS dias_renta
FROM rentas
JOIN clientes ON rentas.id_cliente = clientes.id_cliente
JOIN autos ON rentas.id_auto = autos.id_auto
JOIN usuarios ON rentas.id_usuario = usuarios.id_usuario
WHERE rentas.fecha_devolucion = :fecha_devolucion
ORDER BY rentas.id_renta DESC";

$stmt = $pdo->prepare($sql);
$stmt->bindValue(':fecha_devolucion', $fechaDevolucion);
$stmt->execute();
$rentas = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($rentas)) {
    echo '<tr><td colspan="11">No se encontraron rentas para la fecha seleccionada.</td></tr>';
    exit;
}
// Obtén la información de la empresa
$sqlEmpresa = "SELECT nombre, estado, ciudad, direccion, telefono, email FROM empresa LIMIT 1";
$stmtEmpresa = $pdo->prepare($sqlEmpresa);
$stmtEmpresa->execute();
$empresa = $stmtEmpresa->fetch(PDO::FETCH_ASSOC);
foreach ($rentas as $renta) {
    // Obtener el teléfono del cliente
    $telefonoCliente = htmlspecialchars($renta['telefono_cliente']); // Asegúrate de que 'telefono_cliente' esté en la consulta SQL
    
    // Construir mensaje de WhatsApp con emojis
    $mensaje = "🌟 **Hola " . htmlspecialchars($renta['nombre_cliente']) . " " . htmlspecialchars($renta['apellido_cliente']) . ",**\n";
    $mensaje .= "🚗 Le recordamos que debe entregar el vehículo **" . htmlspecialchars($renta['auto']) . "** el día **" . formatearFecha($renta['fecha_devolucion']) . "**.\n\n";
    $mensaje .= "🏢 **Información de la empresa:**\n";
    $mensaje .= "📛 **Nombre:** " . htmlspecialchars($empresa['nombre']) . "\n";
    $mensaje .= "🌍 **Estado:** " . htmlspecialchars($empresa['estado']) . "\n";
    $mensaje .= "🌆 **Ciudad:** " . htmlspecialchars($empresa['ciudad']) . "\n";
    $mensaje .= "🏠 **Dirección:** " . htmlspecialchars($empresa['direccion']) . "\n";
    $mensaje .= "📞 **Teléfono:** " . htmlspecialchars($empresa['telefono']) . "\n";
    $mensaje .= "📧 **Email:** " . htmlspecialchars($empresa['email']) . "\n";
    
    // Codificar el mensaje para usarlo en la URL
    $mensajeWhatsApp = urlencode($mensaje);
    
    // Limpiar el número de teléfono
    $telefonoCliente = preg_replace('/[^0-9]/', '', $telefonoCliente);

    echo '<tr>';
    echo '<td>' . htmlspecialchars($renta['id_renta']) . '</td>';
    echo '<td>' . htmlspecialchars($renta['nombre_cliente'] . ' ' . $renta['apellido_cliente']) . '</td>';
    echo '<td>' . htmlspecialchars($renta['auto']) . '</td>';
    echo '<td>' . htmlspecialchars(formatearFecha($renta['fecha_renta'])) . '</td>';
    echo '<td>' . htmlspecialchars(formatearFecha($renta['fecha_devolucion'])) . '</td>';
    echo '<td><span class="badge badge-primary">' . htmlspecialchars($renta['dias_renta']) . '</span></td>';
    echo '<td>' . htmlspecialchars(formatMonto($moneda, $renta['precio_total'])) . '</td>';
    echo '<td>' . htmlspecialchars($renta['estado']) . '</td>';
    echo '<td><span class="badge ' . ($renta['pago'] === 'Pendiente' ? 'badge-danger' : 'badge-success') . '">' . htmlspecialchars($renta['pago']) . '</span></td>';
    echo '<td>' . htmlspecialchars($renta['nombre_usuario']) . '</td>';
    echo '<td>
    <div class="btn-group" role="group">';
        if ($permisos['editar']) {
            echo '<button class="btn btn-warning btn-sm edit-btn" data-id="' . htmlspecialchars($renta['id_renta']) . '" data-toggle="modal" data-target="#editModal" title="Editar renta" data-toggle="tooltip">
                    <i class="fas fa-edit"></i>
                </button>';
        }

        if ($permisos['eliminar']) {
            echo '<button class="btn btn-danger btn-sm delete-btn" data-id="' . htmlspecialchars($renta['id_renta']) . '" title="Eliminar renta" data-toggle="tooltip">
                    <i class="fas fa-trash-alt"></i>
                </button>';
        }

        if ($permisos['ver']) {
            echo '<button class="btn btn-info btn-sm print-btn" onclick="window.open(\'../reportes/print_contract.php?id_renta=' . htmlspecialchars($renta['id_renta']) . '\', \'_blank\')" title="Imprimir contrato" data-toggle="tooltip">
                    <i class="fas fa-print"></i>
                </button>';
        }

        if ($permisos['editar']) {
            echo '<button class="btn btn-primary btn-sm details-btn" data-id="' . htmlspecialchars($renta['id_renta']) . '" data-toggle="modal" data-target="#detailsModal" title="Ver detalles" data-toggle="tooltip">
                    <i class="fas fa-info-circle"></i>
                </button>';

            // Botón de WhatsApp - Abre directamente el chat con el cliente
            if (!empty($telefonoCliente)) {
                echo '<a href="https://wa.me/' . $telefonoCliente . '?text=' . $mensajeWhatsApp . '" target="_blank" class="btn btn-success btn-sm" title="Enviar recordatorio por WhatsApp" data-toggle="tooltip">
                        <i class="fab fa-whatsapp"></i>
                    </a>';
            }
        }


        echo '  </div>
            </td>';
    echo '</tr>';
}
?>
