<?php
require '../config.php';

$id_renta = isset($_POST['id_renta']) ? (int)$_POST['id_renta'] : 0;

$sql = "SELECT * FROM rentas WHERE id_renta = :id_renta";
$stmt = $pdo->prepare($sql);
$stmt->execute(['id_renta' => $id_renta]);
$renta = $stmt->fetch(PDO::FETCH_ASSOC);

if ($renta) {
    // Formatear las fechas para mostrar solo hasta los minutos
    if (!empty($renta['fecha_renta'])) {
        $renta['fecha_renta'] = date('Y-m-d H:i', strtotime($renta['fecha_renta']));
    }
    if (!empty($renta['fecha_devolucion'])) {
        $renta['fecha_devolucion'] = date('Y-m-d H:i', strtotime($renta['fecha_devolucion']));
    }

    echo json_encode(['status' => 'success', 'data' => $renta]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No se encontró la renta.']);
}
