<?php
require '../config.php';
require '../functions.php';

// Obtiene el término de búsqueda
$search = $_POST['search'] ?? '';
$search = "%$search%";

// Consulta para buscar autos
$sql = "SELECT id_habitacion, nombre_habitacion, numero_habitacion, tipo, precio_diario, disponible FROM habitaciones WHERE CONCAT(nombre_habitacion, ' ', numero_habitacion , ' ',precio_diario, ' ',disponible) LIKE :search";
$stmt = $pdo->prepare($sql);
$stmt->bindValue(':search', $search);
$stmt->execute();

$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Genera y muestra los resultados
foreach ($results as $result) {
    echo '<div data-id="' . htmlspecialchars($result['id_habitacion']) . '">' .
    htmlspecialchars($result['nombre_habitacion']) . ' ' .
    htmlspecialchars($result['numero_habitacion']) . ' ' .
    htmlspecialchars($result['tipo']) . ' ' .
    htmlspecialchars('(Precio ' . formatMonto($moneda, $result['precio_diario'])) . ') ' .
    '<span style="color:' . 
    ($result['disponible'] === 'disponible' ? 'green' : 'red') . ';">' .
    htmlspecialchars($result['disponible'] === 'disponible' ? 'Disponible' : 'Ocupada') .
    '</span>' .
    '</div>';
}
?>
