<?php
require '../config.php';

// Obtiene el término de búsqueda
$search = $_POST['search'] ?? '';
$search = "%$search%";

// Consulta para buscar clientes
$sql = "SELECT id_cliente, nombre, apellido FROM clientes WHERE CONCAT(nombre, ' ', apellido) LIKE :search";
$stmt = $pdo->prepare($sql);
$stmt->bindValue(':search', $search);
$stmt->execute();

$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Genera y muestra los resultados
foreach ($results as $result) {
    echo '<div data-id="' . htmlspecialchars($result['id_cliente']) . '">' .
         htmlspecialchars($result['nombre']) . ' ' .
         htmlspecialchars($result['apellido']) . '</div>';
}
?>
