<?php
require('fpdf/fpdf.php');
require '../config.php';
require '../functions.php';

// Obtener datos de la empresa
$sql = "SELECT * FROM empresa WHERE id_empresa = 1";
$stmt = $pdo->query($sql);
$empresa = $stmt->fetch(PDO::FETCH_ASSOC);

// Obtener datos de la tabla 'caja' con filtros
$fechaInicio = isset($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : '1900-01-01';
$fechaFin = isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : '2100-12-31';
$tipo = isset($_GET['tipo']) ? $_GET['tipo'] : '';

// Consulta SQL
$sql = "SELECT e.*, u.nombre AS nombre_usuario, u.apellido AS apellido_usuario 
        FROM caja e
        JOIN usuarios u ON e.usuario_id = u.id_usuario
        WHERE e.fecha BETWEEN :fecha_inicio AND :fecha_fin";

if ($tipo) {
    $sql .= " AND e.tipo = :tipo";
}

$sql .= " ORDER BY e.fecha";

// Preparar y ejecutar la consulta
$stmt = $pdo->prepare($sql);
$stmt->bindValue(':fecha_inicio', $fechaInicio, PDO::PARAM_STR);
$stmt->bindValue(':fecha_fin', $fechaFin, PDO::PARAM_STR);

if ($tipo) {
    $stmt->bindValue(':tipo', $tipo, PDO::PARAM_STR);
}

$stmt->execute();
$cajas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Crear instancia de FPDF
$pdf = new FPDF('P', 'mm', 'A4');  // L para orientación horizontal
$pdf->AddPage();

// Encabezado
$pdf->SetFont('Arial', 'B', 10);  // Fuente más pequeña para el encabezado
$pdf->SetXY(10, 10);  // Ajustar posición del encabezado
$pdf->Image('../img/' . htmlspecialchars($empresa['logo']), 10, 10, 30);  // Ajustar tamaño y posición del logo

// Datos de la empresa
$pdf->SetFont('Arial', 'B', 12);  // Nombre de la empresa en fuente más grande
$pdf->SetX(50);  // Posicionar el cursor a la derecha del logo
$pdf->Cell(0, 10, utf8_decode($empresa['nombre']), 0, 1, 'C');
$pdf->SetFont('Arial', '', 10);  // Fuente normal para el resto de los datos
$pdf->Cell(0, 10, utf8_decode($empresa['estado'] . ', ' . $empresa['ciudad'] . ', ' . $empresa['direccion']), 0, 1, 'C');
$pdf->Cell(0, 10, utf8_decode('Teléfono: ' . $empresa['telefono'] . ' | Email: ' . $empresa['email']), 0, 1, 'C');
$pdf->Ln(10);

// Línea gris antes del título
$pdf->SetDrawColor(169, 169, 169); // Color gris
$pdf->Line(20, 50, 270, 50); // Coordenadas para la línea horizontal en orientación horizontal
$pdf->Ln(10); // Espacio debajo de la línea

// Título del informe
$pdf->SetFont('Arial', 'B', 14);  // Fuente más grande para el título
$pdf->Cell(0, 10, utf8_decode('Informe de Caja'), 0, 1, 'C');
$pdf->Ln(5);  // Espacio debajo del título

// Encabezado de la tabla
$pdf->SetFont('Arial', 'B', 10);
$pdf->SetFillColor(169, 169, 169);  // Color de fondo gris para los encabezados
$pdf->Cell(20, 10, utf8_decode('ID'), 1, 0, 'C', true);
$pdf->Cell(30, 10, utf8_decode('Fecha'), 1, 0, 'C', true);
$pdf->Cell(30, 10, utf8_decode('Tipo'), 1, 0, 'C', true);
$pdf->Cell(30, 10, utf8_decode('Monto'), 1, 0, 'C', true);
$pdf->Cell(60, 10, utf8_decode('Usuario'), 1, 1, 'C', true);  // Añadir 1 al final para nueva línea

// Datos de la tabla
$pdf->SetFont('Arial', '', 10);
$pdf->SetFillColor(255, 255, 255);  // Color de fondo blanco para las filas de datos
$totalMonto = 0;
foreach ($cajas as $caja) {
    $pdf->Cell(20, 10, utf8_decode($caja['id_caja']), 1);
    $pdf->Cell(30, 10, utf8_decode(date('Y-m-d', strtotime($caja['fecha']))), 1);
    $pdf->Cell(30, 10, utf8_decode($caja['tipo']), 1);
    $pdf->Cell(30, 10, formatMonto($empresa['moneda'], $caja['monto']), 1, 0, 'C', true);
    $pdf->Cell(60, 10, utf8_decode($caja['nombre_usuario'] . ' ' . $caja['apellido_usuario']), 1);  // Usuario
    $pdf->Ln();
    $totalMonto += $caja['monto'];
}

// Total de la columna Monto
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(80, 10, utf8_decode('Total'), 1);
$pdf->Cell(30, 10, utf8_decode(formatMonto($moneda, $totalMonto)), 1);

// Output del PDF
$pdf->Output();
?>
