<?php
session_start();
require('fpdf/fpdf.php');
require '../config.php'; // Asegúrate de que este archivo configure la conexión PDO
require '../functions.php'; // Incluye el archivo que contiene la función formatearFecha

// Verificar si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    die('Usuario no autenticado');
}

// Obtener datos de la empresa
$sql = "SELECT * FROM empresa WHERE id_empresa = 1";
$stmt = $pdo->query($sql);
$empresa = $stmt->fetch(PDO::FETCH_ASSOC);

// Verificar que se ha recibido el parámetro id_cliente
if (!isset($_GET['id_cliente']) || !filter_var($_GET['id_cliente'], FILTER_VALIDATE_INT)) {
    die('ID de cliente no válido');
}

$id_cliente = (int)$_GET['id_cliente'];

// Obtener el nombre completo del cliente
$sqlCliente = "SELECT CONCAT(nombre, ' ', apellido) AS nombre_completo FROM clientes WHERE id_cliente = :id_cliente";
$stmtCliente = $pdo->prepare($sqlCliente);
$stmtCliente->bindParam(':id_cliente', $id_cliente, PDO::PARAM_INT);
$stmtCliente->execute();
$cliente = $stmtCliente->fetch(PDO::FETCH_ASSOC);

if (!$cliente) {
    die('Cliente no encontrado');
}

$nombreCliente = $cliente['nombre_completo'];

// Establecer las fechas de inicio y final
$fecha_inicio = isset($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : '';
$fecha_final = isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : '';

// Preparar la consulta SQL para las rentas
$sql = "
    SELECT DISTINCT r.id_renta, r.fecha_renta, r.fecha_devolucion, r.precio_total,
           a.nombre_habitacion, a.numero_habitacion, a.tipo,
           u.nombre_usuario
    FROM rentas r
    INNER JOIN habitaciones a ON r.id_auto = a.id_habitacion
    INNER JOIN usuarios u ON r.id_usuario = u.id_usuario
    WHERE r.id_cliente = :id_cliente
";

// Agregar filtros de fecha si están presentes
if ($fecha_inicio && $fecha_final) {
    $sql .= " AND r.fecha_renta BETWEEN :fecha_inicio AND :fecha_final";
}

// Ordenar por fecha de renta
$sql .= " ORDER BY r.fecha_renta DESC";

// Preparar la consulta
try {
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id_cliente', $id_cliente, PDO::PARAM_INT);

    // Enlazar las fechas si están presentes
    if ($fecha_inicio && $fecha_final) {
        $stmt->bindParam(':fecha_inicio', $fecha_inicio);
        $stmt->bindParam(':fecha_final', $fecha_final);
    }

    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Crear instancia de FPDF
    $pdf = new FPDF('L', 'mm', 'A4');  // L para orientación horizontal
    $pdf->AddPage();

    // Encabezado
    $pdf->SetFont('Arial', 'B', 10);  // Fuente más pequeña para el encabezado
    $pdf->SetXY(10, 10);  // Ajustar posición del encabezado
    $pdf->Image('../img/' . htmlspecialchars($empresa['logo']), 10, 10, 30);  // Ajustar tamaño y posición del logo

    // Datos de la empresa
    $pdf->SetFont('Arial', 'B', 12);  // Nombre de la empresa en fuente más grande
    $pdf->SetX(50);  // Posicionar el cursor a la derecha del logo
    $pdf->Cell(0, 10, utf8_decode($empresa['nombre']), 0, 1, 'C');
    $pdf->SetFont('Arial', '', 10);  // Fuente normal para el resto de los datos
    $pdf->Cell(0, 10, utf8_decode($empresa['estado'] . ', ' . $empresa['ciudad'] . ', ' . $empresa['direccion']), 0, 1, 'C');
    $pdf->Cell(0, 10, utf8_decode('Teléfono: ' . $empresa['telefono'] . ' | Email: ' . $empresa['email']), 0, 1, 'C');
    $pdf->Ln(10);

    // Línea gris antes del título
    $pdf->SetDrawColor(169, 169, 169); // Color gris
    $pdf->Line(20, 50, 270, 50); // Coordenadas para la línea horizontal en orientación horizontal
    $pdf->Ln(10); // Espacio debajo de la línea

    // Título del informe y nombre del cliente
    $pdf->SetFont('Arial', 'B', 14);  // Fuente más grande para el título
    $pdf->Cell(0, 10, utf8_decode('Informe de de Estadías'), 0, 1, 'C');
    $pdf->SetFont('Arial', 'B', 12);  // Fuente más pequeña para el nombre del cliente
    $pdf->SetX(10);  // Posicionar a la izquierda
    $pdf->Cell(0, 10, utf8_decode('Cliente: ' . $nombreCliente), 0, 1, 'L');  // Mostrar el nombre del cliente a la izquierda
    $pdf->Ln(5);  // Espacio debajo del nombre del cliente

    // Encabezado de la tabla
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetFillColor(169, 169, 169);  // Color de fondo gris para los encabezados
    $pdf->Cell(10, 10, utf8_decode('ID'), 1, 0, 'C', true);
    $pdf->Cell(60, 10, utf8_decode('Habitación'), 1, 0, 'C', true);
    $pdf->Cell(30, 10, utf8_decode('Tipo'), 1, 0, 'C', true);
    $pdf->Cell(40, 10, utf8_decode('Fecha/heck-in'), 1, 0, 'C', true);
    $pdf->Cell(40, 10, utf8_decode('Fecha/check-out'), 1, 0, 'C', true);
    $pdf->Cell(15, 10, utf8_decode('Estadía'), 1, 0, 'C', true);  // Nueva columna para los días
    $pdf->Cell(30, 10, utf8_decode('Precio Total'), 1, 0, 'C', true);
    $pdf->Cell(30, 10, utf8_decode('Usuario'), 1, 1, 'C', true);  // Añadir 1 al final para nueva línea

    // Datos de la tabla
    $pdf->SetFont('Arial', '', 10);
    $pdf->SetFillColor(255, 255, 255);  // Color de fondo blanco para las filas de datos
    $totalPrecio = 0;
    foreach ($result as $renta) {
        // Calcular la diferencia en días entre fecha_renta y fecha_devolucion
        $fechaRenta = new DateTime($renta['fecha_renta']);
        $fechaDevolucion = new DateTime($renta['fecha_devolucion']);
        $diferenciaDias = $fechaRenta->diff($fechaDevolucion)->days;
        $pdf->Cell(10, 10, utf8_decode($renta['id_renta']), 1);
        $pdf->Cell(60, 10, utf8_decode($renta['nombre_habitacion'] . ' ' . $renta['numero_habitacion']), 1);
        $pdf->Cell(30, 10, utf8_decode($renta['tipo']), 1);
        $pdf->Cell(40, 10, utf8_decode(formatearFecha($renta['fecha_renta'])), 1);
        $pdf->Cell(40, 10, utf8_decode(formatearFecha($renta['fecha_devolucion'])), 1);
        $pdf->Cell(15, 10, utf8_decode($diferenciaDias), 1);  // Mostrar los días calculados
        $pdf->Cell(30, 10, utf8_decode($empresa['moneda'] . ' ' . number_format($renta['precio_total'], 2)), 1);
        $pdf->Cell(30, 10, utf8_decode($renta['nombre_usuario']), 1);
        $pdf->Ln();
        $totalPrecio += $renta['precio_total'];
    }

    // Total de la columna Precio Total
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(195, 10, utf8_decode('Total'), 1);
    $pdf->Cell(30, 10, utf8_decode($empresa['moneda'] . ' ' . number_format($totalPrecio, 2)), 1, 1, 'C');

    $pdf->Output('I', 'reporte_rentas_cliente.pdf');
} catch (PDOException $e) {
    echo 'Error: ' . $e->getMessage();
}
?>
