<?php
require('fpdf/fpdf.php');
require '../config.php';

// Obtener datos de la empresa
$sql = "SELECT * FROM empresa LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$empresa = $stmt->fetch(PDO::FETCH_ASSOC);

// Obtener ID de la renta desde la solicitud GET
$idRenta = isset($_GET['id_renta']) ? (int)$_GET['id_renta'] : 0;

if ($idRenta > 0) {
    // Obtener datos de la renta
    $sql = "
SELECT rentas.id_renta, clientes.nombre AS nombre_cliente, clientes.apellido AS apellido_cliente, clientes.direccion AS direccion_cliente,
       autos.marca, autos.modelo, autos.anio, autos.color, autos.placa, autos.tipo, autos.precio_diario, autos.bastidor, autos.combustible, autos.detalles,
       rentas.fecha_renta, rentas.fecha_devolucion, rentas.precio_total
FROM rentas
JOIN clientes ON rentas.id_cliente = clientes.id_cliente
JOIN autos ON rentas.id_auto = autos.id_auto
WHERE rentas.id_renta = :id_renta";
    
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':id_renta', $idRenta, PDO::PARAM_INT);
    $stmt->execute();
    
    $renta = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($renta) {
        // Crear PDF
        $pdf = new FPDF();
        $pdf->AddPage();
        
        // Configuración de fuentes y márgenes
        $pdf->SetMargins(20, 20, 20);
        
        // Encabezado
        $pdf->SetFont('Arial', 'B', 10);  // Fuente más pequeña para el encabezado
        $pdf->SetXY(10, 10);  // Ajustar posición del encabezado
        $pdf->Image('../img/' . htmlspecialchars($empresa['logo']), 10, 10, 30);  // Ajustar tamaño y posición del logo
        
        // Datos de la empresa
        $pdf->SetFont('Arial', 'B', 12);  // Nombre de la empresa en fuente más grande
        $pdf->SetX(50);  // Posicionar el cursor a la derecha del logo
        $pdf->Cell(0, 10, utf8_decode($empresa['nombre']), 0, 1, 'C');
        $pdf->SetFont('Arial', '', 10);  // Fuente normal para el resto de los datos
        $pdf->Cell(0, 10, utf8_decode($empresa['estado'] . ', ' . $empresa['ciudad']. ', ' .$empresa['direccion']), 0, 1, 'C');
        //$pdf->Cell(0, 10, utf8_decode($empresa['direccion']), 0, 1, 'C');
        $pdf->Cell(0, 10, utf8_decode('Teléfono: ' . $empresa['telefono'] . ' | Email: ' . $empresa['email']), 0, 1, 'C');
        $pdf->Ln(10);

        // Línea gris antes del título
        $pdf->SetDrawColor(169, 169, 169); // Color gris
        $pdf->Line(20, 50, 190, 50); // Coordenadas para la línea
        $pdf->Ln(10); // Espacio debajo de la línea
        
        // Título del contrato
        $pdf->SetFont('Arial', 'B', 14);  // Fuente más grande para el título del contrato
        $pdf->Cell(0, 10, utf8_decode('Contrato de Arrendamiento de Vehículo'), 0, 1, 'C');
        $pdf->Ln(5);  // Reducir el espacio debajo del título del contrato
        
        // Datos del arrendador y arrendatario
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('CONSTAN POR EL PRESENTE CONTRATO DE ARRENDAMIENTO, que celebran entre el señor Juan Perez, en adelante, EL ARRENDADOR, y el señor ' . htmlspecialchars($renta['nombre_cliente'] . ' ' . $renta['apellido_cliente']) . ', con domicilio en '.htmlspecialchars($renta['direccion_cliente']).', en adelante, EL ARRENDATARIO.'), 0, 'J');
        $pdf->Ln(10);
        
        // Información del vehículo
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('PRIMERO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('EL ARRENDADOR se compromete a ceder en alquiler el siguiente vehículo:'), 0, 'J');
        $pdf->Ln(5);
        
        $pdf->SetFont('Arial', 'I', 10);  // Información del vehículo en cursiva y tamaño 10
        $pdf->Cell(0, 10, utf8_decode('Marca: ' . htmlspecialchars($renta['marca'])), 0, 1, 'L');
        $pdf->Cell(0, 10, utf8_decode('Modelo: ' . htmlspecialchars($renta['modelo'])), 0, 1, 'L');
        $pdf->Cell(0, 10, utf8_decode('Color: ' . htmlspecialchars($renta['color'])), 0, 1, 'L');
        $pdf->Cell(0, 10, utf8_decode('Placa de rodaje Nro.: ' . htmlspecialchars($renta['placa'])), 0, 1, 'L');
        $pdf->Cell(0, 10, utf8_decode('Año de fabricación: ' . htmlspecialchars($renta['anio'])), 0, 1, 'L');
        $pdf->Cell(0, 10, utf8_decode('Número de bastidor: ' . htmlspecialchars($renta['bastidor'])), 0, 1, 'L');
        $pdf->Cell(0, 10, utf8_decode('Tipo: ' . htmlspecialchars($renta['tipo'])), 0, 1, 'L');
        $pdf->Cell(0, 10, utf8_decode('Combustible: ' . htmlspecialchars($renta['combustible'])), 0, 1, 'L');
        $pdf->Cell(0, 10, utf8_decode('Detalles: ' . htmlspecialchars($renta['detalles'])), 0, 1, 'L');
        $pdf->Cell(0, 10, utf8_decode('Precio diario: $. ' . htmlspecialchars($renta['precio_diario'])), 0, 1, 'L');
        $pdf->Ln(5);
        
        // Otros términos del contrato
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('SEGUNDO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('LAS PARTES acuerdan que el monto de la Renta asumida por EL ARRENDATARIO en calidad de contraprestación por el uso del bien es de $. '. htmlspecialchars($renta['precio_total']).' y 00/100 dolares americanos.'), 0, 'J');
        $pdf->Ln(5);

        // Función para convertir la fecha a formato textual
        function fechaEnTexto($fecha) {
            $meses = [
                1 => 'enero', 2 => 'febrero', 3 => 'marzo', 4 => 'abril',
                5 => 'mayo', 6 => 'junio', 7 => 'julio', 8 => 'agosto',
                9 => 'septiembre', 10 => 'octubre', 11 => 'noviembre', 12 => 'diciembre'
            ];
            
            $fecha = date_create($fecha);
            $dia = date_format($fecha, 'j');
            $mes = $meses[date_format($fecha, 'n')];
            $anio = date_format($fecha, 'Y');
            
            return "$dia de $mes de $anio";
        }
        
        // Obtener las fechas en formato textual
        $fechaRentaTexto = fechaEnTexto($renta['fecha_renta']);
        $fechaDevolucionTexto = fechaEnTexto($renta['fecha_devolucion']);

        // Ajustar el contrato para mostrar las fechas en formato textual
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('TERCERO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('Este Acuerdo tendrá una duración determinada, la cual comenzará a partir de la suscripción del presente contrato hasta el día ' . $fechaDevolucionTexto . ', fecha en la que EL ARRENDATARIO devolverá el Vehículo. El período de alquiler se inicia el ' . $fechaRentaTexto . '.'), 0, 'J');
        $pdf->Ln(5);

        // Continuar con el resto del contrato...
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->Cell(0, 10, utf8_decode('CUARTO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);
        $pdf->MultiCell(0, 10, utf8_decode('EL ARRENDATARIO se compromete a devolver el vehículo en las mismas condiciones en que fue recibido, salvo el desgaste normal por el uso.'), 0, 'J');
        $pdf->Ln(5);

        $pdf->SetFont('Arial', 'B', 10);
        $pdf->Cell(0, 10, utf8_decode('QUINTO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);
        $pdf->MultiCell(0, 10, utf8_decode('Cualquier daño al vehículo durante el período de alquiler será responsabilidad del ARRENDATARIO.'), 0, 'J');
        $pdf->Ln(5);

        $pdf->SetFont('Arial', 'B', 10);
        $pdf->Cell(0, 10, utf8_decode('SEXTO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);
        $pdf->MultiCell(0, 10, utf8_decode('Ambas partes declaran que han leído y comprendido el presente contrato y aceptan sus términos y condiciones.'), 0, 'J');
        $pdf->Ln(10);
        
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('SEPTIMO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('EL ARRENDATARIO acepta que será el único conductor del Vehículo durante el período de alquiler, a menos que EL ARRENDADOR dé su consentimiento previo por escrito para que otros conductores utilicen el Vehículo.'), 0, 'J');
        $pdf->Ln(5);
        
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('OCTAVO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('EL ARRENDATARIO se compromete a devolver el Vehículo en la misma condición en que fue recibido, con excepción del desgaste normal por el uso.'), 0, 'J');
        $pdf->Ln(5);
        
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('NOVENO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('Durante el período de alquiler y mientras el Vehículo esté en posesión de EL ARRENDATARIO, este asumirá responsabilidad en forma única y excluyente frente a cualquier daño personal o a la propiedad pública o privada, así como a las faltas al reglamento de tránsito vigente en el país.'), 0, 'J');
        $pdf->Ln(5);
        
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('DECIMO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('El presente bien otorgado en arrendamiento no podrá ser cedido a terceros bajo ningún motivo, salvo que se cuente con autorización por escrito de EL ARRENDADOR.'), 0, 'J');
        $pdf->Ln(5);
        
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('DECIMO PRIMERO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('Este Acuerdo es legal y vinculante, cada una de LAS PARTES declara que tiene las facultades necesarias para celebrar este Acuerdo.'), 0, 'J');
        $pdf->Ln(5);
        
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('DECIMO SEGUNDO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('En el caso de una controversia que resulte en una acción legal, esta será resuelta mediante arbitraje de conformidad con los Reglamentos Arbitrales del Centro de Arbitraje de la Cámara de Comercio de Lima, a cuyas normas, administración y decisión se someten las partes en forma incondicional, declarando conocerlas y aceptarlas en su integridad.'), 0, 'J');
        $pdf->Ln(5);
        
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('DECIMO TERCERO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('A fin de validar comunicaciones y notificaciones relacionadas a la ejecución del presente contrato, LAS PARTES señalan como sus domicilios los indicados en la introducción de este documento.'), 0, 'J');
        $pdf->Ln(5);
        
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('DECIMO CUARTO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('En caso de que LAS PARTES deseen cambiar, agregar o modificar cualquier término de este contrato, deberán hacerlo por escrito para ser firmado por ambas partes.'), 0, 'J');
        $pdf->Ln(5);
        
        $pdf->SetFont('Arial', 'B', 10);  // Encabezados en tamaño 10
        $pdf->Cell(0, 10, utf8_decode('DECIMO QUINTO:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 10);  // Texto normal en tamaño 10
        $pdf->MultiCell(0, 10, utf8_decode('En lo no previsto por las partes en el presente contrato, ambas se someten a lo establecido por las normas del Código Civil y demás del sistema jurídico que resulten aplicables.'), 0, 'J');
        $pdf->Ln(10);
        
       // Firma
       $pdf->SetFont('Arial', '', 10);
       $pdf->MultiCell(0, 10, utf8_decode('En señal de conformidad las partes suscriben este documento en la ciudad de _________________, a los _____ días del mes de _________________ del ___________.'), 0, 'L');
       $pdf->Ln(20);
       
       // Firmas una al lado de la otra
       $pdf->SetFont('Arial', '', 10);
       $pdf->Cell(90, 10, utf8_decode('_______________________________'), 0, 0, 'L');
       $pdf->Cell(0, 10, utf8_decode('_______________________________'), 0, 1, 'L');
       $pdf->Cell(90, 10, utf8_decode('Firma del ARRENDADOR'), 0, 0, 'L');
       $pdf->Cell(0, 10, utf8_decode('Firma del ARRENDATARIO'), 0, 1, 'L');
        
        // Salida del PDF
        $pdf->Output();
    } else {
        echo utf8_decode('No se encontró la renta.');
    }
} else {
    echo utf8_decode('ID de renta inválido.');
}
?>
