<?php
session_start();
require '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $turno = $_POST['turno'] ?? null;
    $numero_ganador = $_POST['numero_ganador'] ?? null;
    $resultados = json_decode($_POST['resultados'], true);
    $usuario_id = $_SESSION['usuario_id'];

    if (!$turno || !$numero_ganador || empty($resultados)) {
        echo json_encode(['status' => 'error', 'message' => 'Datos incompletos.']);
        exit;
    }

    try {
        // Verificar si ya existe un sorteo para este turno en la fecha actual
        $stmtCheck = $pdo->prepare("SELECT COUNT(*) FROM historial_sorteos WHERE id_turno = ? AND DATE(fecha) = CURDATE()");
        $stmtCheck->execute([$turno]);
        $existe_sorteo = $stmtCheck->fetchColumn();

        if ($existe_sorteo > 0) {
            echo json_encode(['status' => 'error', 'message' => 'El sorteo para este turno ya ha sido registrado hoy.']);
            exit;
        }

        $pdo->beginTransaction();

        // Insertar el sorteo en la bitácora
        $stmt = $pdo->prepare("INSERT INTO historial_sorteos (id_turno, numero_ganador, usuario_id, fecha) VALUES (?, ?, ?, NOW())");
        $stmt->execute([$turno, $numero_ganador, $usuario_id]);
        $id_sorteo = $pdo->lastInsertId();

        // Preparar la consulta para insertar detalles
        $stmtDetalle = $pdo->prepare("INSERT INTO detalle_sorteos (id_sorteo, vendedor, cliente, numero, valor_apostado, ganancia, monto_pagar) VALUES (?, ?, ?, ?, ?, ?, ?)");

        foreach ($resultados as $venta) {
            // Verificar si la fila contiene "Totales" o si algún campo relevante está vacío
            if (
                isset($venta['vendedor']) && 
                (strtolower($venta['vendedor']) === 'totales' || strtolower($venta['vendedor']) === 'totales:') || 
                empty($venta['vendedor']) || 
                empty($venta['cliente']) || 
                empty($venta['numero'])
            ) {
                continue; // Omitir la fila de totales
            }

            $stmtDetalle->execute([
                $id_sorteo,
                $venta['vendedor'],
                $venta['cliente'],
                $venta['numero'],
                $venta['valor_apostado'],
                $venta['ganancia'],
                $venta['monto_pagar']
            ]);
        }

        $pdo->commit();
        echo json_encode(['status' => 'success', 'message' => 'Sorteo registrado con éxito.']);
    } catch (Exception $e) {
        $pdo->rollBack();
        echo json_encode(['status' => 'error', 'message' => 'Error al guardar los datos: ' . $e->getMessage()]);
    }
}
?>
