<?php
session_start();
require '../config.php';
require '../functions.php';

// Verificar si la caja está aperturada
if (!isCajaAperturada($pdo)) {
    header('Location: ../caja_no_aperturada.php');
    exit;
}

// Verifica si el usuario está autenticado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ../index.php');
    exit;
}

// Verifica si el usuario tiene permiso para acceder a la página
if (!usuarioTienePermiso($pdo, $_SESSION['usuario_id'], 'ver_usuarios')) {
    header('Location: ../sin_permiso.php');
    exit;
}

// Verifica los permisos del usuario para ver, editar y eliminar
$usuario_id = $_SESSION['usuario_id'];
$permisos = [
    'ver' => usuarioTienePermiso($pdo, $usuario_id, 'ver_usuarios'),
    'editar' => usuarioTienePermiso($pdo, $usuario_id, 'editar_usuarios'),
    'eliminar' => usuarioTienePermiso($pdo, $usuario_id, 'borrar_usuarios'),
];

// Función para obtener todos los usuarios
function getUsuarios($pdo, $search = '') {
    $sql = "SELECT * FROM usuarios WHERE nombre_usuario LIKE :search";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['search' => "%$search%"]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Buscar usuarios
$search = isset($_POST['search']) ? $_POST['search'] : '';
$usuarios = getUsuarios($pdo, $search);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Usuarios</title>
    <link rel="shortcut icon" href="../img/favi.ico">
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <style>
        .main-content {
            padding: 2rem;
        }

        .btn-primary {
            border-radius: 50px;
            font-size: 0.875rem;
        }

        .input-group {
            width: 100%;
            max-width: 500px;
        }

        .form-control {
            border-radius: 50px 0 0 50px;
            box-shadow: none;
        }

        .input-group-append .btn-secondary {
            border-radius: 0 50px 50px 0;
        }

        .btn-info {
            border-radius: 50px;
            font-size: 0.875rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        #message {
    position: fixed;
    top: 10px;
    right: 10px;
    width: 300px;
    z-index: 1050; /* Asegúrate de que esté encima de otros elementos */
}
        .modal-content {
            padding: 20px;
        }
    </style>
</head>
<body>
    <?php include '../menu.php'; ?>

    <div class="container mt-4">
        <div class="d-flex align-items-center justify-content-center p-3 my-3 text-white bg-info rounded shadow-sm">
    <div class="lh-1 text-center">
        <h2 class="mb-4 text-center">
            <i class="fas fa-users"></i> <!-- Icono de FontAwesome -->
            Administrar Usuarios
        </h2>
    </div>
</div>


            <div class="d-flex flex-wrap mb-3 align-items-center">
    <!-- Botón para agregar un nuevo usuario -->
    <div class="form-group mb-0 mr-3">
        <button class="btn btn-info" data-toggle="modal" data-target="#addModal">
             <i class="fas fa-user"></i> Agregar Usuario
        </button>
    </div>

    <!-- Contenedor para el mensaje cuando no se encuentran usuarios -->
    <div id="noResultsMessage" class="alert alert-warning d-none mb-0 mr-3" role="alert">
        No se encontró ningún usuario.
    </div>

    <!-- Cuadro de búsqueda con botón de búsqueda -->
    <div class="input-group" style="width: 400px;">
        <input type="text" class="form-control" id="searchInput" placeholder="Buscar Usuarios..." value="<?php echo htmlspecialchars($search); ?>">
        <div class="input-group-append">
            <button class="btn btn-secondary" type="button" id="searchButton">
                <i class="fas fa-search"></i>
            </button>
        </div>
    </div>
</div>


            <!-- Tabla de usuarios -->
            <table class="table table-bordered table-striped">
                <thead class="thead-dark">
                    <tr>
                        <th>Sorteo</th>
                        <th>Usuario</th>
                        <th>Nombres</th>
                        <th>Apellidos</th>
                        <th>Autorización</th>
                        <th>Venta</th>
                        <th>Comision</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="userTableBody">
                    <?php foreach ($usuarios as $usuario): ?>
                        <tr>
                        <td align="center">
                                <?php
                                // Verificar el valor de $usuario['rifa'] y mostrar el emoji correspondiente
                                if ($usuario['rifa'] == 80) {
                                    echo '🔵'; // Si es 80, mostrar el círculo azul
                                } elseif ($usuario['rifa'] == 70) {
                                    echo '🔴'; // Si es 70, mostrar el círculo rojo
                                } else {
                                    echo '-'; // Si no es 80 ni 70, mostrar un guion u otro valor por defecto
                                }
                                ?>
                            </td>
                            <td><?php echo htmlspecialchars($usuario['nombre_usuario']); ?></td>
                            <td><?php echo htmlspecialchars($usuario['nombre']); ?></td>
                            <td><?php echo htmlspecialchars($usuario['apellido']); ?></td>
                            <td><?php echo htmlspecialchars($usuario['rol']); ?></td>
                            <td><?php echo htmlspecialchars($usuario['rifa']); ?></td>
                            <td><?php echo htmlspecialchars($usuario['comision']); ?> %</td>
                            <td>
                            <?php if ($permisos['editar']) : ?>
                                <button class="btn btn-info btn-sm edit-btn" data-id="<?php echo $usuario['id_usuario']; ?>" data-toggle="modal" data-target="#editModal"><i class="fas fa-edit"></i></button>
                                <?php endif; ?>
                                <?php if ($permisos['eliminar']) : ?>
                                <button class="btn btn-danger btn-sm delete-btn" data-id="<?php echo $usuario['id_usuario']; ?>"><i class="fas fa-trash-alt"></i></button>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
      
<!-- Contenedor para mensajes -->
<div id="message" class="alert d-none"></div>

<!-- Modal de edición -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalLabel">Editar Usuario</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            <form id="editForm">
    <input type="hidden" name="id_usuario" id="editId">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <label for="editNombreUsuario">Nombre de Usuario</label>
                <input type="text" class="form-control" id="editNombreUsuario" name="nombre_usuario" required>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label for="editNombre">Nombre</label>
                <input type="text" class="form-control" id="editNombre" name="nombre" required>
            </div>
        </div>
    </div>
    <div class="row">
            <div class="col-md-6">
            <div class="form-group">
                <label for="editApellido">Apellido</label>
                <input type="text" class="form-control" id="editApellido" name="apellido" required>
            </div>
            </div>
            <div class="col-md-6">
            <div class="form-group">
                <label for="editEmail">Email</label>
                <input type="email" class="form-control" id="editEmail" name="email">
            </div>
            </div>
    </div>
    <div class="row">
                        <div class="col-md-6">
                                <div class="form-group">
                                    <label for="addRol">Autorización</label>
                                    <select class="form-control" id="editRol" name="rol" required>
                                        <option value="admin">Administrador</option>
                                        <option value="vendedor">Vendedor</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="addEstado">Estado</label>
                                    <select class="form-control" id="editEstado" name="estado" required>
                                        <option value="activo">Activo</option>
                                        <option value="inactivo">Inactivo</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                        <div class="col-md-6">
                                <div class="form-group">
                                    <label for="addComision">Comision %</label>
                                    <input type="number" class="form-control" id="editComision" name="comision" value="20" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="editRifa">Tipo de Rifa</label>
                                    <select class="form-control" id="editRifa" name="rifa" required>
                                        <option value="70">Venta 70</option>
                                        <option value="80">Venta 80</option>
                                    </select>
                                </div>
                            </div>
                    </div>
                        <div class="row">
                            <div class="col-md-12">
                            <p class="text-center text-warning font-weight-bold">Déjelo en blanco si no desea cambiar la contraseña.</p>
                            </div>
                        </div>
    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <label for="editContrasena">Contraseña</label>
                <input type="password" class="form-control" id="editContrasena" name="contrasena">
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label for="editContrasenaConfirm">Confirmar Contraseña</label>
                <input type="password" class="form-control" id="editContrasenaConfirm" name="contrasena_confirm">
            </div>
        </div>
    </div>
    
    <button type="submit" class="btn btn-primary mt-3">Guardar cambios</button>
</form>

            </div>
        </div>
    </div>
</div>


   <!-- Modal para agregar un nuevo usuario -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addModalLabel">Agregar Nuevo Usuario</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            <form id="addForm">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="addNombreUsuario">Nombre de Usuario</label>
                                <input type="text" class="form-control" id="addNombreUsuario" name="nombre_usuario" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="addNombre">Nombre</label>
                                <input type="text" class="form-control" id="addNombre" name="nombre" required>
                            </div>
                        </div>
                        
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="addApellido">Apellido</label>
                                <input type="text" class="form-control" id="addApellido" name="apellido" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="addEmail">Email</label>
                                <input type="email" class="form-control" id="addEmail" name="email" required>
                            </div>
                    </div>
                    </div>
                    <div class="row">
                            <div class="col-md-6">
                            <div class="form-group">
                                <label for="addContrasena">Contraseña</label>
                                <input type="password" class="form-control" id="addContrasena" name="contrasena" required>
                            </div>
                            </div>
                            <div class="col-md-6">
                            <div class="form-group">
                                <label for="addContrasenaConfirm">Confirmar Contraseña</label>
                                <input type="password" class="form-control" id="addContrasenaConfirm" name="contrasena_confirm" required>
                            </div>
                            </div>
                        </div>
                        
                    
                    <div class="row">
                        <div class="col-md-6">
                                <div class="form-group">
                                    <label for="addRol">Autorización</label>
                                    <select class="form-control" id="addRol" name="rol" required>
                                        <option value="admin">Administrador</option>
                                        <option value="vendedor">Vendedor</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="addEstado">Estado</label>
                                    <select class="form-control" id="addEstado" name="estado" required>
                                        <option value="activo">Activo</option>
                                        <option value="inactivo">Inactivo</option>
                                    </select>
                                </div>
                            </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                                <div class="form-group">
                                    <label for="addComision">Comision %</label>
                                    <input type="number" class="form-control" id="addComision" name="comision" value="20" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="addRifa">Tipo de Rifa</label>
                                    <select class="form-control" id="addRifa" name="rifa" required>
                                        <option value="70">Venta 70</option>
                                        <option value="80">Venta 80</option>
                                    </select>
                                </div>
                            </div>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">Agregar Usuario</button>
                </form>

            </div>
        </div>
    </div>
</div>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
    // Manejar la búsqueda en tiempo real
    $('#searchInput').on('keyup', function() {
        var search = $(this).val();
        $.ajax({
            url: 'search_usuarios.php',
            type: 'POST',
            data: { search: search },
            success: function(response) {
                $('#userTableBody').html(response);
            }
        });
    });

    // Manejar la edición de usuario
    $(document).on('click', '.edit-btn', function() {
        var id = $(this).data('id');
        $.ajax({
            url: 'get_usuario.php',
            type: 'POST',
            data: { id_usuario: id },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    var data = response.data;
                    $('#editId').val(data.id_usuario);
                    $('#editNombreUsuario').val(data.nombre_usuario);
                    $('#editNombre').val(data.nombre);
                    $('#editApellido').val(data.apellido);
                    $('#editEmail').val(data.email);
                    $('#editRol').val(data.rol);
                    $('#editComision').val(data.comision);
                    $('#editRifa').val(data.rifa);
                    $('#editEstado').val(data.estado);
                    $('#editModal').modal('show');
                } else {
                    showMessage('alert-danger', 'Error al obtener datos del usuario.');
                }
            }
        });
    });

    // Confirmar eliminación de usuario
    $(document).on('click', '.delete-btn', function() {
        var userId = $(this).data('id');
        var confirmation = confirm('¿Estás seguro de que deseas eliminar este usuario?');

        if (confirmation) {
            $.ajax({
                url: 'delete_usuario.php',
                type: 'POST',
                data: { id_usuario: userId },
                success: function(response) {
                    if (response === 'success') {
                        showMessage('alert-success', 'Usuario eliminado exitosamente.');
                        $('#searchInput').trigger('keyup'); // Refrescar la tabla
                    } else {
                        showMessage('alert-danger', 'Error al eliminar el usuario.');
                    }
                }
            });
        }
    });

    // Manejar el envío del formulario de edición
    $('#editForm').on('submit', function(e) {
        e.preventDefault();

        var contrasena = $('#editContrasena').val();
        var contrasenaConfirm = $('#editContrasenaConfirm').val();

        if (contrasena !== contrasenaConfirm && contrasena !== '') {
            showMessage('alert-danger', 'Las contraseñas no coinciden.');
            return;
        }

        $.ajax({
            url: 'update_usuario.php',
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response === 'success') {
                    showMessage('alert-success', 'Usuario actualizado exitosamente.');
                    $('#editModal').modal('hide');
                    $('#searchInput').trigger('keyup');
                } else {
                    showMessage('alert-danger', 'Error al actualizar el usuario.');
                }
            }
        });
    });

    // Manejar el envío del formulario para agregar un usuario
    $('#addForm').on('submit', function(e) {
        e.preventDefault();

        var contrasena = $('#addContrasena').val();
        var contrasenaConfirm = $('#addContrasenaConfirm').val();

        if (contrasena !== contrasenaConfirm) {
            showMessage('alert-danger', 'Las contraseñas no coinciden.');
            return;
        }

        $.ajax({
            url: 'add_usuario.php',
            type: 'POST',
            data: $(this).serialize(),
            success: function(response) {
                if (response === 'success') {
                    showMessage('alert-success', 'Usuario agregado exitosamente.');
                    $('#addModal').modal('hide');
                    $('#searchInput').trigger('keyup');
                } else {
                    showMessage('alert-danger', 'Error al agregar el usuario.');
                }
            }
        });
    });

    // Mostrar mensajes temporales
    function showMessage(type, text) {
        var message = $('#message');
        message.removeClass('d-none').removeClass('alert-success').removeClass('alert-danger');
        message.addClass(type).text(text);

        // Ocultar el mensaje después de 5 segundos
        setTimeout(function() {
            message.addClass('d-none');
        }, 5000); // Cambia el valor a 10000 para 10 segundos
    }
});

    </script>
</body>
</html>