<?php
session_start();
require '../config.php'; // Conexión a la base de datos
require '../functions.php';

$fifa = $_SESSION['rifa'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Filtrar y validar los datos de entrada
    $numero = filter_input(INPUT_POST, 'numero', FILTER_SANITIZE_STRING);
    $cliente = filter_input(INPUT_POST, 'cliente', FILTER_SANITIZE_STRING);
    $valor = filter_input(INPUT_POST, 'valor', FILTER_VALIDATE_FLOAT);
    $id_vendedor = $_SESSION['usuario_id'] ?? null;
    $id_turno = filter_input(INPUT_POST, 'id_turno', FILTER_VALIDATE_INT);
    $session_id = session_id(); // Identificar sesión

    // Verificar el valor de fifa y aplicar la función correspondiente
    if ($fifa == 70) {
        $ganancia = calcularGanancia($valor);
    } elseif ($fifa == 80) {
        $ganancia = calcularGanancia2($valor);
    } else {
        $ganancia = 0; // Caso por defecto
    }

    if (!isset($numero, $cliente, $valor, $id_vendedor, $id_turno)) {
        echo json_encode(["status" => "error", "message" => "Datos incompletos o inválidos."]);
        exit;
    }

    try {
        // Verificar el total actual de ventas para el número en este turno y vendedor
        $sql_check = "SELECT SUM(valor) AS total_valor 
                      FROM ventas 
                      WHERE numero = :numero 
                      AND id_turno = :id_turno 
                      AND id_vendedor = :id_vendedor";

        $stmt_check = $pdo->prepare($sql_check);
        $stmt_check->execute([
            ':numero' => $numero,
            ':id_turno' => $id_turno,
            ':id_vendedor' => $id_vendedor
        ]);

        $row = $stmt_check->fetch(PDO::FETCH_ASSOC);
        $total_valor = $row['total_valor'] ?? 0;

        // Calcular cuánto crédito queda disponible antes del límite
        $credito_disponible = 30 - $total_valor;
        
        // Calcular el exceso si supera el límite
        $exceso = ($total_valor + $valor) - 30;

        if ($exceso > 0) {
            echo json_encode([
                "status" => "error",
                "message" => "No se puede agregar. Límite de $30.00 superado para el número $numero en este turno. 
                Se ha excedido por $" . number_format($exceso, 2) . ". 
                Crédito disponible: $" . number_format($credito_disponible, 2),
                "credito_disponible" => number_format($credito_disponible, 2)
            ]);
            exit;
        }

        // Insertar en la tabla temporal (carrito)
        $sql = "INSERT INTO carrito (numero, cliente, valor, id_vendedor, id_turno, ganancia, session_id) 
                VALUES (:numero, :cliente, :valor, :id_vendedor, :id_turno, :ganancia, :session_id)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':numero' => $numero,
            ':cliente' => $cliente,
            ':valor' => $valor,
            ':id_vendedor' => $id_vendedor,
            ':id_turno' => $id_turno,
            ':ganancia' => $ganancia,
            ':session_id' => $session_id
        ]);

        echo json_encode(["status" => "success", "message" => "✅ Producto agregado al carrito."]);
    } catch (PDOException $e) {
        echo json_encode(["status" => "error", "message" => "❌ Error al agregar al carrito: " . $e->getMessage()]);
    }
}
?>
