$(document).ready(function () {
    $("#imprimirUltimaVenta").click(async function () {
        try {
            let datos = await obtenerUltimaVenta();
            if (!datos || datos.ventas.length === 0) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'No hay ventas registradas.',
                    showConfirmButton: true
                });
                return;
            }

            // Generar el ticket con todas las ventas recuperadas
            generarTicket(datos.ventas, datos.correlativo);
        } catch (error) {
            console.error("Error al obtener la última venta:", error);
            Swal.fire({
                icon: 'error',
                title: 'Error inesperado',
                text: 'No se pudo obtener la última venta.',
                showConfirmButton: true
            });
        }
    });
});

// Función para obtener todas las ventas con el mismo correlativo
async function obtenerUltimaVenta() {
    try {
        let response = await fetch('obtener_ultima_venta.php');
        let data = await response.json();
        return data.status === "success" ? data : null;
    } catch (error) {
        console.error("Error en la solicitud AJAX:", error);
        return null;
    }
}

// Función para generar e imprimir el ticket con todas las ventas del mismo correlativo
function generarTicket(ventas, correlativo) {
    let ticketHTML = `
        <html>
        <head>
            <title>Ticket de Venta</title>
            <style>
                body { 
                    font-family: 'Courier New', monospace; 
                    font-size: 12px;
                    text-align: center; 
                    margin: 0;
                    padding: 0;
                }
                .ticket {
                    width: 58mm;
                    padding: 5px;
                }
                h2 {
                    margin: 0;
                    font-size: 14px;
                    font-weight: bold;
                }
                p {
                    margin: 2px 0;
                    text-align: left;
                }
                .bold {
                    font-weight: bold;
                }
                .center {
                    text-align: center;
                }
                .dashed {
                    border-top: 1px dashed black;
                    margin: 5px 0;
                }
            </style>
        </head>
        <body>
            <div class="ticket">
                <h2 class="center">TICKET DE VENTA</h2>
                <p class="bold center">Correlativo: ${correlativo}</p>
                <div class="dashed"></div>`;

    // Mostrar todas las ventas con el mismo correlativo
    ventas.forEach(venta => {
        ticketHTML += `
                <p><span class="bold">ID Venta:</span> ${venta.id_venta}</p>
                <p><span class="bold">Turno:</span> ${venta.nombre_turno}</p>
                <p><span class="bold">Número:</span> ${venta.numero}</p>
                <p><span class="bold">Cliente:</span> ${venta.cliente}</p>
                <p><span class="bold">Valor:</span> $${parseFloat(venta.valor).toFixed(2)}</p>
                <p><span class="bold">Ganancia:</span> $${parseFloat(venta.ganancia).toFixed(2)}</p>
                <p><span class="bold">Fecha:</span> ${venta.fecha}</p>
                <p><span class="bold">Vendedor:</span> ${venta.nombre_vendedor}</p>
                <div class="dashed"></div>`;
    });

    ticketHTML += `
                <p class="center">¡Gracias por su compra!</p>
            </div>
            <script>
                window.print();
                setTimeout(() => window.close(), 500);
            </script>
        </body>
        </html>
    `;

    // Calcular centro de la pantalla para abrir tipo popup
    let ancho = 320;
    let alto = 600;
    let left = (screen.width/2) - (ancho/2);
    let top = (screen.height/2) - (alto/2);

    let ventanaImpresion = window.open(
        '',
        'popUpTicket',
        `width=${ancho},height=${alto},top=${top},left=${left},toolbar=no,scrollbars=no,resizable=no,menubar=no,status=no`
    );

    ventanaImpresion.document.write(ticketHTML);
    ventanaImpresion.document.close();
}

