$(document).ready(function() {
    cargarCarrito(); // Cargar datos al inicio

    // Agregar número al carrito
// Agregar número al carrito
$("#agregarCarrito").click(function() {
    let numero = $("#numero").val();
    let cliente = $("#cliente").val();
    let valor = parseFloat($("#valor").val()).toFixed(2); // Convertir a número y limitar a 2 decimales
    let id_turno = $("#id_turno").val();

    if (numero !== "" && cliente !== "" && valor > 0 && id_turno !== "") {
        $.post("agregar_carrito.php", { numero, cliente, valor, id_turno }, function(response) {
            let res = JSON.parse(response);

            if (res.status === "success") {
                cargarCarrito();
                $("#numero").val(""); // Limpiar input
                $("#valor").val(""); // Limpiar input
                Swal.fire({
                    icon: 'success',
                    title: '¡Éxito!',
                    text: 'Número agregado al carrito.',
                    timer: 2000,
                    showConfirmButton: false
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: res.message
                });

                // Si la respuesta contiene 'credito_disponible', actualizar el valor del campo #valor
                if (res.credito_disponible) {
                    // Establecer el crédito disponible en el campo de valor
                    $("#valor").val(res.credito_disponible);
                }
            }
        }).fail(function() {
            Swal.fire({
                icon: 'error',
                title: 'Error de conexión',
                text: 'No se pudo conectar con el servidor.'
            });
        });
    } else {
        Swal.fire({
            icon: 'warning',
            title: 'Campos incompletos',
            text: 'Complete todos los campos y asegúrese de ingresar un valor mayor a 0.'
        });
    }
});



    // Eliminar número del carrito
    $(document).on("click", ".eliminarCarrito", function() {
        let id = $(this).data("id");
        $.post("eliminar_carrito.php", { id }, function(response) {
            let res = JSON.parse(response);
            if (res.status === "success") {
                cargarCarrito();
            } else {
                alert("Error al eliminar");
            }
        });
    });

    // Función para cargar la tabla del carrito
    function cargarCarrito() {
        $.get("mostrar_carrito.php", function(data) {
            $("#tablaCarrito").html(data);
        });
    }

    function cargarVentas() {
        $.ajax({
            url: 'ventas.php',
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status === "error") {
                    alert(response.message); // Mostrar mensaje de error
                    return;
                }
    
                let tabla = '';
                let totalVentas = 0;
                let totalComision = 0;
    
                // Verificar si hay ventas
                if (response.ventas.length === 0) {
                    $("#tablaVentas tbody").html('<tr><td colspan="6" class="text-center">No hay registro de ventas para el sorteo</td></tr>');
                    $("#totalVentas").text("$0.00");
                    $("#comision").text("$0.00");
                    $("#entregar").text("$0.00");
                    return;
                }
    
                // Construir la tabla con las ventas
                response.ventas.forEach(venta => {
                    totalVentas += parseFloat(venta.valor);
                    totalComision += parseFloat(venta.comision); // Sumar la comisión de cada venta
    
                    tabla += `
                        <tr>
                            <td>${venta.turno}</td>
                            <td>${venta.numero}</td>
                            <td>${venta.cliente}</td>
                            <td>$${parseFloat(venta.valor).toFixed(2)}</td>
                            <!--<td>$${parseFloat(venta.comision).toFixed(2)}</td>--> <!-- Mostrar la comisión de la venta -->
                            <td>$${parseFloat(venta.ganancia).toFixed(2)}</td>
                            <td>${venta.fecha}</td>
                        </tr>`;
                });
    
                $("#tablaVentas tbody").html(tabla);
    
                // Actualizar los totales en la interfaz
                $("#totalVentas").text(`$${totalVentas.toFixed(2)}`);
                $("#comision").text(`$${totalComision.toFixed(2)}`); // Mostrar la comisión total
                $("#entregar").text(`$${(totalVentas - totalComision).toFixed(2)}`); // Calcular el total a entregar
            },
            error: function(xhr, status, error) {
                // Manejar errores de la solicitud AJAX
                alert("Error al cargar las ventas: " + error);
            }
        });
    }
    
    // Llamar a la función para cargar las ventas al cargar la página
    $(document).ready(function() {
        cargarVentas();
    });
    

// Guardar venta con AJAX
$("#venderButton").click(function () {
    // Prevenir el comportamiento predeterminado
    var id_turno = $('#id_turno').val();  // Asegúrate de que el campo ID de turno esté disponible
    
    // Verificar que el turno esté disponible
    if (!id_turno) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'No se ha seleccionado un turno.',
            showConfirmButton: true
        });
        return;
    }
    
    $.ajax({
        url: 'guardar_venta.php',  // Archivo PHP que procesa la venta
        method: 'POST',
        data: { id_turno: id_turno },  // Enviar el ID del turno como dato
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success') {
                cargarCarrito();
                Swal.fire({
                    icon: 'success',
                    title: 'Venta guardada',
                    text: response.message,
                    showConfirmButton: false,
                    timer: 1500
                });

                // Guardar datos de la venta en una variable global
                window.ventaActual = response.venta;

                // Mostrar el botón de impresión
                $("#imprimirUltimaVenta").show();
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: response.message,
                    showConfirmButton: true
                });
            }
        },
        error: function (xhr, status, error) {
            console.error('Error AJAX:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'No se pudo guardar la venta.',
                showConfirmButton: true
            });
        }
    });
});


// Función para imprimir ticket
$("#imprimirUltimaVenta").click(function () {
    if (!window.ventaActual) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'No hay datos para imprimir.',
            showConfirmButton: true
        });
        return;
    }

    let venta = window.ventaActual;
    //generarTicket(venta);
});

    cargarVentas();
    setInterval(cargarVentas, 5000); // Actualiza cada 5 segundos

    $('#numero, #id_turno').on('change', function() {
        var numero = $('#numero').val();
        var id_turno = $('#id_turno').val();
        
        if (numero >= 0 && numero <= 99 && id_turno) {
            $.ajax({
                url: 'verificar_numero.php', // Archivo PHP que manejará la verificación
                method: 'POST',
                data: { numero: numero, id_turno: id_turno },
                dataType: 'json', // Esperamos una respuesta JSON
                success: function(response) {
                    if (response.status === 'success') {
                        showMessage('alert-success', response.message);
                    } else {
                        showMessage('alert-danger', response.message);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error en la solicitud AJAX:', error);
                    showMessage('alert-danger', 'Hubo un error al verificar el número.');
                }
            });
        }
    });

});

// Función para mostrar mensajes
function showMessage(className, message) {
    $('#mensaje').removeClass('alert-success alert-danger').addClass(className).text(message).show();
}

