<?php
require '../config.php';
session_start();
$id_vendedor = $_SESSION['usuario_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $numero = $_POST['numero']; // Número recibido del formulario
    $id_turno = $_POST['id_turno']; // Turno seleccionado

    // Verificar si el número ya ha sido vendido HOY en el turno seleccionado
    /*$stmt = $pdo->prepare("
        SELECT v.numero 
        FROM ventas v
        JOIN turnos t ON v.id_turno = t.id_turno
        WHERE v.numero = :numero
        AND v.id_turno = :id_turno
        AND DATE(v.fecha) = CURDATE()
    ");
    $stmt->bindParam(':numero', $numero, PDO::PARAM_INT);
    $stmt->bindParam(':id_turno', $id_turno, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        echo json_encode([
            'status' => 'error',
            'message' => "El número $numero ya ha sido vendido hoy en el turno seleccionado."
        ]);
        exit;
    }*/

    // Verificar si el turno ha finalizado
    $stmt_turno = $pdo->prepare("
        SELECT * 
        FROM turnos 
        WHERE id_turno = :id_turno
        AND (hora_inicio <= NOW() AND hora_fin >= NOW())
    ");
    $stmt_turno->bindParam(':id_turno', $id_turno, PDO::PARAM_INT);
    $stmt_turno->execute();

    if ($stmt_turno->rowCount() === 0) {
        echo json_encode([
            'status' => 'error',
            'message' => "El número $numero no está disponible, el turno seleccionado ha finalizado."
        ]);
        exit;
    }

    $stmt_check = $pdo->prepare("
    SELECT SUM(valor) AS total_valor 
    FROM ventas 
    WHERE numero = :numero 
    AND id_turno = :id_turno
    AND id_vendedor = :id_vendedor
");
$stmt_check->execute([
    ':numero' => $numero,
    ':id_turno' => $id_turno,
    ':id_vendedor' => $id_vendedor
]);


    $row = $stmt_check->fetch(PDO::FETCH_ASSOC);
    $total_valor = $row['total_valor'] ?? 0;

    if ($total_valor >= 30) {
        echo json_encode([
            'status' => 'error',
            'message' => "El número $numero ya ha alcanzado el límite de $30.00 en este turno."
        ]);
        exit;
    }

    // Si pasa todas las validaciones, el número está disponible
    echo json_encode([
        'status' => 'success',
        'message' => "El número $numero está disponible para el turno seleccionado."
    ]);
}
?>
