<?php
// Establecer el código de respuesta HTTP 403
http_response_code(403);

// Obtener dirección IP
$ip_address = $_SERVER['REMOTE_ADDR'];

// Obtener detalles del navegador
$user_agent = $_SERVER['HTTP_USER_AGENT'];

// Obtener la ubicación geográfica mediante un servicio externo
$location = 'Desconocido';
$geo_data = json_decode(file_get_contents("http://ipinfo.io/{$ip_address}/json"));
if (isset($geo_data->city) && isset($geo_data->region) && isset($geo_data->country)) {
    $location = "{$geo_data->city}, {$geo_data->region}, {$geo_data->country}";
}

// Capturar detalles adicionales de JavaScript
$details = [
    'ip' => $ip_address,
    'user_agent' => $user_agent,
    'location' => $location,
];

// Guardar la información en un archivo de registro
$log_file = 'access_denied.log'; // Cambia esto a una ruta válida en tu servidor
file_put_contents($log_file, date('Y-m-d H:i:s') . " - Detalles: " . json_encode($details) . "\n", FILE_APPEND);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso Denegado</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8d7da;
            color: #721c24;
            text-align: center;
            padding: 50px;
        }
        h1 {
            font-size: 48px;
        }
        p {
            font-size: 18px;
        }
        .icon {
            font-size: 100px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="icon">
        <i class="fas fa-exclamation-triangle"></i>
    </div>
    <h1>403 - Acceso Denegado</h1>
    <p>No tienes acceso a esta carpeta.</p>
    <p>Este intento de acceso ha sido registrado. Si continúas intentando acceder de manera no autorizada, se recopilarán más datos, incluyendo tu dirección IP, sistema operativo, navegador, y ubicación geográfica. Tomaremos las medidas legales correspondientes.</p>
</body>
</html>
