<?php
session_start();
require '../config.php';
require '../functions.php';

// Obtener el ID del archivo desde la solicitud GET
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0; // Asegúrate de que el ID sea un entero

// Verificar si el ID es válido
if ($id <= 0) {
    echo "ID de archivo no válido.";
    exit;
}

try {
    // Consulta para obtener el archivo de la base de datos
    $stmt = $pdo->prepare("SELECT nombre, tipo_archivo, archivo FROM archivos WHERE id = :id");
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();

    // Verificar si se encontró el archivo
    if ($stmt->rowCount() == 0) {
        echo "No se encontró el archivo.";
        exit;
    }

    // Obtener el archivo
    $file = $stmt->fetch(PDO::FETCH_ASSOC);

    // Devolver el archivo con los encabezados adecuados para descargarlo
    header("Content-type: " . $file['tipo_archivo']);
    header("Content-Disposition: attachment; filename=" . $file['nombre']);
    echo $file['archivo'];
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
