

CREATE TABLE `caja` (
  `id_caja` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` enum('apertura','cierre') NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `fecha` datetime DEFAULT current_timestamp(),
  `usuario_id` int(11) NOT NULL,
  PRIMARY KEY (`id_caja`),
  KEY `usuario_id` (`usuario_id`),
  CONSTRAINT `caja_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id_usuario`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO caja VALUES("1","apertura","150.00","2024-09-08 10:08:39","1");
INSERT INTO caja VALUES("2","cierre","899.00","2024-10-07 09:57:37","1");
INSERT INTO caja VALUES("3","apertura","150.00","2024-10-07 10:16:14","1");
INSERT INTO caja VALUES("5","cierre","150.00","2024-10-07 10:18:57","1");
INSERT INTO caja VALUES("6","apertura","200.00","2024-10-07 10:21:23","1");
INSERT INTO caja VALUES("7","cierre","1000.00","2024-11-25 21:24:16","1");
INSERT INTO caja VALUES("8","apertura","100.00","2024-11-25 21:24:52","1");



CREATE TABLE `carrito` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `numero` int(11) NOT NULL,
  `cliente` varchar(100) NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `id_vendedor` int(11) NOT NULL,
  `id_turno` int(11) NOT NULL,
  `ganancia` decimal(10,0) NOT NULL,
  `session_id` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1528 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO carrito VALUES("615","16","carmen ","1.00","25","1","70","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("619","71","carmen ","1.00","25","1","70","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("626","291","carmen ","1.00","25","1","70","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("634","18","verdura ","0.25","25","1","17","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("636","81","verdura ","0.25","25","1","17","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("639","24","verdura ","0.25","25","1","17","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("645","67","verdura ","0.25","25","1","17","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("649","21","verdura ","0.25","25","1","17","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("652","32","verdura ","0.25","25","1","17","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("657","23","verdura ","0.25","25","1","17","956e513902c8178269303a1900177def");
INSERT INTO carrito VALUES("702","9","X","2.00","13","1","140","9ce7c5f5fa4da3753562879fc94914d2");
INSERT INTO carrito VALUES("993","NULL","Jesus","0.50","10","2","40","df5c38de7a967e9e9fc666289f246767");
INSERT INTO carrito VALUES("1006","2","Jesus","0.50","10","2","40","df5c38de7a967e9e9fc666289f246767");
INSERT INTO carrito VALUES("1107","79","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1108","97","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1109","5","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1110","50","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1111","2","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1114","20","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1116","28","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1119","82","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1121","1","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1124","10","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1126","88","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1127","66","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1128","94","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1129","36","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1130","8","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1131","95","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1133","68","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1134","33","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1135","44","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1136","61","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1138","16","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1139","77","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1141","66","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1142","99","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1144","NULL","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1147","21","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1151","12","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1156","15","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1159","99","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1166","56","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1169","63","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1171","80","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1172","29","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1175","86","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1178","22","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1180","55","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1182","5","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1184","50","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1185","51","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1187","15","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1189","5","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1190","2","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1192","1","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1194","10","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1196","28","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1198","92","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1202","65","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1203","38","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1206","75","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1208","62","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1214","45","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1219","82","Marily 2","0.25","10","3","20","a1e16e44ab3c89396fc60ca1629fc6b4");
INSERT INTO carrito VALUES("1379","9","yesenia ","0.50","25","1","35","c4eb4dfcbe57cea0a1daf38ae2fd2ae5");
INSERT INTO carrito VALUES("1380","45","yesenia ","0.50","25","1","35","c4eb4dfcbe57cea0a1daf38ae2fd2ae5");
INSERT INTO carrito VALUES("1381","18","yesenia ","0.50","25","1","35","c4eb4dfcbe57cea0a1daf38ae2fd2ae5");
INSERT INTO carrito VALUES("1382","81","yesenia ","0.50","25","1","35","c4eb4dfcbe57cea0a1daf38ae2fd2ae5");
INSERT INTO carrito VALUES("1383","2","yesenia ","0.50","25","1","35","c4eb4dfcbe57cea0a1daf38ae2fd2ae5");
INSERT INTO carrito VALUES("1384","77","yesenia ","0.50","25","1","35","c4eb4dfcbe57cea0a1daf38ae2fd2ae5");
INSERT INTO carrito VALUES("1385","77","nury ","0.50","25","1","35","c4eb4dfcbe57cea0a1daf38ae2fd2ae5");
INSERT INTO carrito VALUES("1386","53","d","0.50","25","1","35","c4eb4dfcbe57cea0a1daf38ae2fd2ae5");
INSERT INTO carrito VALUES("1387","35","d","0.25","25","1","17","c4eb4dfcbe57cea0a1daf38ae2fd2ae5");
INSERT INTO carrito VALUES("1395","3","loren","0.25","25","1","17","dccf6910c2566d712a8b3f58556686ed");
INSERT INTO carrito VALUES("1396","10","loren","1.00","25","1","70","dccf6910c2566d712a8b3f58556686ed");
INSERT INTO carrito VALUES("1461","9","yese","0.50","25","1","35","3612f2161f86619877dcf2685856eead");
INSERT INTO carrito VALUES("1526","90","sinai","5.00","25","3","350","23ff29b2ae6c16a0d6453066f99a5e6d");
INSERT INTO carrito VALUES("1527","96","ropa","5.00","25","3","350","23ff29b2ae6c16a0d6453066f99a5e6d");



CREATE TABLE `detalle_sorteos` (
  `id_detalle` int(11) NOT NULL AUTO_INCREMENT,
  `id_sorteo` int(11) DEFAULT NULL,
  `vendedor` varchar(100) DEFAULT NULL,
  `cliente` varchar(100) DEFAULT NULL,
  `numero` int(11) DEFAULT NULL,
  `valor_apostado` decimal(10,2) DEFAULT NULL,
  `ganancia` decimal(10,2) DEFAULT NULL,
  `monto_pagar` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id_detalle`),
  KEY `id_sorteo` (`id_sorteo`),
  CONSTRAINT `detalle_sorteos_ibfk_1` FOREIGN KEY (`id_sorteo`) REFERENCES `historial_sorteos` (`id_sorteo`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO detalle_sorteos VALUES("1","1","Administrador","Maritza Carolina Zepeda Portillo","20","1.75","122.00","122.00");
INSERT INTO detalle_sorteos VALUES("2","1","Ana guadalupe","Alejandra Mendoza","20","1.50","105.00","105.00");
INSERT INTO detalle_sorteos VALUES("3","1","Pamela Michell","Karla Hizel Patrica Yamilet","20","1.00","70.00","70.00");
INSERT INTO detalle_sorteos VALUES("4","1","Juan Test","Ana Guadalupe  Hernández Lopez","20","0.50","35.00","35.00");
INSERT INTO detalle_sorteos VALUES("5","2","Administrador","Jennfer Paola Miranda Hernández","20","2.75","192.00","192.00");
INSERT INTO detalle_sorteos VALUES("6","2","Administrador","Marcos Antonio Cruz","20","0.50","35.00","35.00");
INSERT INTO detalle_sorteos VALUES("7","2","Ana guadalupe","Marcos Antonio Cruz","20","1.00","70.00","70.00");
INSERT INTO detalle_sorteos VALUES("8","2","Ana guadalupe","Marcos Antonio Cruz","20","1.50","105.00","105.00");
INSERT INTO detalle_sorteos VALUES("9","2","Pamela Michell","Ana Guadalupe  Hernández Lopez","20","0.50","35.00","35.00");
INSERT INTO detalle_sorteos VALUES("10","2","Juan Test","Kevin Antonio Jimenez","20","0.75","55.00","55.00");
INSERT INTO detalle_sorteos VALUES("11","2","Juan Test","Kevin Antonio Jimenez","20","1.50","105.00","105.00");
INSERT INTO detalle_sorteos VALUES("12","3","Administrador","Jm","50","15.00","1.00","1.00");
INSERT INTO detalle_sorteos VALUES("13","3","Administrador","Jm","50","14.00","1.00","1.00");
INSERT INTO detalle_sorteos VALUES("14","3","Eduardo","F","50","0.75","55.00","55.00");
INSERT INTO detalle_sorteos VALUES("15","3","Eduardo","F","50","3.00","210.00","210.00");
INSERT INTO detalle_sorteos VALUES("16","3","Eduardo","F","50","5.00","350.00","350.00");
INSERT INTO detalle_sorteos VALUES("17","3","Eduardo","F","50","3.00","210.00","210.00");
INSERT INTO detalle_sorteos VALUES("18","3","Eduardo","J","50","4.00","280.00","280.00");
INSERT INTO detalle_sorteos VALUES("19","3","Eduardo","L","50","14.25","997.00","997.00");
INSERT INTO detalle_sorteos VALUES("20","4","Genesis","N","76","0.25","20.00","20.00");
INSERT INTO detalle_sorteos VALUES("21","4","Estefany","X","76","0.25","17.00","17.00");
INSERT INTO detalle_sorteos VALUES("22","4","Roberto","Q","76","0.50","35.00","35.00");
INSERT INTO detalle_sorteos VALUES("23","5","Patricia","Marily 1","61","0.25","20.00","20.00");



CREATE TABLE `efectivo` (
  `id_efectivo` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` enum('ingreso','egreso') NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `motivo` text NOT NULL,
  `fecha` datetime DEFAULT current_timestamp(),
  `usuario_id` int(11) DEFAULT NULL,
  `caja_id` int(11) NOT NULL,
  PRIMARY KEY (`id_efectivo`),
  KEY `usuario_id` (`usuario_id`),
  CONSTRAINT `efectivo_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id_usuario`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO efectivo VALUES("1","egreso","50.75","Pago de Agua Filtrada","2024-09-08 10:16:04","1","1");
INSERT INTO efectivo VALUES("2","egreso","25.00","Gatos Empresa","2024-10-07 10:29:11","1","6");
INSERT INTO efectivo VALUES("3","ingreso","200.00","xyz","2025-02-24 21:25:58","1","8");



CREATE TABLE `empleados` (
  `id_empleado` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) NOT NULL,
  `puesto` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `telefono` varchar(15) DEFAULT NULL,
  `fecha_contratacion` date DEFAULT curdate(),
  PRIMARY KEY (`id_empleado`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




CREATE TABLE `empresa` (
  `id_empresa` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `estado` varchar(100) NOT NULL,
  `ciudad` varchar(100) NOT NULL,
  `direccion` varchar(255) NOT NULL,
  `telefono` varchar(20) NOT NULL,
  `email` varchar(100) NOT NULL,
  `moneda` varchar(10) NOT NULL,
  `logo` blob DEFAULT NULL,
  PRIMARY KEY (`id_empresa`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO empresa VALUES("1","La Diaria","San Miguel","San Miguel","San Miguel","123456789","info@ladiaria.com","$","../img/ladiaria.jpeg");



CREATE TABLE `historial_sorteos` (
  `id_sorteo` int(11) NOT NULL AUTO_INCREMENT,
  `id_turno` int(11) DEFAULT NULL,
  `numero_ganador` int(11) DEFAULT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `fecha` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id_sorteo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO historial_sorteos VALUES("1","1","20","1","2025-02-27 11:09:01");
INSERT INTO historial_sorteos VALUES("2","2","20","1","2025-02-28 15:01:15");
INSERT INTO historial_sorteos VALUES("3","3","50","1","2025-03-07 22:13:46");
INSERT INTO historial_sorteos VALUES("4","1","76","1","2025-03-08 11:35:18");
INSERT INTO historial_sorteos VALUES("5","3","61","1","2025-03-08 21:18:47");



CREATE TABLE `modulos` (
  `id_modulo` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_modulo` varchar(255) NOT NULL,
  PRIMARY KEY (`id_modulo`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO modulos VALUES("1","Inicio");
INSERT INTO modulos VALUES("2","Clientes");
INSERT INTO modulos VALUES("3","Sorteos");
INSERT INTO modulos VALUES("4","Ventas");
INSERT INTO modulos VALUES("5","Pagos");
INSERT INTO modulos VALUES("6","Caja");
INSERT INTO modulos VALUES("7","Efectivo");
INSERT INTO modulos VALUES("8","Permisos");
INSERT INTO modulos VALUES("9","Usuarios");
INSERT INTO modulos VALUES("10","Empresa");
INSERT INTO modulos VALUES("11","Datos");



CREATE TABLE `pagos` (
  `id_pago` int(11) NOT NULL AUTO_INCREMENT,
  `id_cliente` int(11) NOT NULL,
  `id_renta` int(11) NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `monto` double NOT NULL,
  `fecha_pago` datetime NOT NULL,
  `metodo_pago` enum('Efectivo','Tarjeta de Crédito','Transferencia Bancaria','Otro') NOT NULL,
  `estado` enum('Pendiente','Completo') DEFAULT 'Pendiente',
  `descripcion` text DEFAULT NULL,
  `caja_id` int(11) NOT NULL,
  PRIMARY KEY (`id_pago`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO pagos VALUES("1","100","1","1","97.82","2024-11-28 17:28:29","Efectivo","Completo","NULL","8");
INSERT INTO pagos VALUES("2","102","2","1","75.59","2024-11-28 17:28:59","Efectivo","Completo","NULL","8");
INSERT INTO pagos VALUES("3","103","5","1","269.76","2024-11-30 09:21:47","Efectivo","Completo","NULL","8");
INSERT INTO pagos VALUES("4","108","6","1","68.43","2024-11-30 09:22:09","Efectivo","Completo","NULL","8");
INSERT INTO pagos VALUES("5","2","3","1","198.66","2024-11-30 09:22:31","Efectivo","Completo","NULL","8");



CREATE TABLE `permisos` (
  `id_permiso` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_permiso` varchar(255) NOT NULL,
  `id_modulo` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_permiso`),
  KEY `id_modulo` (`id_modulo`),
  CONSTRAINT `permisos_ibfk_1` FOREIGN KEY (`id_modulo`) REFERENCES `modulos` (`id_modulo`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO permisos VALUES("1","ver_clientes","2");
INSERT INTO permisos VALUES("2","editar_clientes","2");
INSERT INTO permisos VALUES("3","borrar_clientes","2");
INSERT INTO permisos VALUES("4","ver_sorteos","3");
INSERT INTO permisos VALUES("5","editar_sorteos","3");
INSERT INTO permisos VALUES("6","borrar_sorteos","3");
INSERT INTO permisos VALUES("7","ver_ventas","4");
INSERT INTO permisos VALUES("8","editar_ventas","4");
INSERT INTO permisos VALUES("9","borrar_ventas","4");
INSERT INTO permisos VALUES("10","ver_pagos","5");
INSERT INTO permisos VALUES("11","editar_pagos","5");
INSERT INTO permisos VALUES("12","borrar_pagos","5");
INSERT INTO permisos VALUES("13","ver_caja","6");
INSERT INTO permisos VALUES("14","editar_caja","6");
INSERT INTO permisos VALUES("15","borrar_caja","6");
INSERT INTO permisos VALUES("16","ver_efectivo","7");
INSERT INTO permisos VALUES("17","editar_efectivo","7");
INSERT INTO permisos VALUES("18","borrar_efectivo","7");
INSERT INTO permisos VALUES("19","ver_permisos","8");
INSERT INTO permisos VALUES("20","editar_permisos","8");
INSERT INTO permisos VALUES("21","borrar_permisos","8");
INSERT INTO permisos VALUES("22","ver_usuarios","9");
INSERT INTO permisos VALUES("23","editar_usuarios","9");
INSERT INTO permisos VALUES("24","borrar_usuarios","9");
INSERT INTO permisos VALUES("25","ver_empresa","10");
INSERT INTO permisos VALUES("26","editar_empresa","10");
INSERT INTO permisos VALUES("27","borrar_empresa","10");
INSERT INTO permisos VALUES("28","ver_datos","11");
INSERT INTO permisos VALUES("29","editar_datos","11");
INSERT INTO permisos VALUES("30","borrar_datos","11");



CREATE TABLE `roles` (
  `id_rol` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_rol` varchar(50) NOT NULL,
  PRIMARY KEY (`id_rol`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO roles VALUES("1","Cajero");
INSERT INTO roles VALUES("2","Administrador");
INSERT INTO roles VALUES("3","Usuario");
INSERT INTO roles VALUES("5","Vendedor");



CREATE TABLE `roles_permisos` (
  `id_rol` int(11) NOT NULL,
  `id_permiso` int(11) NOT NULL,
  PRIMARY KEY (`id_rol`,`id_permiso`),
  KEY `id_permiso` (`id_permiso`),
  CONSTRAINT `roles_permisos_ibfk_1` FOREIGN KEY (`id_rol`) REFERENCES `roles` (`id_rol`) ON DELETE CASCADE,
  CONSTRAINT `roles_permisos_ibfk_2` FOREIGN KEY (`id_permiso`) REFERENCES `permisos` (`id_permiso`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO roles_permisos VALUES("2","1");
INSERT INTO roles_permisos VALUES("2","2");
INSERT INTO roles_permisos VALUES("2","3");
INSERT INTO roles_permisos VALUES("2","4");
INSERT INTO roles_permisos VALUES("2","5");
INSERT INTO roles_permisos VALUES("2","6");
INSERT INTO roles_permisos VALUES("2","7");
INSERT INTO roles_permisos VALUES("2","8");
INSERT INTO roles_permisos VALUES("2","9");
INSERT INTO roles_permisos VALUES("2","10");
INSERT INTO roles_permisos VALUES("2","11");
INSERT INTO roles_permisos VALUES("2","12");
INSERT INTO roles_permisos VALUES("2","13");
INSERT INTO roles_permisos VALUES("2","14");
INSERT INTO roles_permisos VALUES("2","15");
INSERT INTO roles_permisos VALUES("2","16");
INSERT INTO roles_permisos VALUES("2","17");
INSERT INTO roles_permisos VALUES("2","18");
INSERT INTO roles_permisos VALUES("2","19");
INSERT INTO roles_permisos VALUES("2","20");
INSERT INTO roles_permisos VALUES("2","21");
INSERT INTO roles_permisos VALUES("2","22");
INSERT INTO roles_permisos VALUES("2","23");
INSERT INTO roles_permisos VALUES("2","24");
INSERT INTO roles_permisos VALUES("2","25");
INSERT INTO roles_permisos VALUES("2","26");
INSERT INTO roles_permisos VALUES("2","27");
INSERT INTO roles_permisos VALUES("2","28");
INSERT INTO roles_permisos VALUES("2","29");
INSERT INTO roles_permisos VALUES("2","30");
INSERT INTO roles_permisos VALUES("5","1");
INSERT INTO roles_permisos VALUES("5","2");
INSERT INTO roles_permisos VALUES("5","3");
INSERT INTO roles_permisos VALUES("5","4");
INSERT INTO roles_permisos VALUES("5","5");
INSERT INTO roles_permisos VALUES("5","6");
INSERT INTO roles_permisos VALUES("5","7");
INSERT INTO roles_permisos VALUES("5","8");
INSERT INTO roles_permisos VALUES("5","9");
INSERT INTO roles_permisos VALUES("5","10");
INSERT INTO roles_permisos VALUES("5","11");
INSERT INTO roles_permisos VALUES("5","12");
INSERT INTO roles_permisos VALUES("5","13");
INSERT INTO roles_permisos VALUES("5","14");
INSERT INTO roles_permisos VALUES("5","15");
INSERT INTO roles_permisos VALUES("5","16");
INSERT INTO roles_permisos VALUES("5","17");
INSERT INTO roles_permisos VALUES("5","18");
INSERT INTO roles_permisos VALUES("5","19");
INSERT INTO roles_permisos VALUES("5","20");
INSERT INTO roles_permisos VALUES("5","21");
INSERT INTO roles_permisos VALUES("5","22");
INSERT INTO roles_permisos VALUES("5","23");
INSERT INTO roles_permisos VALUES("5","24");
INSERT INTO roles_permisos VALUES("5","25");
INSERT INTO roles_permisos VALUES("5","26");
INSERT INTO roles_permisos VALUES("5","27");
INSERT INTO roles_permisos VALUES("5","28");
INSERT INTO roles_permisos VALUES("5","29");
INSERT INTO roles_permisos VALUES("5","30");



CREATE TABLE `servicios` (
  `id_servicio` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) DEFAULT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  `estado` int(11) NOT NULL,
  PRIMARY KEY (`id_servicio`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO servicios VALUES("1","Servicio de limpieza","25.00","1");
INSERT INTO servicios VALUES("2","Desayuno buffet","15.00","1");
INSERT INTO servicios VALUES("3","Acceso al gimnasio","10.00","1");
INSERT INTO servicios VALUES("4","Piscina","8.00","1");
INSERT INTO servicios VALUES("5","Servicio de spa","50.00","1");
INSERT INTO servicios VALUES("6","Alquiler de sala de conferencias","100.00","1");
INSERT INTO servicios VALUES("7","Wi-Fi premium","5.00","1");
INSERT INTO servicios VALUES("8","Servicio de lavandería","20.00","1");
INSERT INTO servicios VALUES("9","Parking","12.00","1");
INSERT INTO servicios VALUES("10","Transporte al aeropuerto","30.00","1");



CREATE TABLE `servicios_reservacion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_reservacion` int(11) NOT NULL,
  `id_servicio` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL,
  `total` decimal(10,0) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




CREATE TABLE `sucursales` (
  `id_sucursal` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `direccion` varchar(255) NOT NULL,
  `telefono` varchar(15) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  PRIMARY KEY (`id_sucursal`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;




CREATE TABLE `turnos` (
  `id_turno` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `hora_inicio` time NOT NULL,
  `hora_fin` time NOT NULL,
  `dia` varchar(15) NOT NULL,
  PRIMARY KEY (`id_turno`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO turnos VALUES("1","Sorteo 11: 00 am","07:00:00","10:55:00","semana");
INSERT INTO turnos VALUES("2","Sorteo 03:00 pm","07:00:00","14:55:00","semana");
INSERT INTO turnos VALUES("3","Sorteo 09:00 pm","07:00:00","20:55:00","semana");
INSERT INTO turnos VALUES("4","Sorteo domingo 09:00 pm","07:00:00","20:55:00","domingo");



CREATE TABLE `usuarios` (
  `id_usuario` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_usuario` varchar(50) NOT NULL,
  `contra` varchar(255) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `apellido` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `rol` varchar(15) DEFAULT 'admin',
  `comision` int(11) NOT NULL,
  `rifa` varchar(25) NOT NULL,
  `estado` varchar(15) NOT NULL,
  PRIMARY KEY (`id_usuario`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO usuarios VALUES("1","admin","$2y$10$OG0FBM/h8QG2rz97BriI0OKvI17A9bifo4d9Wf7TCjBdMshiJD4RS","Jhony","Melendez","admin@ejemplo.com","admin","15","80","activo");
INSERT INTO usuarios VALUES("9","eduardo","$2y$10$4sLnrfy80l7y0XCkxVF3/.My/tfovkLbHLqbo6wlsuCzIU5YK4Vde","Eduardo","Nolasco","Eduardo@gmail.com","admin","25","70","activo");
INSERT INTO usuarios VALUES("10","patricia","$2y$10$oo9CtjWwa6zrzVIunaQYAODjsWShD4GShMOAeSWiFTQEwLQcqNJ82","Patricia","Nolasco","p@gmail.com","vendedor","15","80","activo");
INSERT INTO usuarios VALUES("11","roberto","$2y$10$ET5RY5rUcsbh/ieNQpZ1T.NhLxAHgAp/phbntTJ3drKldKqMUyGqq","Roberto","Lopez","r@gmail.com","vendedor","25","70","activo");
INSERT INTO usuarios VALUES("12","mayrena","$2y$10$g2hZW/vavRnNYbx2/yeG2OopZ5g5WTCasAOBUn0CWG/LBEj5d/aUS","Mayrena","M","m@g.com","vendedor","NULL","80","activo");
INSERT INTO usuarios VALUES("13","estefany","$2y$10$EAXuyomrAbFuRXp9xp.HE.qMUE4Bjsperiecnlc7WykLXokWuesce","Estefany","Benavides","e@g.com","admin","25","70","activo");
INSERT INTO usuarios VALUES("14","yamileth","$2y$10$mNahT6A6FbHbnXYWUY8ucORgPB16X924PtkUv1DjLQUYmyrC8sf6e","Yamileth","Nolasco","y@g.com","vendedor","NULL","80","activo");
INSERT INTO usuarios VALUES("19","ziomara","$2y$10$DXmJ.78lstQb2ZzLLqSfL.UqwItHWXgRNuEppTSNZLkGQMPGsST2S","Ziomara","N","ziomara@mail.com","vendedor","15","80","activo");
INSERT INTO usuarios VALUES("22","mirian","$2y$10$ddRHBgti9J59GtsXK2A6ruRoGVE./9h0QDkYWEJRG2LVr2pTZPvqC","Mirian","Portillo","mirian@gmail.com","vendedor","25","70","activo");
INSERT INTO usuarios VALUES("23","alex","$2y$10$mf36NpLiwaRgBOHvS/xzAeKZ1NaILRRtx66rP4sQ0Qu9h15Lk8ibG","Alex","N","alex@gmail.com","vendedor","25","70","activo");
INSERT INTO usuarios VALUES("24","henry","$2y$10$4tSem4bj31xZrGjfPcoaXO9RPz50wi9ERQVR2d1FKhBzO3EbvXAw2","Henry","N","henry@gmail.com","vendedor","25","70","activo");
INSERT INTO usuarios VALUES("25","vilma","$2y$10$GrLpQrrMzEoVw.IRNwWlI.w9fr5NO/W6QukohheOlLP4R.wlErxuG","Vilma","N","vilma@gmail","vendedor","25","70","activo");
INSERT INTO usuarios VALUES("26","junior","$2y$10$YCxeEwfGNa7vBuB8rf71e.8FEgPkCPIb4dthddcJR.aEr/CfS3PEK","Junior","N","junior@gmail.com","vendedor","15","80","activo");
INSERT INTO usuarios VALUES("27","tatiana","$2y$10$Hit3rhDDGRo1fJLPaDpcFOxVfiwueSN3QhsWthtVztcMCRVrteM4C","Tatiana","N","tatiana@gmail.com","vendedor","15","80","activo");
INSERT INTO usuarios VALUES("28","melissa","$2y$10$bWDgqWwx7XLgST1e.p079e3mgZvM6eBKVnLDCjdEhuiIZ23ym2gjS","Melissa","N","melissa@gmail","vendedor","15","80","activo");
INSERT INTO usuarios VALUES("29","saida","$2y$10$DpuOwDO1jTe15Uz.bd6wLOds7elhBA85ywiljLLAuZlHelTOu2zka","Saida","Ayala","saida@gmail.com","vendedor","15","80","activo");
INSERT INTO usuarios VALUES("30","yansi","$2y$10$hptZF.Jdu53Pnu5g7D7UTu1.Wic5vGXYRcgZsaHeh7kWw5bN2.HjO","Yansi ","N","yansi@gmail.com","vendedor","25","70","activo");
INSERT INTO usuarios VALUES("31","alison","$2y$10$b9w64duiy0jWDrsdtJwjWOJBD82Q2e4t/PYnDRqbN7Teeu6jH25em","Alison","N","alison@gmail.com","vendedor","15","80","activo");
INSERT INTO usuarios VALUES("32","genesis","$2y$10$WP9pS2u7anKPlltsWIVrRORQLjOobwT9YXKPyQp/lY1yA/P3TAezq","Genesis","Alfaro","genesis@gmail.com","vendedor","NULL","80","activo");



CREATE TABLE `usuarios_roles` (
  `id_usuario` int(11) NOT NULL,
  `id_rol` int(11) NOT NULL,
  PRIMARY KEY (`id_usuario`,`id_rol`),
  KEY `id_rol` (`id_rol`),
  CONSTRAINT `usuarios_roles_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id_usuario`) ON DELETE CASCADE,
  CONSTRAINT `usuarios_roles_ibfk_2` FOREIGN KEY (`id_rol`) REFERENCES `roles` (`id_rol`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO usuarios_roles VALUES("1","2");
INSERT INTO usuarios_roles VALUES("9","2");
INSERT INTO usuarios_roles VALUES("10","5");
INSERT INTO usuarios_roles VALUES("11","5");
INSERT INTO usuarios_roles VALUES("12","5");
INSERT INTO usuarios_roles VALUES("13","2");
INSERT INTO usuarios_roles VALUES("14","5");
INSERT INTO usuarios_roles VALUES("19","5");
INSERT INTO usuarios_roles VALUES("22","5");
INSERT INTO usuarios_roles VALUES("23","5");
INSERT INTO usuarios_roles VALUES("24","5");
INSERT INTO usuarios_roles VALUES("25","5");
INSERT INTO usuarios_roles VALUES("26","5");
INSERT INTO usuarios_roles VALUES("27","5");
INSERT INTO usuarios_roles VALUES("28","5");
INSERT INTO usuarios_roles VALUES("29","5");
INSERT INTO usuarios_roles VALUES("30","5");
INSERT INTO usuarios_roles VALUES("31","5");
INSERT INTO usuarios_roles VALUES("32","5");



CREATE TABLE `ventas` (
  `id_venta` int(11) NOT NULL AUTO_INCREMENT,
  `id_vendedor` int(11) NOT NULL,
  `id_turno` int(11) NOT NULL,
  `numero` int(11) NOT NULL CHECK (`numero` between 0 and 99),
  `cliente` varchar(100) NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `ganancia` decimal(10,2) NOT NULL,
  `correlativo` varchar(25) NOT NULL,
  `rifa` int(11) NOT NULL,
  `comision` decimal(10,2) NOT NULL,
  `fecha` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_venta`)
) ENGINE=InnoDB AUTO_INCREMENT=1007 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO ventas VALUES("1","9","1","94","P","1.00","70.00","1","70","0.25","2025-03-08 07:46:22");
INSERT INTO ventas VALUES("2","13","1","21","H","1.50","105.00","1","70","0.38","2025-03-08 07:48:00");
INSERT INTO ventas VALUES("3","13","1","57","H","2.00","140.00","1","70","0.50","2025-03-08 07:48:00");
INSERT INTO ventas VALUES("4","10","1","99","Dra","1.00","80.00","1","80","0.15","2025-03-08 08:29:58");
INSERT INTO ventas VALUES("5","10","1","96","Dra","3.00","240.00","1","80","0.45","2025-03-08 08:29:58");
INSERT INTO ventas VALUES("6","19","1","75","Marta","0.50","40.00","1","80","0.08","2025-03-08 09:10:08");
INSERT INTO ventas VALUES("7","19","1","3","Juan ","1.00","80.00","2","80","0.15","2025-03-08 09:12:25");
INSERT INTO ventas VALUES("8","19","1","4","Juan ","1.00","80.00","2","80","0.15","2025-03-08 09:12:25");
INSERT INTO ventas VALUES("9","19","1","29","Juan ","0.50","40.00","2","80","0.08","2025-03-08 09:12:25");
INSERT INTO ventas VALUES("10","19","1","9","Juan ","0.50","40.00","2","80","0.08","2025-03-08 09:12:25");
INSERT INTO ventas VALUES("11","19","1","2","Juan ","0.50","40.00","2","80","0.08","2025-03-08 09:12:25");
INSERT INTO ventas VALUES("12","19","1","61","Juan ","0.50","40.00","2","80","0.08","2025-03-08 09:12:25");
INSERT INTO ventas VALUES("13","13","1","56","X","0.25","17.00","2","70","0.06","2025-03-08 09:30:57");
INSERT INTO ventas VALUES("14","13","1","42","X","0.25","17.00","2","70","0.06","2025-03-08 09:30:57");
INSERT INTO ventas VALUES("15","13","1","2","X","0.25","17.00","2","70","0.06","2025-03-08 09:30:57");
INSERT INTO ventas VALUES("16","13","1","79","X","0.25","17.00","2","70","0.06","2025-03-08 09:30:57");
INSERT INTO ventas VALUES("17","13","1","31","X","2.00","140.00","3","70","0.50","2025-03-08 09:31:55");
INSERT INTO ventas VALUES("18","13","1","13","X","3.00","210.00","3","70","0.75","2025-03-08 09:31:55");
INSERT INTO ventas VALUES("19","13","1","30","X","2.00","140.00","3","70","0.50","2025-03-08 09:31:55");
INSERT INTO ventas VALUES("20","13","1","3","X","2.00","140.00","4","70","0.50","2025-03-08 09:37:23");
INSERT INTO ventas VALUES("21","13","1","96","X","3.00","210.00","4","70","0.75","2025-03-08 09:37:23");
INSERT INTO ventas VALUES("22","13","1","44","X","1.00","70.00","5","70","0.25","2025-03-08 09:38:03");
INSERT INTO ventas VALUES("23","13","1","75","E","1.00","70.00","6","70","0.25","2025-03-08 09:40:00");
INSERT INTO ventas VALUES("24","13","1","38","A","0.50","35.00","7","70","0.13","2025-03-08 09:40:26");
INSERT INTO ventas VALUES("25","24","1","3","Francisco ","0.75","55.00","1","70","0.19","2025-03-08 09:40:52");
INSERT INTO ventas VALUES("26","13","1","38","K","0.25","17.00","8","70","0.06","2025-03-08 09:41:26");
INSERT INTO ventas VALUES("27","13","1","83","K","0.25","17.00","8","70","0.06","2025-03-08 09:41:26");
INSERT INTO ventas VALUES("28","13","1","33","K","0.25","17.00","8","70","0.06","2025-03-08 09:41:26");
INSERT INTO ventas VALUES("29","24","1","47","Brenda","0.75","55.00","2","70","0.19","2025-03-08 09:43:07");
INSERT INTO ventas VALUES("30","32","1","16","X","0.25","20.00","1","80","0.00","2025-03-08 09:43:52");
INSERT INTO ventas VALUES("31","32","1","61","X","0.25","20.00","1","80","0.00","2025-03-08 09:43:52");
INSERT INTO ventas VALUES("32","32","1","11","X","0.25","20.00","1","80","0.00","2025-03-08 09:43:52");
INSERT INTO ventas VALUES("33","32","1","NULL","X","0.25","20.00","1","80","0.00","2025-03-08 09:43:52");
INSERT INTO ventas VALUES("34","32","1","77","X","0.25","20.00","1","80","0.00","2025-03-08 09:43:52");
INSERT INTO ventas VALUES("35","13","1","75","J","0.50","35.00","9","70","0.13","2025-03-08 09:45:00");
INSERT INTO ventas VALUES("36","13","1","96","J","1.00","70.00","9","70","0.25","2025-03-08 09:45:00");
INSERT INTO ventas VALUES("37","32","1","96","B","1.50","120.00","2","80","0.00","2025-03-08 09:46:40");
INSERT INTO ventas VALUES("38","32","1","36","B","0.50","40.00","2","80","0.00","2025-03-08 09:46:40");
INSERT INTO ventas VALUES("39","32","1","63","B","0.50","40.00","2","80","0.00","2025-03-08 09:46:40");
INSERT INTO ventas VALUES("40","32","1","10","B","0.50","40.00","2","80","0.00","2025-03-08 09:46:40");
INSERT INTO ventas VALUES("41","32","1","1","B","0.50","40.00","2","80","0.00","2025-03-08 09:46:40");
INSERT INTO ventas VALUES("42","32","1","35","B","0.25","20.00","2","80","0.00","2025-03-08 09:46:40");
INSERT INTO ventas VALUES("43","32","1","53","B","0.25","20.00","2","80","0.00","2025-03-08 09:46:40");
INSERT INTO ventas VALUES("44","32","1","66","N","1.00","80.00","3","80","0.00","2025-03-08 09:47:25");
INSERT INTO ventas VALUES("45","32","1","96","N","1.00","80.00","3","80","0.00","2025-03-08 09:47:25");
INSERT INTO ventas VALUES("46","13","1","32","E","0.25","17.00","10","70","0.06","2025-03-08 09:55:29");
INSERT INTO ventas VALUES("47","13","1","68","E","0.25","17.00","10","70","0.06","2025-03-08 09:55:29");
INSERT INTO ventas VALUES("48","13","1","42","E","0.25","17.00","10","70","0.06","2025-03-08 09:55:29");
INSERT INTO ventas VALUES("49","13","1","2","E","0.25","17.00","10","70","0.06","2025-03-08 09:55:29");
INSERT INTO ventas VALUES("50","13","1","65","Norma","0.50","35.00","10","70","0.13","2025-03-08 10:00:50");
INSERT INTO ventas VALUES("51","19","1","75","Marta","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("52","19","1","33","Sulma ","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("53","19","1","3","Juan ","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("54","19","1","3","Juan ","2.00","160.00","3","80","0.30","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("55","19","1","2","Xioma","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("56","19","1","3","Xioma","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("57","19","1","4","Juan ","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("58","19","1","29","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("59","19","1","9","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("60","19","1","2","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("61","19","1","61","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("62","19","1","10","Sofia","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("63","19","1","28","Sofia","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("64","19","1","99","Sofia","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("65","19","1","19","Sofia","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("66","19","1","2","Sulma ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("67","19","1","2","Maria ","1.50","120.00","3","80","0.23","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("68","19","1","14","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("69","19","1","11","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("70","19","1","3","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("71","19","1","79","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("72","19","1","20","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("73","19","1","99","Juan ","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("74","19","1","3","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("75","19","1","30","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("76","19","1","13","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("77","19","1","31","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("78","19","1","11","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("79","19","1","NULL","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("80","19","1","34","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("81","19","1","43","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("82","19","1","22","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("83","19","1","55","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("84","19","1","96","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("85","19","1","69","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("86","19","1","32","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("87","19","1","23","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("88","19","1","23","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("89","19","1","94","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("90","19","1","49","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("91","19","1","10","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("92","19","1","1","Rosita","0.25","20.00","3","80","0.04","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("93","19","1","3","Rosita","2.00","160.00","3","80","0.30","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("94","19","1","3","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("95","19","1","29","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("96","19","1","11","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("97","19","1","30","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("98","19","1","92","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("99","19","1","NULL","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("100","19","1","48","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("101","19","1","84","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("102","19","1","1","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("103","19","1","10","Marina","1.00","80.00","3","80","0.15","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("104","19","1","2","Pana","2.00","160.00","3","80","0.30","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("105","19","1","14","Pana","0.50","40.00","3","80","0.08","2025-03-08 10:06:59");
INSERT INTO ventas VALUES("106","11","1","99","R","2.00","140.00","1","70","0.50","2025-03-08 10:07:07");
INSERT INTO ventas VALUES("107","11","1","66","R","5.00","350.00","1","70","1.25","2025-03-08 10:07:07");
INSERT INTO ventas VALUES("108","11","1","2","R","1.00","70.00","1","70","0.25","2025-03-08 10:07:07");
INSERT INTO ventas VALUES("109","11","1","20","R","1.00","70.00","1","70","0.25","2025-03-08 10:07:07");
INSERT INTO ventas VALUES("110","11","1","79","Q","2.00","140.00","2","70","0.50","2025-03-08 10:08:46");
INSERT INTO ventas VALUES("111","11","1","96","Q","0.25","17.00","2","70","0.06","2025-03-08 10:08:46");
INSERT INTO ventas VALUES("112","11","1","20","Q","0.50","35.00","2","70","0.13","2025-03-08 10:08:46");
INSERT INTO ventas VALUES("113","13","1","16","Fidel","1.00","70.00","10","70","0.25","2025-03-08 10:09:05");
INSERT INTO ventas VALUES("114","13","1","19","Fidel","1.00","70.00","10","70","0.25","2025-03-08 10:09:05");
INSERT INTO ventas VALUES("115","25","1","2","dera ","0.50","35.00","1","70","0.13","2025-03-08 10:10:23");
INSERT INTO ventas VALUES("116","25","1","20","dera ","0.50","35.00","1","70","0.13","2025-03-08 10:10:23");
INSERT INTO ventas VALUES("117","13","1","96","Anival","1.00","70.00","10","70","0.25","2025-03-08 10:10:45");
INSERT INTO ventas VALUES("118","13","1","95","Anival","1.00","70.00","10","70","0.25","2025-03-08 10:11:04");
INSERT INTO ventas VALUES("119","25","1","14","x","5.00","350.00","2","70","1.25","2025-03-08 10:11:49");
INSERT INTO ventas VALUES("120","32","1","3","Y","0.50","40.00","4","80","0.00","2025-03-08 10:13:25");
INSERT INTO ventas VALUES("121","32","1","30","Y","0.25","20.00","4","80","0.00","2025-03-08 10:13:25");
INSERT INTO ventas VALUES("122","32","1","36","Y","0.25","20.00","4","80","0.00","2025-03-08 10:13:25");
INSERT INTO ventas VALUES("123","32","1","18","Y","0.25","20.00","4","80","0.00","2025-03-08 10:13:25");
INSERT INTO ventas VALUES("124","32","1","16","Y","0.25","20.00","4","80","0.00","2025-03-08 10:13:25");
INSERT INTO ventas VALUES("125","32","1","99","Y","0.25","20.00","4","80","0.00","2025-03-08 10:13:25");
INSERT INTO ventas VALUES("126","32","1","2","Y","0.25","20.00","4","80","0.00","2025-03-08 10:13:25");
INSERT INTO ventas VALUES("127","9","1","14","D","0.50","35.00","2","70","0.13","2025-03-08 10:13:53");
INSERT INTO ventas VALUES("128","9","1","47","D","0.50","35.00","2","70","0.13","2025-03-08 10:13:53");
INSERT INTO ventas VALUES("129","9","1","55","A","2.00","140.00","3","70","0.50","2025-03-08 10:14:56");
INSERT INTO ventas VALUES("130","9","1","42","A","0.50","35.00","3","70","0.13","2025-03-08 10:14:56");
INSERT INTO ventas VALUES("131","9","1","9","A","0.50","35.00","3","70","0.13","2025-03-08 10:14:56");
INSERT INTO ventas VALUES("132","32","1","22","R","0.50","40.00","5","80","0.00","2025-03-08 10:14:58");
INSERT INTO ventas VALUES("133","32","1","3","R","0.50","40.00","5","80","0.00","2025-03-08 10:14:58");
INSERT INTO ventas VALUES("134","32","1","8","R","0.25","20.00","5","80","0.00","2025-03-08 10:14:58");
INSERT INTO ventas VALUES("135","32","1","80","R","0.25","20.00","5","80","0.00","2025-03-08 10:14:58");
INSERT INTO ventas VALUES("136","32","1","2","R","0.25","20.00","5","80","0.00","2025-03-08 10:14:58");
INSERT INTO ventas VALUES("137","32","1","75","C","0.50","40.00","6","80","0.00","2025-03-08 10:16:18");
INSERT INTO ventas VALUES("138","32","1","51","C","0.25","20.00","6","80","0.00","2025-03-08 10:16:18");
INSERT INTO ventas VALUES("139","32","1","38","C","0.25","20.00","6","80","0.00","2025-03-08 10:16:18");
INSERT INTO ventas VALUES("140","32","1","2","C","0.50","40.00","6","80","0.00","2025-03-08 10:16:18");
INSERT INTO ventas VALUES("141","13","1","51","X","1.00","70.00","10","70","0.25","2025-03-08 10:16:52");
INSERT INTO ventas VALUES("142","13","1","32","X","1.00","70.00","10","70","0.25","2025-03-08 10:16:52");
INSERT INTO ventas VALUES("143","32","1","75","Carmen ","1.00","80.00","7","80","0.00","2025-03-08 10:16:55");
INSERT INTO ventas VALUES("144","32","1","79","Carmen ","0.50","40.00","7","80","0.00","2025-03-08 10:16:55");
INSERT INTO ventas VALUES("145","9","1","16","S","0.50","35.00","4","70","0.13","2025-03-08 10:17:07");
INSERT INTO ventas VALUES("146","9","1","96","S","0.75","55.00","4","70","0.19","2025-03-08 10:17:07");
INSERT INTO ventas VALUES("147","9","1","18","S","0.50","35.00","4","70","0.13","2025-03-08 10:17:07");
INSERT INTO ventas VALUES("148","9","1","14","S","0.25","17.00","4","70","0.06","2025-03-08 10:17:07");
INSERT INTO ventas VALUES("149","9","1","3","S","0.25","17.00","4","70","0.06","2025-03-08 10:17:07");
INSERT INTO ventas VALUES("150","9","1","61","S","0.25","17.00","4","70","0.06","2025-03-08 10:17:07");
INSERT INTO ventas VALUES("151","9","1","14","F","0.50","35.00","5","70","0.13","2025-03-08 10:18:05");
INSERT INTO ventas VALUES("152","9","1","41","F","0.50","35.00","5","70","0.13","2025-03-08 10:18:05");
INSERT INTO ventas VALUES("153","9","1","8","F","0.50","35.00","5","70","0.13","2025-03-08 10:18:05");
INSERT INTO ventas VALUES("154","9","1","80","F","0.50","35.00","5","70","0.13","2025-03-08 10:18:05");
INSERT INTO ventas VALUES("155","9","1","3","C","0.75","55.00","6","70","0.19","2025-03-08 10:18:48");
INSERT INTO ventas VALUES("156","9","1","14","C","0.75","55.00","6","70","0.19","2025-03-08 10:18:48");
INSERT INTO ventas VALUES("157","9","1","2","C","0.50","35.00","7","70","0.13","2025-03-08 10:20:55");
INSERT INTO ventas VALUES("158","28","1","3","X","0.75","60.00","1","80","0.11","2025-03-08 10:21:23");
INSERT INTO ventas VALUES("159","28","1","77","X","0.25","20.00","1","80","0.04","2025-03-08 10:21:23");
INSERT INTO ventas VALUES("160","28","1","14","X","0.25","20.00","1","80","0.04","2025-03-08 10:21:23");
INSERT INTO ventas VALUES("161","28","1","17","X","0.25","20.00","1","80","0.04","2025-03-08 10:21:23");
INSERT INTO ventas VALUES("162","28","1","9","X","0.25","20.00","1","80","0.04","2025-03-08 10:21:23");
INSERT INTO ventas VALUES("163","9","1","96","C","0.50","35.00","8","70","0.13","2025-03-08 10:23:29");
INSERT INTO ventas VALUES("164","32","1","2","T","0.50","40.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("165","32","1","61","T","0.50","40.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("166","32","1","79","T","0.50","40.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("167","32","1","21","T","0.25","20.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("168","32","1","34","T","0.25","20.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("169","32","1","67","T","0.25","20.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("170","32","1","47","T","0.25","20.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("171","32","1","78","T","1.00","80.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("172","32","1","99","T","0.50","40.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("173","32","1","11","T","0.50","40.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("174","32","1","88","T","0.25","20.00","8","80","0.00","2025-03-08 10:24:12");
INSERT INTO ventas VALUES("175","9","1","4","C","0.50","35.00","9","70","0.13","2025-03-08 10:24:30");
INSERT INTO ventas VALUES("176","9","1","40","C","0.50","35.00","9","70","0.13","2025-03-08 10:24:30");
INSERT INTO ventas VALUES("177","25","1","32","c","0.50","35.00","3","70","0.13","2025-03-08 10:24:32");
INSERT INTO ventas VALUES("178","25","1","23","c","0.50","35.00","3","70","0.13","2025-03-08 10:24:32");
INSERT INTO ventas VALUES("179","25","1","96","c","0.50","35.00","3","70","0.13","2025-03-08 10:24:32");
INSERT INTO ventas VALUES("180","25","1","42","c","0.25","17.00","3","70","0.06","2025-03-08 10:24:32");
INSERT INTO ventas VALUES("181","25","1","24","c","0.25","17.00","3","70","0.06","2025-03-08 10:24:32");
INSERT INTO ventas VALUES("182","25","1","96","ropa","5.00","350.00","3","70","1.25","2025-03-08 10:24:32");
INSERT INTO ventas VALUES("183","25","1","68","reloj","0.50","35.00","3","70","0.13","2025-03-08 10:24:32");
INSERT INTO ventas VALUES("184","9","1","2","C","1.00","70.00","10","70","0.25","2025-03-08 10:25:42");
INSERT INTO ventas VALUES("185","9","1","21","P","0.50","35.00","10","70","0.13","2025-03-08 10:26:04");
INSERT INTO ventas VALUES("186","9","1","6","P","0.50","35.00","10","70","0.13","2025-03-08 10:26:04");
INSERT INTO ventas VALUES("187","13","1","18","Carmen","2.00","140.00","10","70","0.50","2025-03-08 10:28:37");
INSERT INTO ventas VALUES("188","9","1","31","C","0.25","17.00","10","70","0.06","2025-03-08 10:28:44");
INSERT INTO ventas VALUES("189","9","1","80","C","0.25","17.00","10","70","0.06","2025-03-08 10:28:44");
INSERT INTO ventas VALUES("190","9","1","1","C","0.25","17.00","10","70","0.06","2025-03-08 10:28:44");
INSERT INTO ventas VALUES("191","9","1","59","C","0.25","17.00","10","70","0.06","2025-03-08 10:28:44");
INSERT INTO ventas VALUES("192","9","1","8","C","0.25","17.00","10","70","0.06","2025-03-08 10:28:44");
INSERT INTO ventas VALUES("193","9","1","71","C","0.25","17.00","10","70","0.06","2025-03-08 10:28:44");
INSERT INTO ventas VALUES("194","9","1","96","Rafa","0.25","17.00","10","70","0.06","2025-03-08 10:30:40");
INSERT INTO ventas VALUES("195","9","1","38","Rafa","0.25","17.00","10","70","0.06","2025-03-08 10:30:40");
INSERT INTO ventas VALUES("196","9","1","99","Rafa","0.25","17.00","10","70","0.06","2025-03-08 10:30:40");
INSERT INTO ventas VALUES("197","9","1","55","C","0.50","35.00","10","70","0.13","2025-03-08 10:32:40");
INSERT INTO ventas VALUES("198","9","1","22","C","0.50","35.00","10","70","0.13","2025-03-08 10:32:40");
INSERT INTO ventas VALUES("199","9","1","42","S","0.50","35.00","10","70","0.13","2025-03-08 10:33:15");
INSERT INTO ventas VALUES("200","9","1","77","S","0.50","35.00","10","70","0.13","2025-03-08 10:33:15");
INSERT INTO ventas VALUES("201","9","1","9","S","0.50","35.00","10","70","0.13","2025-03-08 10:33:15");
INSERT INTO ventas VALUES("202","9","1","23","E","0.50","35.00","10","70","0.13","2025-03-08 10:33:44");
INSERT INTO ventas VALUES("203","32","1","3","R","0.50","40.00","9","80","0.00","2025-03-08 10:37:41");
INSERT INTO ventas VALUES("204","32","1","30","R","0.50","40.00","9","80","0.00","2025-03-08 10:37:41");
INSERT INTO ventas VALUES("205","32","1","8","R","0.50","40.00","9","80","0.00","2025-03-08 10:37:41");
INSERT INTO ventas VALUES("206","32","1","99","R","0.50","40.00","9","80","0.00","2025-03-08 10:37:41");
INSERT INTO ventas VALUES("207","32","1","96","R","0.50","40.00","9","80","0.00","2025-03-08 10:37:41");
INSERT INTO ventas VALUES("208","32","1","18","R","0.50","40.00","9","80","0.00","2025-03-08 10:37:41");
INSERT INTO ventas VALUES("209","25","1","33","alex","1.00","70.00","4","70","0.25","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("210","25","1","45","lili ","0.25","17.00","4","70","0.06","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("211","25","1","59","lili ","0.25","17.00","4","70","0.06","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("212","25","1","91","lili ","0.25","17.00","4","70","0.06","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("213","25","1","36","lili ","0.25","17.00","4","70","0.06","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("214","25","1","2","lili ","0.25","17.00","4","70","0.06","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("215","25","1","97","lili ","0.25","17.00","4","70","0.06","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("216","25","1","2","estefani ","1.00","70.00","4","70","0.25","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("217","25","1","20","estefani ","1.00","70.00","4","70","0.25","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("218","25","1","NULL","estefani ","0.50","35.00","4","70","0.13","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("219","25","1","22","estefani ","0.50","35.00","4","70","0.13","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("220","25","1","79","estefani ","0.50","35.00","4","70","0.13","2025-03-08 10:37:56");
INSERT INTO ventas VALUES("221","13","1","9","X","0.25","17.00","10","70","0.06","2025-03-08 10:39:26");
INSERT INTO ventas VALUES("222","13","1","2","X","0.25","17.00","10","70","0.06","2025-03-08 10:39:26");
INSERT INTO ventas VALUES("223","13","1","79","X","0.25","17.00","10","70","0.06","2025-03-08 10:39:26");
INSERT INTO ventas VALUES("224","13","1","70","X","0.25","17.00","10","70","0.06","2025-03-08 10:39:26");
INSERT INTO ventas VALUES("225","13","1","96","X","0.25","17.00","10","70","0.06","2025-03-08 10:39:26");
INSERT INTO ventas VALUES("226","13","1","47","X","0.25","17.00","10","70","0.06","2025-03-08 10:39:26");
INSERT INTO ventas VALUES("227","13","1","18","X","0.25","17.00","10","70","0.06","2025-03-08 10:39:26");
INSERT INTO ventas VALUES("228","13","1","9","X","0.50","35.00","10","70","0.13","2025-03-08 10:39:52");
INSERT INTO ventas VALUES("229","13","1","18","X","0.50","35.00","10","70","0.13","2025-03-08 10:39:52");
INSERT INTO ventas VALUES("230","13","1","2","X","0.75","55.00","10","70","0.19","2025-03-08 10:40:56");
INSERT INTO ventas VALUES("231","9","1","18","J","1.00","70.00","10","70","0.25","2025-03-08 10:42:26");
INSERT INTO ventas VALUES("232","9","1","65","J","1.00","70.00","10","70","0.25","2025-03-08 10:42:26");
INSERT INTO ventas VALUES("233","9","1","56","J","1.00","70.00","10","70","0.25","2025-03-08 10:42:26");
INSERT INTO ventas VALUES("234","9","1","23","J","10.00","700.00","10","70","2.50","2025-03-08 10:42:26");
INSERT INTO ventas VALUES("235","32","1","9","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("236","32","1","8","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("237","32","1","76","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("238","32","1","67","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("239","32","1","36","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("240","32","1","63","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("241","32","1","88","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("242","32","1","11","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("243","32","1","96","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("244","32","1","3","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("245","32","1","30","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("246","32","1","54","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("247","32","1","66","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("248","32","1","99","N","0.25","20.00","10","80","0.00","2025-03-08 10:44:52");
INSERT INTO ventas VALUES("249","9","1","14","C ","2.00","140.00","10","70","0.50","2025-03-08 10:44:53");
INSERT INTO ventas VALUES("250","9","1","15","C ","2.00","140.00","10","70","0.50","2025-03-08 10:44:53");
INSERT INTO ventas VALUES("251","13","1","3","X","2.00","140.00","10","70","0.50","2025-03-08 10:44:59");
INSERT INTO ventas VALUES("252","13","1","87","X","2.00","140.00","10","70","0.50","2025-03-08 10:44:59");
INSERT INTO ventas VALUES("253","13","1","95","X","2.00","140.00","10","70","0.50","2025-03-08 10:44:59");
INSERT INTO ventas VALUES("254","13","1","75","X","2.00","140.00","10","70","0.50","2025-03-08 10:44:59");
INSERT INTO ventas VALUES("255","32","1","8","G","0.25","20.00","10","80","0.00","2025-03-08 10:45:11");
INSERT INTO ventas VALUES("256","13","1","13","X","2.00","140.00","10","70","0.50","2025-03-08 10:45:14");
INSERT INTO ventas VALUES("257","9","1","28","C","0.25","17.00","10","70","0.06","2025-03-08 10:47:18");
INSERT INTO ventas VALUES("258","9","1","82","C","0.25","17.00","10","70","0.06","2025-03-08 10:47:18");
INSERT INTO ventas VALUES("259","9","1","9","C","0.25","17.00","10","70","0.06","2025-03-08 10:47:18");
INSERT INTO ventas VALUES("260","9","1","2","C","0.25","17.00","10","70","0.06","2025-03-08 10:47:18");
INSERT INTO ventas VALUES("261","9","1","45","C","0.25","17.00","10","70","0.06","2025-03-08 10:47:18");
INSERT INTO ventas VALUES("262","9","1","54","C","0.25","17.00","10","70","0.06","2025-03-08 10:47:18");
INSERT INTO ventas VALUES("263","13","1","75","X","0.25","17.00","10","70","0.06","2025-03-08 10:47:27");
INSERT INTO ventas VALUES("264","13","1","2","X","0.25","17.00","10","70","0.06","2025-03-08 10:47:27");
INSERT INTO ventas VALUES("265","13","1","87","X","0.25","17.00","10","70","0.06","2025-03-08 10:47:27");
INSERT INTO ventas VALUES("266","13","1","76","X","0.25","17.00","10","70","0.06","2025-03-08 10:47:27");
INSERT INTO ventas VALUES("267","9","1","93","C","0.25","17.00","10","70","0.06","2025-03-08 10:48:11");
INSERT INTO ventas VALUES("268","9","1","45","C","0.25","17.00","10","70","0.06","2025-03-08 10:48:11");
INSERT INTO ventas VALUES("269","9","1","28","C","0.25","17.00","10","70","0.06","2025-03-08 10:48:11");
INSERT INTO ventas VALUES("270","9","1","8","C","0.25","17.00","10","70","0.06","2025-03-08 10:48:11");
INSERT INTO ventas VALUES("271","32","1","78","L","0.50","40.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("272","32","1","87","L","0.50","40.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("273","32","1","NULL","L","0.50","40.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("274","32","1","47","L","0.50","40.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("275","32","1","4","L","0.25","20.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("276","32","1","40","L","0.25","20.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("277","32","1","74","L","0.25","20.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("278","32","1","37","L","0.25","20.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("279","32","1","28","L","0.25","20.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("280","32","1","82","L","0.25","20.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("281","32","1","25","L","0.25","20.00","10","80","0.00","2025-03-08 10:48:43");
INSERT INTO ventas VALUES("282","9","1","3","C","0.50","35.00","10","70","0.13","2025-03-08 10:49:17");
INSERT INTO ventas VALUES("283","9","1","30","C","0.50","35.00","10","70","0.13","2025-03-08 10:49:17");
INSERT INTO ventas VALUES("284","32","1","42","D","0.25","20.00","10","80","0.00","2025-03-08 10:49:28");
INSERT INTO ventas VALUES("285","32","1","31","D","0.25","20.00","10","80","0.00","2025-03-08 10:49:28");
INSERT INTO ventas VALUES("286","32","1","9","D","0.25","20.00","10","80","0.00","2025-03-08 10:49:28");
INSERT INTO ventas VALUES("287","32","1","80","D","0.25","20.00","10","80","0.00","2025-03-08 10:49:28");
INSERT INTO ventas VALUES("288","32","1","2","D","0.25","20.00","10","80","0.00","2025-03-08 10:49:28");
INSERT INTO ventas VALUES("293","32","1","18","A","0.50","40.00","10","80","0.00","2025-03-08 10:50:46");
INSERT INTO ventas VALUES("294","32","1","8","A","0.50","40.00","10","80","0.00","2025-03-08 10:50:46");
INSERT INTO ventas VALUES("295","32","1","2","A","0.50","40.00","10","80","0.00","2025-03-08 10:50:46");
INSERT INTO ventas VALUES("296","32","1","19","A","0.50","40.00","10","80","0.00","2025-03-08 10:50:46");
INSERT INTO ventas VALUES("297","32","1","7","A","0.50","40.00","10","80","0.00","2025-03-08 10:50:46");
INSERT INTO ventas VALUES("298","32","1","4","A","0.50","40.00","10","80","0.00","2025-03-08 10:50:46");
INSERT INTO ventas VALUES("301","9","1","14","C","0.50","35.00","10","70","0.13","2025-03-08 10:51:27");
INSERT INTO ventas VALUES("302","9","1","54","C","0.50","35.00","10","70","0.13","2025-03-08 10:51:27");
INSERT INTO ventas VALUES("303","9","1","2","C","0.50","35.00","10","70","0.13","2025-03-08 10:51:27");
INSERT INTO ventas VALUES("304","32","1","NULL","E","0.50","40.00","10","80","0.00","2025-03-08 10:51:33");
INSERT INTO ventas VALUES("305","32","1","38","E","0.50","40.00","10","80","0.00","2025-03-08 10:51:33");
INSERT INTO ventas VALUES("306","32","1","88","E","0.50","40.00","10","80","0.00","2025-03-08 10:51:33");
INSERT INTO ventas VALUES("307","32","1","36","E","0.50","40.00","10","80","0.00","2025-03-08 10:51:33");
INSERT INTO ventas VALUES("308","13","1","2","X","0.25","17.00","10","70","0.06","2025-03-08 10:51:50");
INSERT INTO ventas VALUES("309","32","1","13","V","5.00","400.00","10","80","0.00","2025-03-08 10:53:17");
INSERT INTO ventas VALUES("310","32","1","99","V","1.00","80.00","10","80","0.00","2025-03-08 10:53:17");
INSERT INTO ventas VALUES("311","32","1","96","V","1.00","80.00","10","80","0.00","2025-03-08 10:53:17");
INSERT INTO ventas VALUES("312","32","1","18","V","1.00","80.00","10","80","0.00","2025-03-08 10:53:17");
INSERT INTO ventas VALUES("313","32","1","88","V","1.00","80.00","10","80","0.00","2025-03-08 10:53:17");
INSERT INTO ventas VALUES("314","32","1","NULL","V","1.00","80.00","10","80","0.00","2025-03-08 10:53:17");
INSERT INTO ventas VALUES("315","32","1","14","V","1.00","80.00","10","80","0.00","2025-03-08 10:54:08");
INSERT INTO ventas VALUES("316","32","1","9","V","0.50","40.00","10","80","0.00","2025-03-08 10:54:08");
INSERT INTO ventas VALUES("317","32","1","3","V","0.50","40.00","10","80","0.00","2025-03-08 10:54:08");
INSERT INTO ventas VALUES("318","32","1","66","V","0.50","40.00","10","80","0.00","2025-03-08 10:54:08");
INSERT INTO ventas VALUES("319","11","1","69","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("320","11","1","96","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("321","11","1","28","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("322","11","1","82","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("323","11","1","18","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("324","11","1","81","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("325","11","1","2","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("326","11","1","2","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("327","11","1","79","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("328","11","1","3","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("329","11","1","33","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("330","11","1","3","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("331","11","1","20","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("332","11","1","13","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("333","11","1","76","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("334","11","1","18","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("335","11","1","11","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("336","11","1","96","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("337","11","1","2","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("338","11","1","20","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("339","11","1","61","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("340","11","1","14","Q","4.00","280.00","3","70","1.00","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("341","11","1","1","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("342","11","1","88","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("343","11","1","8","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("344","11","1","2","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("345","11","1","10","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("346","11","1","11","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("347","11","1","96","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("348","11","1","99","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("349","11","1","3","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("350","11","1","15","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("351","11","1","2","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("352","11","1","6","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("353","11","1","15","Q","1.00","70.00","3","70","0.25","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("354","11","1","3","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("355","11","1","31","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("356","11","1","8","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("357","11","1","80","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("358","11","1","30","Q","2.50","175.00","3","70","0.63","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("359","11","1","66","Q","2.50","175.00","3","70","0.63","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("360","11","1","75","Q","0.75","55.00","3","70","0.19","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("361","11","1","59","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("362","11","1","95","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("363","11","1","2","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("364","11","1","91","Q","1.00","70.00","3","70","0.25","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("365","11","1","96","Q","1.00","70.00","3","70","0.25","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("366","11","1","14","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("367","11","1","3","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("368","11","1","36","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("369","11","1","97","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("370","11","1","3","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("371","11","1","8","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("372","11","1","88","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("373","11","1","15","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("374","11","1","3","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("375","11","1","96","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("376","11","1","96","Q","1.00","70.00","3","70","0.25","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("377","11","1","86","Q","0.75","55.00","3","70","0.19","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("378","11","1","68","Q","0.75","55.00","3","70","0.19","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("379","11","1","10","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("380","11","1","1","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("381","11","1","51","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("382","11","1","66","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("383","11","1","75","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("384","11","1","23","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("385","11","1","15","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("386","11","1","65","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("387","11","1","87","Q","1.00","70.00","3","70","0.25","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("388","11","1","22","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("389","11","1","32","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("390","11","1","55","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("391","11","1","98","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("392","11","1","93","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("393","11","1","13","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("394","11","1","13","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("395","11","1","21","Q","0.75","55.00","3","70","0.19","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("396","11","1","61","Q","0.50","35.00","3","70","0.13","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("397","11","1","14","Q","2.00","140.00","3","70","0.50","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("398","11","1","18","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("399","11","1","81","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("400","11","1","15","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("401","11","1","51","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("402","11","1","13","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("403","11","1","18","Q","0.25","17.00","3","70","0.06","2025-03-08 10:54:09");
INSERT INTO ventas VALUES("404","11","1","3","R","0.50","35.00","4","70","0.13","2025-03-08 10:54:59");
INSERT INTO ventas VALUES("405","32","2","NULL","8","1.00","80.00","1","80","0.00","2025-03-08 11:19:57");
INSERT INTO ventas VALUES("406","32","2","9","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("407","32","2","8","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("408","32","2","76","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("409","32","2","67","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("410","32","2","36","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("411","32","2","63","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("412","32","2","88","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("413","32","2","11","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("414","32","2","96","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("415","32","2","3","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("416","32","2","30","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("417","32","2","54","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("418","32","2","66","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("419","32","2","99","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("420","32","2","47","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("421","32","2","46","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("422","32","2","97","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("423","32","2","84","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("424","32","2","48","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("425","32","2","2","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("426","32","2","20","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("427","32","2","80","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("428","32","2","69","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("429","32","2","54","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("430","32","2","45","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("431","32","2","16","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("432","32","2","18","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("433","32","2","14","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("434","32","2","79","Abu","0.25","20.00","2","80","0.00","2025-03-08 12:00:32");
INSERT INTO ventas VALUES("435","32","2","1","Abu","0.25","20.00","3","80","0.00","2025-03-08 12:02:29");
INSERT INTO ventas VALUES("436","32","2","10","Abu","0.25","20.00","3","80","0.00","2025-03-08 12:02:29");
INSERT INTO ventas VALUES("437","32","2","96","J","1.00","80.00","4","80","0.00","2025-03-08 13:01:52");
INSERT INTO ventas VALUES("438","32","2","3","J","0.25","20.00","4","80","0.00","2025-03-08 13:01:52");
INSERT INTO ventas VALUES("439","32","2","30","J","0.25","20.00","4","80","0.00","2025-03-08 13:01:52");
INSERT INTO ventas VALUES("440","32","2","88","J","0.25","20.00","4","80","0.00","2025-03-08 13:01:52");
INSERT INTO ventas VALUES("441","32","2","17","J","0.25","20.00","4","80","0.00","2025-03-08 13:01:52");
INSERT INTO ventas VALUES("442","32","2","21","I","1.50","120.00","5","80","0.00","2025-03-08 13:47:33");
INSERT INTO ventas VALUES("443","32","2","21","I","0.50","40.00","6","80","0.00","2025-03-08 13:48:51");
INSERT INTO ventas VALUES("444","32","2","2","T","1.50","120.00","7","80","0.00","2025-03-08 14:02:33");
INSERT INTO ventas VALUES("445","32","2","13","L","1.00","80.00","8","80","0.00","2025-03-08 14:10:45");
INSERT INTO ventas VALUES("446","32","2","70","L","1.00","80.00","8","80","0.00","2025-03-08 14:10:45");
INSERT INTO ventas VALUES("447","32","2","3","N","0.50","40.00","9","80","0.00","2025-03-08 14:18:51");
INSERT INTO ventas VALUES("448","32","2","30","N","0.50","40.00","9","80","0.00","2025-03-08 14:18:51");
INSERT INTO ventas VALUES("449","32","2","96","N","0.50","40.00","9","80","0.00","2025-03-08 14:18:51");
INSERT INTO ventas VALUES("450","32","2","97","N","0.50","40.00","9","80","0.00","2025-03-08 14:18:51");
INSERT INTO ventas VALUES("451","32","2","16","N","0.50","40.00","9","80","0.00","2025-03-08 14:18:51");
INSERT INTO ventas VALUES("452","32","2","18","N","0.50","40.00","9","80","0.00","2025-03-08 14:18:51");
INSERT INTO ventas VALUES("453","9","2","50","X","1.00","70.00","1","70","0.25","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("454","9","2","42","X","0.25","17.00","1","70","0.06","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("455","9","2","2","X","0.25","17.00","1","70","0.06","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("456","9","2","15","X","0.25","17.00","1","70","0.06","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("457","9","2","79","X","0.25","17.00","1","70","0.06","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("458","9","2","88","X","0.25","17.00","1","70","0.06","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("459","9","2","64","X","1.00","70.00","1","70","0.25","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("460","9","2","46","X","1.00","70.00","1","70","0.25","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("461","9","2","68","X","1.00","70.00","1","70","0.25","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("462","9","2","86","X","1.00","70.00","1","70","0.25","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("463","9","2","2","X","0.25","17.00","1","70","0.06","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("464","9","2","8","X","0.25","17.00","1","70","0.06","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("465","9","2","3","X","2.50","175.00","1","70","0.63","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("466","9","2","4","X","0.25","17.00","1","70","0.06","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("467","9","2","6","X","0.25","17.00","1","70","0.06","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("468","9","2","29","X","0.50","35.00","1","70","0.13","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("469","9","2","92","X","0.50","35.00","1","70","0.13","2025-03-08 14:20:17");
INSERT INTO ventas VALUES("470","32","2","13","A","5.00","400.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("471","32","2","99","A","1.00","80.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("472","32","2","96","A","1.00","80.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("473","32","2","18","A","1.00","80.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("474","32","2","88","A","1.00","80.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("475","32","2","NULL","A","1.00","80.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("476","32","2","14","A","1.00","80.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("477","32","2","9","A","1.00","80.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("478","32","2","3","A","1.00","80.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("479","32","2","66","A","1.00","80.00","10","80","0.00","2025-03-08 14:21:04");
INSERT INTO ventas VALUES("480","32","2","11","N","1.00","80.00","10","80","0.00","2025-03-08 14:21:54");
INSERT INTO ventas VALUES("481","32","2","99","N","1.00","80.00","10","80","0.00","2025-03-08 14:21:54");
INSERT INTO ventas VALUES("482","32","2","9","N","0.50","40.00","10","80","0.00","2025-03-08 14:21:54");
INSERT INTO ventas VALUES("483","32","2","20","N","0.50","40.00","10","80","0.00","2025-03-08 14:21:54");
INSERT INTO ventas VALUES("484","9","2","8","C","0.50","35.00","2","70","0.13","2025-03-08 14:25:01");
INSERT INTO ventas VALUES("485","9","2","80","C","0.50","35.00","2","70","0.13","2025-03-08 14:25:01");
INSERT INTO ventas VALUES("486","32","2","1","V","0.50","40.00","10","80","0.00","2025-03-08 14:26:46");
INSERT INTO ventas VALUES("487","32","2","10","V","0.50","40.00","10","80","0.00","2025-03-08 14:26:46");
INSERT INTO ventas VALUES("488","9","2","14","C","0.50","35.00","3","70","0.13","2025-03-08 14:27:36");
INSERT INTO ventas VALUES("489","9","2","2","C","0.50","35.00","3","70","0.13","2025-03-08 14:27:36");
INSERT INTO ventas VALUES("490","9","2","2","C","1.00","70.00","3","70","0.25","2025-03-08 14:27:36");
INSERT INTO ventas VALUES("491","9","2","94","C","1.00","70.00","3","70","0.25","2025-03-08 14:27:36");
INSERT INTO ventas VALUES("492","9","2","96","C","0.75","55.00","3","70","0.19","2025-03-08 14:27:36");
INSERT INTO ventas VALUES("493","9","2","16","C","0.75","55.00","3","70","0.19","2025-03-08 14:27:36");
INSERT INTO ventas VALUES("494","9","2","18","C","0.50","35.00","3","70","0.13","2025-03-08 14:27:36");
INSERT INTO ventas VALUES("495","9","2","53","C","0.25","17.00","3","70","0.06","2025-03-08 14:27:36");
INSERT INTO ventas VALUES("496","9","2","94","C","0.25","17.00","3","70","0.06","2025-03-08 14:27:36");
INSERT INTO ventas VALUES("497","9","2","2","D","0.50","35.00","4","70","0.13","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("498","9","2","75","D","0.50","35.00","4","70","0.13","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("499","9","2","14","D","0.50","35.00","4","70","0.13","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("500","9","2","41","D","0.50","35.00","4","70","0.13","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("501","9","2","8","D","0.50","35.00","4","70","0.13","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("502","9","2","80","D","0.50","35.00","4","70","0.13","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("503","9","2","29","D","0.50","35.00","4","70","0.13","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("504","9","2","92","D","0.50","35.00","4","70","0.13","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("505","9","2","3","D","0.75","55.00","4","70","0.19","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("506","9","2","14","D","0.75","55.00","4","70","0.19","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("507","9","2","33","D","0.25","17.00","4","70","0.06","2025-03-08 14:30:36");
INSERT INTO ventas VALUES("508","9","2","21","C","0.50","35.00","5","70","0.13","2025-03-08 14:32:16");
INSERT INTO ventas VALUES("509","9","2","6","C","0.50","35.00","5","70","0.13","2025-03-08 14:32:16");
INSERT INTO ventas VALUES("510","10","2","18","Mauricio ","1.00","80.00","1","80","0.15","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("511","10","2","21","Mauricio ","1.00","80.00","1","80","0.15","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("512","10","2","14","Mauricio ","1.00","80.00","1","80","0.15","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("513","10","2","96","Mauricio ","1.00","80.00","1","80","0.15","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("514","10","2","2","Mauricio ","1.00","80.00","1","80","0.15","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("515","10","2","3","Mauricio ","0.75","60.00","1","80","0.11","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("516","10","2","45","Mauricio ","1.50","120.00","1","80","0.23","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("517","10","2","20","Mauricio ","0.25","20.00","1","80","0.04","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("518","10","2","12","Mauricio ","0.25","20.00","1","80","0.04","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("519","10","2","30","Mauricio ","0.25","20.00","1","80","0.04","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("520","10","2","69","Mauricio ","0.25","20.00","1","80","0.04","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("521","10","2","41","Mauricio ","0.25","20.00","1","80","0.04","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("522","10","2","54","Mauricio ","0.25","20.00","1","80","0.04","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("523","10","2","81","Mauricio ","0.25","20.00","1","80","0.04","2025-03-08 14:34:23");
INSERT INTO ventas VALUES("524","9","2","9","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("525","9","2","88","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("526","9","2","11","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("527","9","2","49","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("528","9","2","61","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("529","9","2","50","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("530","9","2","3","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("531","9","2","33","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("532","9","2","23","C","0.50","35.00","6","70","0.13","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("533","9","2","22","C","0.50","35.00","6","70","0.13","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("534","9","2","55","C","0.50","35.00","6","70","0.13","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("535","9","2","99","C","0.50","35.00","6","70","0.13","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("536","9","2","8","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("537","9","2","80","C","0.25","17.00","6","70","0.06","2025-03-08 14:36:32");
INSERT INTO ventas VALUES("538","13","2","77","X","0.25","17.00","1","70","0.06","2025-03-08 14:40:15");
INSERT INTO ventas VALUES("539","13","2","2","X","0.25","17.00","1","70","0.06","2025-03-08 14:40:15");
INSERT INTO ventas VALUES("540","13","2","40","X","0.25","17.00","1","70","0.06","2025-03-08 14:40:15");
INSERT INTO ventas VALUES("541","13","2","15","X","0.25","17.00","2","70","0.06","2025-03-08 14:40:57");
INSERT INTO ventas VALUES("542","13","2","20","X","0.25","17.00","2","70","0.06","2025-03-08 14:40:57");
INSERT INTO ventas VALUES("543","32","2","94","T","1.00","80.00","10","80","0.00","2025-03-08 14:41:00");
INSERT INTO ventas VALUES("544","32","2","93","T","1.00","80.00","10","80","0.00","2025-03-08 14:41:00");
INSERT INTO ventas VALUES("545","32","2","97","Caro","0.50","40.00","10","80","0.00","2025-03-08 14:41:46");
INSERT INTO ventas VALUES("546","13","2","3","X","2.00","140.00","3","70","0.50","2025-03-08 14:42:23");
INSERT INTO ventas VALUES("547","13","2","87","X","2.00","140.00","3","70","0.50","2025-03-08 14:42:23");
INSERT INTO ventas VALUES("548","13","2","95","X","2.00","140.00","3","70","0.50","2025-03-08 14:42:23");
INSERT INTO ventas VALUES("549","13","2","75","X","2.00","140.00","3","70","0.50","2025-03-08 14:42:23");
INSERT INTO ventas VALUES("550","13","2","13","X","2.00","140.00","3","70","0.50","2025-03-08 14:42:23");
INSERT INTO ventas VALUES("551","32","2","15","Taxi","5.00","400.00","10","80","0.00","2025-03-08 14:42:46");
INSERT INTO ventas VALUES("552","32","2","3","Taxi","3.00","240.00","10","80","0.00","2025-03-08 14:42:46");
INSERT INTO ventas VALUES("553","32","2","18","Taxi","3.00","240.00","10","80","0.00","2025-03-08 14:42:46");
INSERT INTO ventas VALUES("554","32","2","21","Taxi","3.00","240.00","10","80","0.00","2025-03-08 14:42:46");
INSERT INTO ventas VALUES("555","32","2","23","Taxi","3.00","240.00","10","80","0.00","2025-03-08 14:42:46");
INSERT INTO ventas VALUES("556","32","2","14","Taxi","3.00","240.00","10","80","0.00","2025-03-08 14:42:46");
INSERT INTO ventas VALUES("557","9","2","55","M","3.00","210.00","7","70","0.75","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("558","9","2","21","M","1.50","105.00","7","70","0.38","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("559","9","2","67","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("560","9","2","34","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("561","9","2","77","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("562","9","2","29","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("563","9","2","53","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("564","9","2","18","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("565","9","2","87","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("566","9","2","82","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("567","9","2","88","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("568","9","2","14","M","1.00","70.00","7","70","0.25","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("569","9","2","10","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("570","9","2","50","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("571","9","2","94","M","0.75","55.00","7","70","0.19","2025-03-08 14:43:14");
INSERT INTO ventas VALUES("572","9","2","97","S","0.50","35.00","8","70","0.13","2025-03-08 14:43:46");
INSERT INTO ventas VALUES("573","9","2","48","S","0.50","35.00","8","70","0.13","2025-03-08 14:43:46");
INSERT INTO ventas VALUES("574","9","2","3","N","0.50","35.00","9","70","0.13","2025-03-08 14:50:10");
INSERT INTO ventas VALUES("575","9","2","14","N","0.25","17.00","9","70","0.06","2025-03-08 14:50:10");
INSERT INTO ventas VALUES("576","9","2","60","N","0.25","17.00","9","70","0.06","2025-03-08 14:50:10");
INSERT INTO ventas VALUES("577","9","2","28","C","0.75","55.00","10","70","0.19","2025-03-08 14:51:15");
INSERT INTO ventas VALUES("578","9","2","44","C","0.75","55.00","10","70","0.19","2025-03-08 14:51:15");
INSERT INTO ventas VALUES("579","9","2","28","C","0.50","35.00","10","70","0.13","2025-03-08 14:51:15");
INSERT INTO ventas VALUES("580","9","2","88","C","0.25","17.00","10","70","0.06","2025-03-08 14:51:15");
INSERT INTO ventas VALUES("581","9","2","28","C","0.25","17.00","10","70","0.06","2025-03-08 14:51:15");
INSERT INTO ventas VALUES("582","9","2","2","C","0.25","17.00","10","70","0.06","2025-03-08 14:51:15");
INSERT INTO ventas VALUES("583","32","2","3","G","0.25","20.00","10","80","0.00","2025-03-08 14:51:31");
INSERT INTO ventas VALUES("584","32","3","NULL","H","1.00","80.00","1","80","0.00","2025-03-08 15:08:26");
INSERT INTO ventas VALUES("585","32","3","93","R","1.00","80.00","2","80","0.00","2025-03-08 15:08:51");
INSERT INTO ventas VALUES("586","32","3","94","R","1.00","80.00","2","80","0.00","2025-03-08 15:08:51");
INSERT INTO ventas VALUES("587","9","3","62","María ","0.25","17.00","1","70","0.06","2025-03-08 17:21:49");
INSERT INTO ventas VALUES("588","1","3","17","Jose lemus pineda","30.00","2400.00","1","80","4.50","2025-03-08 19:32:32");
INSERT INTO ventas VALUES("589","10","3","5","Marily 1","1.00","80.00","1","80","0.15","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("590","10","3","50","Marily 1","0.50","40.00","1","80","0.08","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("591","10","3","55","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("592","10","3","15","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("593","10","3","51","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("594","10","3","22","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("595","10","3","1","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("596","10","3","10","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("597","10","3","14","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("598","10","3","4","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("599","10","3","40","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("600","10","3","24","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("601","10","3","88","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("602","10","3","92","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("603","10","3","42","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("604","10","3","36","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("605","10","3","63","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("606","10","3","37","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("607","10","3","73","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("608","10","3","35","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("609","10","3","53","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("610","10","3","37","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("611","10","3","80","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("612","10","3","66","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("613","10","3","29","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("614","10","3","8","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("615","10","3","58","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("616","10","3","85","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("617","10","3","42","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("618","10","3","24","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("619","10","3","32","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("620","10","3","23","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("621","10","3","63","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("622","10","3","77","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("623","10","3","26","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("624","10","3","40","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("625","10","3","21","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("626","10","3","61","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("627","10","3","48","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("628","10","3","84","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("629","10","3","71","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("630","10","3","17","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("631","10","3","62","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("632","10","3","26","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("633","10","3","97","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("634","10","3","79","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("635","10","3","5","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("636","10","3","4","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("637","10","3","12","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("638","10","3","18","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("639","10","3","81","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("640","10","3","11","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("641","10","3","NULL","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("642","10","3","78","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("643","10","3","87","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("644","10","3","55","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("645","10","3","22","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("646","10","3","12","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("647","10","3","21","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("648","10","3","71","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("649","10","3","47","Marily 1","0.25","20.00","1","80","0.04","2025-03-08 20:19:01");
INSERT INTO ventas VALUES("650","32","3","13","A","5.00","400.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("651","32","3","99","A","1.00","80.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("652","32","3","96","A","1.00","80.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("653","32","3","18","A","1.00","80.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("654","32","3","NULL","A","1.00","80.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("655","32","3","14","A","1.00","80.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("656","32","3","9","A","1.00","80.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("657","32","3","3","A","1.00","80.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("658","32","3","66","A","1.00","80.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("659","32","3","88","A","1.00","80.00","3","80","0.00","2025-03-08 20:29:37");
INSERT INTO ventas VALUES("660","32","3","13","J","1.00","80.00","4","80","0.00","2025-03-08 20:31:05");
INSERT INTO ventas VALUES("661","32","3","31","J","1.00","80.00","4","80","0.00","2025-03-08 20:31:05");
INSERT INTO ventas VALUES("662","32","3","78","V","0.25","20.00","5","80","0.00","2025-03-08 20:31:41");
INSERT INTO ventas VALUES("663","32","3","87","V","0.25","20.00","5","80","0.00","2025-03-08 20:31:41");
INSERT INTO ventas VALUES("664","32","3","27","V","0.25","20.00","5","80","0.00","2025-03-08 20:31:41");
INSERT INTO ventas VALUES("665","32","3","72","V","0.25","20.00","5","80","0.00","2025-03-08 20:31:41");
INSERT INTO ventas VALUES("666","32","3","11","G","0.25","20.00","6","80","0.00","2025-03-08 20:33:10");
INSERT INTO ventas VALUES("667","32","3","15","G","0.25","20.00","6","80","0.00","2025-03-08 20:33:10");
INSERT INTO ventas VALUES("668","32","3","14","G","0.25","20.00","6","80","0.00","2025-03-08 20:33:10");
INSERT INTO ventas VALUES("669","32","3","96","G","0.25","20.00","6","80","0.00","2025-03-08 20:33:10");
INSERT INTO ventas VALUES("670","32","3","30","G","0.25","20.00","6","80","0.00","2025-03-08 20:33:10");
INSERT INTO ventas VALUES("671","32","3","3","G","0.25","20.00","6","80","0.00","2025-03-08 20:33:10");
INSERT INTO ventas VALUES("672","32","3","33","G","0.25","20.00","6","80","0.00","2025-03-08 20:33:10");
INSERT INTO ventas VALUES("673","32","3","88","G","0.25","20.00","6","80","0.00","2025-03-08 20:33:10");
INSERT INTO ventas VALUES("674","25","3","96","ropa","5.00","350.00","1","70","1.25","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("675","25","3","14","hna","2.00","140.00","1","70","0.50","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("676","25","3","96","hna","0.50","35.00","1","70","0.13","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("677","25","3","71","hna","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("678","25","3","23","hna","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("679","25","3","2","relojes ","0.50","35.00","1","70","0.13","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("680","25","3","96","relojes ","1.00","70.00","1","70","0.25","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("681","25","3","55","relojes ","1.00","70.00","1","70","0.25","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("682","25","3","2","chele","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("683","25","3","94","chele","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("684","25","3","53","chele","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("685","25","3","43","tere","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("686","25","3","13","tere","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("687","25","3","2","tere","0.50","35.00","1","70","0.13","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("688","25","3","34","tere","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("689","25","3","98","tere","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("690","25","3","2","vigilante","1.00","70.00","1","70","0.25","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("691","25","3","50","vigilante","1.00","70.00","1","70","0.25","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("692","25","3","8","vigilante","0.50","35.00","1","70","0.13","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("693","25","3","32","vigilante","0.50","35.00","1","70","0.13","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("694","25","3","80","vigilante","0.25","17.00","1","70","0.06","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("695","25","3","14","hna","1.00","70.00","1","70","0.25","2025-03-08 20:35:26");
INSERT INTO ventas VALUES("696","25","3","19","carmen ","1.00","70.00","2","70","0.25","2025-03-08 20:37:51");
INSERT INTO ventas VALUES("697","25","3","91","carmen ","1.00","70.00","2","70","0.25","2025-03-08 20:37:51");
INSERT INTO ventas VALUES("698","25","3","54","carmen ","2.00","140.00","2","70","0.50","2025-03-08 20:37:51");
INSERT INTO ventas VALUES("699","25","3","45","carmen ","2.00","140.00","2","70","0.50","2025-03-08 20:37:51");
INSERT INTO ventas VALUES("700","25","3","5","Andrea ","0.50","35.00","3","70","0.13","2025-03-08 20:39:13");
INSERT INTO ventas VALUES("701","25","3","NULL","Andrea ","0.25","17.00","3","70","0.06","2025-03-08 20:39:13");
INSERT INTO ventas VALUES("702","25","3","50","Andrea ","0.50","35.00","3","70","0.13","2025-03-08 20:39:13");
INSERT INTO ventas VALUES("703","25","3","96","enrrique ","1.00","70.00","4","70","0.25","2025-03-08 20:40:55");
INSERT INTO ventas VALUES("704","25","3","2","enrrique ","0.50","35.00","4","70","0.13","2025-03-08 20:40:55");
INSERT INTO ventas VALUES("705","25","3","45","enrrique ","0.50","35.00","4","70","0.13","2025-03-08 20:40:55");
INSERT INTO ventas VALUES("706","25","3","75","enrrique ","0.50","35.00","4","70","0.13","2025-03-08 20:40:55");
INSERT INTO ventas VALUES("707","25","3","47","enrrique ","1.00","70.00","4","70","0.25","2025-03-08 20:40:55");
INSERT INTO ventas VALUES("708","25","3","49","enrrique ","1.00","70.00","4","70","0.25","2025-03-08 20:40:55");
INSERT INTO ventas VALUES("709","25","3","92","enrrique ","1.00","70.00","5","70","0.25","2025-03-08 20:46:02");
INSERT INTO ventas VALUES("710","25","3","14","c","0.25","17.00","5","70","0.06","2025-03-08 20:46:02");
INSERT INTO ventas VALUES("711","25","3","75","c","0.25","17.00","5","70","0.06","2025-03-08 20:46:02");
INSERT INTO ventas VALUES("712","25","3","47","c","0.25","17.00","5","70","0.06","2025-03-08 20:46:02");
INSERT INTO ventas VALUES("713","9","3","2","C","0.50","35.00","2","70","0.13","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("714","9","3","20","C","0.50","35.00","2","70","0.13","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("715","9","3","14","C","0.50","35.00","2","70","0.13","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("716","9","3","45","C","0.50","35.00","2","70","0.13","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("717","9","3","56","C","0.50","35.00","2","70","0.13","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("718","9","3","50","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("719","9","3","2","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("720","9","3","11","C","0.25","17.00","2","70","0.06","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("721","9","3","21","C","0.25","17.00","2","70","0.06","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("722","9","3","11","C","0.25","17.00","2","70","0.06","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("723","9","3","21","C","0.25","17.00","2","70","0.06","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("724","9","3","18","C","0.25","17.00","2","70","0.06","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("725","9","3","2","C","0.25","17.00","2","70","0.06","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("726","9","3","36","C","0.25","17.00","2","70","0.06","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("727","9","3","10","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("728","9","3","11","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("729","9","3","12","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("730","9","3","13","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("731","9","3","14","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("732","9","3","15","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("733","9","3","16","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("734","9","3","17","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("735","9","3","18","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("736","9","3","19","C","1.00","70.00","2","70","0.25","2025-03-08 20:48:52");
INSERT INTO ventas VALUES("737","9","3","1","C","0.50","35.00","3","70","0.13","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("738","9","3","10","C","1.00","70.00","3","70","0.25","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("739","9","3","64","C","1.00","70.00","3","70","0.25","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("740","9","3","46","C","1.00","70.00","3","70","0.25","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("741","9","3","68","C","0.50","35.00","3","70","0.13","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("742","9","3","86","C","0.50","35.00","3","70","0.13","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("743","9","3","2","C","0.25","17.00","3","70","0.06","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("744","9","3","20","C","0.25","17.00","3","70","0.06","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("745","9","3","8","C","0.25","17.00","3","70","0.06","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("746","9","3","3","C","1.00","70.00","3","70","0.25","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("747","9","3","55","C","0.50","35.00","3","70","0.13","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("748","9","3","22","C","0.50","35.00","3","70","0.13","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("749","9","3","2","C","1.00","70.00","3","70","0.25","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("750","9","3","94","C","1.00","70.00","3","70","0.25","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("751","9","3","91","C","0.50","35.00","3","70","0.13","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("752","9","3","18","C","0.25","17.00","3","70","0.06","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("753","9","3","81","C","0.25","17.00","3","70","0.06","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("754","9","3","99","C","0.25","17.00","3","70","0.06","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("755","9","3","13","C","1.00","70.00","3","70","0.25","2025-03-08 20:51:04");
INSERT INTO ventas VALUES("756","19","3","9","Julio","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("757","19","3","14","Julio","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("758","19","3","75","Marta ","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("759","19","3","3","Marina ","6.00","480.00","1","80","0.90","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("760","19","3","30","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("761","19","3","94","Marina ","2.00","160.00","1","80","0.30","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("762","19","3","9","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("763","19","3","90","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("764","19","3","99","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("765","19","3","66","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("766","19","3","96","Marina ","2.50","200.00","1","80","0.38","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("767","19","3","32","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("768","19","3","23","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("769","19","3","95","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("770","19","3","59","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("771","19","3","29","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("772","19","3","92","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("773","19","3","98","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("774","19","3","97","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("775","19","3","79","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("776","19","3","91","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("777","19","3","19","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("778","19","3","93","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("779","19","3","39","Marina ","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("780","19","3","2","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("781","19","3","20","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("782","19","3","14","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("783","19","3","1","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("784","19","3","10","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("785","19","3","17","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("786","19","3","71","Marina ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("787","19","3","5","Pan","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("788","19","3","50","Pan","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("789","19","3","51","Pan","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("790","19","3","28","Pan","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("791","19","3","3","Tortilla ","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("792","19","3","2","Tortilla ","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("793","19","3","3","Tortilla ","3.00","240.00","1","80","0.45","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("794","19","3","94","Tortilla ","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("795","19","3","22","Tortilla ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("796","19","3","28","Campo","2.00","160.00","1","80","0.30","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("797","19","3","67","Francisco ","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("798","19","3","2","Sulma ","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("799","19","3","3","Rosita","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("800","19","3","30","Rosita","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("801","19","3","11","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("802","19","3","NULL","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("803","19","3","13","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("804","19","3","31","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("805","19","3","6","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("806","19","3","60","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("807","19","3","17","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("808","19","3","71","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("809","19","3","94","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("810","19","3","49","Rosita","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("811","19","3","18","Walter","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("812","19","3","49","Iris","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("813","19","3","3","Juan","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("814","19","3","4","Juan","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("815","19","3","66","Juan","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("816","19","3","99","Juan","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("817","19","3","45","Juan","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("818","19","3","53","Juan","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("819","19","3","2","Pana","2.00","160.00","1","80","0.30","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("820","19","3","75","Daniel","1.50","120.00","1","80","0.23","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("821","19","3","2","Daniel","0.75","60.00","1","80","0.11","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("822","19","3","14","Daniel","0.75","60.00","1","80","0.11","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("823","19","3","65","Marina","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("824","19","3","NULL","Edis","0.75","60.00","1","80","0.11","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("825","19","3","NULL","Edis","0.75","60.00","1","80","0.11","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("826","19","3","94","Edis","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("827","19","3","49","Edis","0.25","20.00","1","80","0.04","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("828","19","3","15","Karen","1.50","120.00","1","80","0.23","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("829","19","3","21","Karen","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("830","19","3","38","Karen","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("831","19","3","96","Karen","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("832","19","3","9","Karen","1.00","80.00","1","80","0.15","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("833","19","3","10","Karen","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("834","19","3","40","Daniel","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("835","19","3","50","Daniel","0.50","40.00","1","80","0.08","2025-03-08 20:51:11");
INSERT INTO ventas VALUES("836","25","3","29","dixy","1.00","70.00","6","70","0.25","2025-03-08 20:53:34");
INSERT INTO ventas VALUES("837","9","3","33","C","0.25","17.00","4","70","0.06","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("838","9","3","8","C","1.00","70.00","4","70","0.25","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("839","9","3","21","C","0.50","35.00","4","70","0.13","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("840","9","3","6","C","0.50","35.00","4","70","0.13","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("841","9","3","3","C","0.75","55.00","4","70","0.19","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("842","9","3","14","C","0.75","55.00","4","70","0.19","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("843","9","3","3","C","0.25","17.00","4","70","0.06","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("844","9","3","14","C","0.25","17.00","4","70","0.06","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("845","9","3","99","C","1.50","105.00","4","70","0.38","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("846","9","3","9","C","1.50","105.00","4","70","0.38","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("847","9","3","45","C","0.25","17.00","4","70","0.06","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("848","9","3","2","C","0.25","17.00","4","70","0.06","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("849","9","3","79","C","0.25","17.00","4","70","0.06","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("850","9","3","72","C","0.50","35.00","4","70","0.13","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("851","9","3","27","C","0.50","35.00","4","70","0.13","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("852","9","3","3","C","1.00","70.00","4","70","0.25","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("853","9","3","96","C","1.00","70.00","4","70","0.25","2025-03-08 20:54:17");
INSERT INTO ventas VALUES("854","19","3","30","Juan","0.50","40.00","2","80","0.08","2025-03-08 20:54:37");
INSERT INTO ventas VALUES("855","19","3","8","Juan","0.50","40.00","2","80","0.08","2025-03-08 20:54:37");
INSERT INTO ventas VALUES("856","9","3","14","C","0.25","17.00","5","70","0.06","2025-03-08 20:54:46");
INSERT INTO ventas VALUES("857","9","3","3","C","1.00","70.00","5","70","0.25","2025-03-08 20:54:46");
INSERT INTO ventas VALUES("858","9","3","62","C","1.00","70.00","5","70","0.25","2025-03-08 20:54:46");
INSERT INTO ventas VALUES("859","19","1","3","Iris ","2.00","160.00","4","80","0.30","2025-03-09 08:25:37");
INSERT INTO ventas VALUES("860","19","1","75","Marta","0.25","20.00","5","80","0.04","2025-03-09 08:26:40");
INSERT INTO ventas VALUES("861","19","1","2","Xioma","1.00","80.00","6","80","0.15","2025-03-09 08:28:08");
INSERT INTO ventas VALUES("862","19","1","86","Xioma","0.25","20.00","6","80","0.04","2025-03-09 08:28:08");
INSERT INTO ventas VALUES("863","19","1","74","Xioma","0.25","20.00","6","80","0.04","2025-03-09 08:28:08");
INSERT INTO ventas VALUES("872","9","1","94","C","1.00","70.00","10","70","0.25","2025-03-09 10:18:09");
INSERT INTO ventas VALUES("873","9","1","67","C","0.25","17.00","10","70","0.06","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("874","9","1","99","C","0.25","17.00","10","70","0.06","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("875","9","1","91","C","0.50","35.00","10","70","0.13","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("876","9","1","56","C","0.50","35.00","10","70","0.13","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("877","9","1","9","C","0.25","17.00","10","70","0.06","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("878","9","1","3","C","1.00","70.00","10","70","0.25","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("879","9","1","2","C","1.00","70.00","10","70","0.25","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("880","9","1","15","C","1.00","70.00","10","70","0.25","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("881","9","1","6","C","1.00","70.00","10","70","0.25","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("882","9","1","96","C","0.50","35.00","10","70","0.13","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("883","9","1","2","C","0.50","35.00","10","70","0.13","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("884","9","1","11","C","1.00","70.00","10","70","0.25","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("885","9","1","96","C","1.00","70.00","10","70","0.25","2025-03-09 10:26:46");
INSERT INTO ventas VALUES("886","9","1","2","C","1.00","70.00","10","70","0.25","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("887","9","1","96","C","1.00","70.00","10","70","0.25","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("888","9","1","16","C","0.75","55.00","10","70","0.19","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("889","9","1","9","C","0.25","17.00","10","70","0.06","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("890","9","1","18","C","0.75","55.00","10","70","0.19","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("891","9","1","2","C","0.25","17.00","10","70","0.06","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("892","9","1","99","C","0.25","17.00","10","70","0.06","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("893","9","1","94","C","0.25","17.00","10","70","0.06","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("894","9","1","53","C","0.25","17.00","10","70","0.06","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("895","9","1","14","C","0.50","35.00","10","70","0.13","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("896","9","1","41","C","0.50","35.00","10","70","0.13","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("897","9","1","9","C","0.50","35.00","10","70","0.13","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("898","9","1","90","C","0.50","35.00","10","70","0.13","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("899","9","1","2","C","1.00","70.00","10","70","0.25","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("900","9","1","18","C","0.50","35.00","10","70","0.13","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("901","9","1","96","C","0.50","35.00","10","70","0.13","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("902","9","1","18","C","0.50","35.00","10","70","0.13","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("903","9","1","96","C","0.50","35.00","10","70","0.13","2025-03-09 10:36:59");
INSERT INTO ventas VALUES("904","11","1","14","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("905","11","1","18","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("906","11","1","81","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("907","11","1","59","R","0.50","35.00","5","70","0.13","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("908","11","1","95","R","0.50","35.00","5","70","0.13","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("909","11","1","91","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("910","11","1","96","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("911","11","1","96","R","2.00","140.00","5","70","0.50","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("912","11","1","99","R","2.00","140.00","5","70","0.50","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("913","11","1","79","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("914","11","1","69","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("915","11","1","89","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("916","11","1","2","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("917","11","1","69","R","1.50","105.00","5","70","0.38","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("918","11","1","96","R","1.50","105.00","5","70","0.38","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("919","11","1","66","R","0.50","35.00","5","70","0.13","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("920","11","1","99","R","0.75","55.00","5","70","0.19","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("921","11","1","87","R","1.00","70.00","5","70","0.25","2025-03-09 10:42:51");
INSERT INTO ventas VALUES("922","9","1","80","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("923","9","1","90","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("924","9","1","50","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("925","9","1","14","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("926","9","1","66","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("927","9","1","94","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("928","9","1","55","X","2.00","140.00","10","70","0.50","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("929","9","1","14","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("930","9","1","67","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("931","9","1","12","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("932","9","1","38","X","0.75","55.00","10","70","0.19","2025-03-09 10:43:57");
INSERT INTO ventas VALUES("933","9","1","3","03","0.50","35.00","10","70","0.13","2025-03-09 10:45:11");
INSERT INTO ventas VALUES("934","9","1","30","03","0.50","35.00","10","70","0.13","2025-03-09 10:45:11");
INSERT INTO ventas VALUES("935","11","1","61","R","0.25","17.00","6","70","0.06","2025-03-09 10:46:36");
INSERT INTO ventas VALUES("936","11","1","39","R","0.50","35.00","6","70","0.13","2025-03-09 10:46:36");
INSERT INTO ventas VALUES("937","11","1","86","R","0.75","55.00","7","70","0.19","2025-03-09 10:48:16");
INSERT INTO ventas VALUES("938","11","1","20","R","0.25","17.00","8","70","0.06","2025-03-09 10:49:32");
INSERT INTO ventas VALUES("939","11","1","15","R","0.50","35.00","8","70","0.13","2025-03-09 10:49:32");
INSERT INTO ventas VALUES("940","28","1","14","X","2.00","160.00","2","80","0.30","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("941","28","1","15","X","2.00","160.00","2","80","0.30","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("942","28","1","2","X","2.00","160.00","2","80","0.30","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("943","28","1","17","X","2.00","160.00","2","80","0.30","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("944","28","1","16","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("945","28","1","61","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("946","28","1","96","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("947","28","1","61","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("948","28","1","14","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("949","28","1","6","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("950","28","1","16","X","1.50","120.00","2","80","0.23","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("951","28","1","67","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("952","28","1","NULL","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("953","28","1","6","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("954","28","1","NULL","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("955","28","1","2","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("956","28","1","79","X","1.00","80.00","2","80","0.15","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("957","28","1","9","X","1.50","120.00","2","80","0.23","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("958","28","1","31","X","0.50","40.00","2","80","0.08","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("959","28","1","68","X","0.25","20.00","2","80","0.04","2025-03-09 10:50:02");
INSERT INTO ventas VALUES("960","9","2","2","C","1.00","70.00","10","70","0.25","2025-03-09 13:20:44");
INSERT INTO ventas VALUES("961","9","2","94","C","1.00","70.00","10","70","0.25","2025-03-09 13:20:44");
INSERT INTO ventas VALUES("962","19","2","9","Angela","0.25","20.00","1","80","0.04","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("963","19","2","77","Angela","0.25","20.00","1","80","0.04","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("964","19","2","44","Angela","0.25","20.00","1","80","0.04","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("965","19","2","11","Angela","0.25","20.00","1","80","0.04","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("966","19","2","18","Angela","0.25","20.00","1","80","0.04","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("967","19","2","75","Angela","0.25","20.00","1","80","0.04","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("968","19","2","75","Marta","0.25","20.00","1","80","0.04","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("969","19","2","2","Xioma","1.00","80.00","1","80","0.15","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("970","19","2","77","Juan","0.50","40.00","1","80","0.08","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("971","19","2","32","Juan","0.50","40.00","1","80","0.08","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("972","19","2","73","Juan","0.50","40.00","1","80","0.08","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("973","19","2","60","Juan","0.50","40.00","1","80","0.08","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("974","19","2","96","Juan","0.50","40.00","1","80","0.08","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("975","19","2","3","Juan","1.00","80.00","1","80","0.15","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("976","19","2","4","Juan","0.50","40.00","1","80","0.08","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("977","19","2","79","Juan","0.50","40.00","1","80","0.08","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("978","19","2","28","Campo ","1.00","80.00","1","80","0.15","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("979","19","2","11","Juan ","0.50","40.00","1","80","0.08","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("980","19","2","3","Juan ","0.50","40.00","1","80","0.08","2025-03-09 14:47:11");
INSERT INTO ventas VALUES("981","19","2","53","Ana","0.50","40.00","2","80","0.08","2025-03-09 14:48:30");
INSERT INTO ventas VALUES("982","19","2","20","Ana","0.50","40.00","2","80","0.08","2025-03-09 14:48:30");
INSERT INTO ventas VALUES("983","19","2","77","Ana","0.50","40.00","2","80","0.08","2025-03-09 14:48:30");
INSERT INTO ventas VALUES("984","19","2","9","Ana","0.50","40.00","2","80","0.08","2025-03-09 14:48:30");
INSERT INTO ventas VALUES("985","19","2","17","Ana","0.50","40.00","2","80","0.08","2025-03-09 14:48:30");
INSERT INTO ventas VALUES("986","19","2","71","Ana","0.50","40.00","2","80","0.08","2025-03-09 14:48:30");
INSERT INTO ventas VALUES("987","19","2","46","Ana","0.50","40.00","2","80","0.08","2025-03-09 14:48:30");
INSERT INTO ventas VALUES("988","19","2","35","Ana","0.25","20.00","3","80","0.04","2025-03-09 14:49:59");
INSERT INTO ventas VALUES("989","19","2","2","Ana","0.25","20.00","3","80","0.04","2025-03-09 14:49:59");
INSERT INTO ventas VALUES("990","19","2","44","Ana","0.25","20.00","3","80","0.04","2025-03-09 14:49:59");
INSERT INTO ventas VALUES("991","28","2","12","X","0.75","60.00","1","80","0.11","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("992","28","2","11","X","0.50","40.00","1","80","0.08","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("993","28","2","21","X","0.75","60.00","1","80","0.11","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("994","28","2","96","X","5.00","400.00","1","80","0.75","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("995","28","2","3","X","3.00","240.00","1","80","0.45","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("996","28","2","14","X","1.00","80.00","1","80","0.15","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("997","28","2","15","X","1.00","80.00","1","80","0.15","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("998","28","2","2","X","2.00","160.00","1","80","0.30","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("999","28","2","34","X","0.50","40.00","1","80","0.08","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("1000","28","2","30","X","1.00","80.00","1","80","0.15","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("1001","28","2","14","X","2.00","160.00","1","80","0.30","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("1002","28","2","2","X","2.00","160.00","1","80","0.30","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("1003","28","2","14","X","0.50","40.00","1","80","0.08","2025-03-09 14:54:18");
INSERT INTO ventas VALUES("1004","9","3","66","C","0.50","35.00","6","70","0.13","2025-03-09 17:13:15");
INSERT INTO ventas VALUES("1005","9","3","96","C","0.50","35.00","6","70","0.13","2025-03-09 17:13:15");
INSERT INTO ventas VALUES("1006","9","3","94","C","1.00","70.00","6","70","0.25","2025-03-09 17:13:15");

