<?php
require '../config.php';
session_start(); // Asegúrate de iniciar la sesión

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_cliente = $_POST['id_cliente'];
    $id_auto = $_POST['id_auto'];
    $fecha_renta = $_POST['fecha_renta'];
    $fecha_devolucion = $_POST['fecha_devolucion'];
    $precio_total = $_POST['precio_total'];
    $estado = $_POST['estado'];

    // Obtener la hora actual
    $hora_actual = date('H:i:s');

    // Concatenar la hora actual a las fechas
    $fecha_check_in = $fecha_renta . ' ' . $hora_actual;
    $fecha_check_out = $fecha_devolucion . ' ' . $hora_actual;

    if ($estado == 'Reservado') { // Usar == para comparar
        $color = '#ffc107';
    } else if ($estado == 'Check-in') { // Usar == para comparar
        $color = '#28a745';
    } else {
        $color = '#dc3545';
    }
    // Obtén el ID del usuario desde la sesión
    $id_usuario = $_SESSION['usuario_id'];

    // Inserta la renta en la base de datos
    $sql = "INSERT INTO rentas (id_cliente, id_auto, id_usuario, fecha_renta, fecha_devolucion, precio_total, fecha_registro, estado, pago, color) 
            VALUES (?, ?, ?, ?, ?, ?, NOW(), ?, 'Pendiente', ?)";
    $stmt = $pdo->prepare($sql);

    if ($stmt->execute([$id_cliente, $id_auto, $id_usuario, $fecha_check_in, $fecha_check_out, $precio_total, $estado, $color])) {
        // Obtén el ID de la renta recién insertada
        $id_renta = $pdo->lastInsertId();

        // Actualizar el estado del auto en la tabla `autos`
        $sql_update_renta = "UPDATE habitaciones SET disponible = 'ocupada' WHERE id_habitacion = ?";
        $stmt_update_renta = $pdo->prepare($sql_update_renta);
        $stmt_update_renta->execute([$id_auto]);

        //Insertamamos datos a la Tabla reservaciones
       /* $sql = "INSERT INTO reservaciones (renta_id, habitacion_id, title, start, end) VALUES (renta_id,:title, :start, :end)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':start', $fecha_check_in);
        $stmt->bindParam(':end', $fecha_check_out);
        $stmt->execute();*/

        echo 'success';
    } else {
        echo 'error';
    }
}
?>
