<?php
session_start();
require '../config.php';

header('Content-Type: application/json');

// Consulta las reservas de la base de datos y obtiene los datos de la habitación
try {
    $sql = "SELECT 
                r.id_renta, 
                r.id_auto, 
                r.color, 
                r.fecha_renta, 
                r.fecha_devolucion, 
                h.nombre_habitacion, 
                h.numero_habitacion 
            FROM rentas r
            JOIN habitaciones h ON r.id_auto = h.id_habitacion"; // Haciendo JOIN con la tabla habitacion
    $stmt = $pdo->query($sql);
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Formatear las fechas antes de devolverlas
    foreach ($events as &$event) {
        // Convierte las fechas a un formato compatible con FullCalendar
        $event['start'] = date('Y-m-d\TH:i:s', strtotime($event['fecha_renta']));
        $event['end'] = date('Y-m-d\TH:i:s', strtotime($event['fecha_devolucion']));
        // Añadir el nombre y número de la habitación al título
        $event['title'] = $event['nombre_habitacion'] . " - " . $event['numero_habitacion'];
        // Pasar id_renta como id del evento
        $event['id'] = $event['id_renta']; // Asegúrate de que el id del evento corresponde al id_renta
    }

    echo json_encode($events);
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
