<?php
// Incluir archivo de configuración de la base de datos
include('../config.php'); // Asegúrate de que este archivo contiene la conexión PDO en la variable $conexion

try {
    // Consulta SQL para obtener habitaciones disponibles (estado = 1)
    $sql = "SELECT nombre_habitacion, numero_habitacion, tipo, precio_diario 
            FROM habitaciones
            WHERE disponible = 'disponible'";

    // Preparar y ejecutar la consulta
    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // Obtener resultados en un array asociativo
    $habitaciones = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Enviar respuesta en formato JSON
    echo json_encode($habitaciones);
} catch (PDOException $e) {
    // Manejo de errores en caso de falla en la consulta
    echo json_encode(['error' => 'Error al obtener las habitaciones: ' . $e->getMessage()]);
}
?>
