<?php
require '../config.php'; // Conexión a la base de datos

if (isset($_POST['id']) && isset($_POST['title']) && isset($_POST['start']) && isset($_POST['end'])) {
    $id = $_POST['id'];
    $title = $_POST['title'];
    $start = $_POST['start'];
    $end = $_POST['end'];

    try {
        $sql = "UPDATE reservaciones SET title = :title, start = :start, end = :end WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':start', $start);
        $stmt->bindParam(':end', $end);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        echo json_encode(['status' => 'success', 'message' => 'Evento actualizado correctamente']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Faltan datos requeridos']);
}
?>
