<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include '../config.php'; // Conexión a la base de datos
    $id_huesped = $_POST['id_huesped'] ?? null;

    if ($id_huesped) {
        $stmt = $pdo->prepare("DELETE FROM huespedes WHERE id_huesped = :id_huesped");
        $stmt->bindParam(':id_huesped', $id_huesped, PDO::PARAM_INT);

        if ($stmt->execute()) {
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No se pudo eliminar el huésped.']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'ID de huésped no válido.']);
    }
    exit;
}
